/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.client.CachedEdge;
import dev.ftb.mods.ftbultimine.client.UltimineRenderTypes;
import dev.ftb.mods.ftbultimine.event.LevelRenderLastEvent;
import dev.ftb.mods.ftbultimine.net.FTBUltimineNet;
import dev.ftb.mods.ftbultimine.net.KeyPressedPacket;
import dev.ftb.mods.ftbultimine.net.ModeChangedPacket;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.utils.AccessUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.client.ClientRawInputEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.registry.KeyBindings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class FTBUltimineClient
extends FTBUltimineCommon {
    private final KeyBinding keyBinding;
    private boolean pressed;
    private List<BlockPos> shapeBlocks = Collections.emptyList();
    private List<CachedEdge> cachedEdges = null;
    public boolean hasScrolled = false;
    private long lastToggle = 0L;
    private final int INPUT_DELAY = 125;
    private final int infoOffset = 0;

    public FTBUltimineClient() {
        this.keyBinding = new KeyBinding("key.ftbultimine", InputMappings.Type.KEYSYM, 96, "key.categories.ftbultimine");
        KeyBindings.registerKeyBinding((KeyBinding)this.keyBinding);
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        GuiEvent.RENDER_HUD.register(this::renderGameOverlay);
        LevelRenderLastEvent.EVENT.register(this::renderInGame);
        ClientRawInputEvent.MOUSE_SCROLLED.register(this::mouseEvent);
        ClientRawInputEvent.KEY_PRESSED.register(this::onKeyPress);
    }

    @Override
    public void setShape(List<BlockPos> blocks) {
        this.shapeBlocks = blocks;
        this.cachedEdges = null;
        this.updateEdges();
    }

    public void renderInGame(MatrixStack stack) {
        if (!this.pressed || this.cachedEdges == null || this.cachedEdges.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!FTBUltimine.instance.canUltimine((PlayerEntity)mc.field_71439_g)) {
            return;
        }
        ActiveRenderInfo activeRenderInfo = mc.func_175598_ae().field_217783_c;
        Vector3d projectedView = activeRenderInfo.func_216785_c();
        stack.func_227860_a_();
        stack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        IVertexBuilder buffer = mc.func_228019_au_().func_228487_b_().getBuffer(UltimineRenderTypes.LINES_NORMAL);
        for (CachedEdge edge : this.cachedEdges) {
            buffer.func_227888_a_(matrix, edge.x1, edge.y1, edge.z1).func_225586_a_(255, 255, 255, 255).func_181675_d();
            buffer.func_227888_a_(matrix, edge.x2, edge.y2, edge.z2).func_225586_a_(255, 255, 255, 255).func_181675_d();
        }
        mc.func_228019_au_().func_228487_b_().func_228462_a_(UltimineRenderTypes.LINES_NORMAL);
        IVertexBuilder buffer2 = mc.func_228019_au_().func_228487_b_().getBuffer(UltimineRenderTypes.LINES_TRANSPARENT);
        for (CachedEdge edge : this.cachedEdges) {
            buffer2.func_227888_a_(matrix, edge.x1, edge.y1, edge.z1).func_225586_a_(255, 255, 255, 10).func_181675_d();
            buffer2.func_227888_a_(matrix, edge.x2, edge.y2, edge.z2).func_225586_a_(255, 255, 255, 10).func_181675_d();
        }
        mc.func_228019_au_().func_228487_b_().func_228462_a_(UltimineRenderTypes.LINES_TRANSPARENT);
        stack.func_227865_b_();
    }

    public ActionResultType mouseEvent(Minecraft client, double amount) {
        if (this.pressed && amount != 0.0 && this.sneak()) {
            this.hasScrolled = true;
            FTBUltimineNet.MAIN.sendToServer((Object)new ModeChangedPacket(amount < 0.0));
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType onKeyPress(Minecraft client, int keyCode, int scanCode, int action, int modifiers) {
        if (System.currentTimeMillis() - this.lastToggle < 125L) {
            return ActionResultType.PASS;
        }
        if (keyCode != 265 && keyCode != 264) {
            return ActionResultType.PASS;
        }
        if (!this.pressed || !this.sneak()) {
            return ActionResultType.PASS;
        }
        this.hasScrolled = true;
        FTBUltimineNet.MAIN.sendToServer((Object)new ModeChangedPacket(keyCode == 264));
        this.lastToggle = System.currentTimeMillis();
        return ActionResultType.PASS;
    }

    private boolean sneak() {
        return AccessUtil.getKey(this.keyBinding).func_197937_c() == 340 || AccessUtil.getKey(this.keyBinding).func_197937_c() == 344 ? Screen.func_231172_r_() : Screen.func_231173_s_();
    }

    private void addPressedInfo(List<IFormattableTextComponent> list) {
        list.add((IFormattableTextComponent)new TranslationTextComponent("ftbultimine.active"));
        if (!this.hasScrolled) {
            list.add(new TranslationTextComponent("ftbultimine.change_shape").func_240699_a_(TextFormatting.GRAY));
        }
        if (SendShapePacket.current != null) {
            if (this.sneak()) {
                list.add((IFormattableTextComponent)new StringTextComponent(""));
                list.add(new StringTextComponent("^ ").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new TranslationTextComponent("ftbultimine.shape." + SendShapePacket.current.prev.getName())));
            }
            list.add(new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent("ftbultimine.shape." + SendShapePacket.current.getName())));
            if (this.sneak()) {
                list.add(new StringTextComponent("v ").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new TranslationTextComponent("ftbultimine.shape." + SendShapePacket.current.next.getName())));
            }
        }
    }

    public void renderGameOverlay(MatrixStack matrices, float tickDelta) {
        if (this.pressed) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
            this.addPressedInfo(list);
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.field_71466_p.getClass();
            int top = 2 + 9 * 0;
            for (IFormattableTextComponent msg : list) {
                int n = 2 + minecraft.field_71466_p.func_78256_a(msg.getString()) + 1;
                minecraft.field_71466_p.getClass();
                AbstractGui.func_238467_a_((MatrixStack)matrices, (int)1, (int)(top - 1), (int)n, (int)(top + 9 - 1), (int)-1873784752);
                minecraft.field_71466_p.func_243246_a(matrices, (ITextComponent)msg, 2.0f, (float)top, 0xE0E0E0);
                minecraft.field_71466_p.getClass();
                top += 9;
            }
        }
    }

    public void clientTick(Minecraft mc) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        boolean p = this.pressed;
        this.pressed = this.keyBinding.func_151470_d();
        if (this.pressed != p) {
            FTBUltimineNet.MAIN.sendToServer((Object)new KeyPressedPacket(this.pressed));
        }
    }

    private void updateEdges() {
        if (this.cachedEdges != null) {
            return;
        }
        if (this.shapeBlocks.isEmpty()) {
            this.cachedEdges = Collections.emptyList();
            return;
        }
        BlockPos pos = this.shapeBlocks.get(0);
        double d = 0.005;
        VoxelShape shape = VoxelShapes.func_197873_a((double)(-d), (double)(-d), (double)(-d), (double)(1.0 + d), (double)(1.0 + d), (double)(1.0 + d));
        VoxelShape[] extraShapes = new VoxelShape[this.shapeBlocks.size() - 1];
        for (int i = 1; i < this.shapeBlocks.size(); ++i) {
            BlockPos p = this.shapeBlocks.get(i);
            extraShapes[i - 1] = shape.func_197751_a((double)(p.func_177958_n() - pos.func_177958_n()), (double)(p.func_177956_o() - pos.func_177956_o()), (double)(p.func_177952_p() - pos.func_177952_p()));
        }
        this.cachedEdges = new ArrayList<CachedEdge>();
        (extraShapes.length == 0 ? shape : VoxelShapes.func_216384_a((VoxelShape)shape, (VoxelShape[])extraShapes)).func_197754_a((x1, y1, z1, x2, y2, z2) -> {
            CachedEdge edge = new CachedEdge();
            edge.x1 = (float)(x1 + (double)pos.func_177958_n());
            edge.y1 = (float)(y1 + (double)pos.func_177956_o());
            edge.z1 = (float)(z1 + (double)pos.func_177952_p());
            edge.x2 = (float)(x2 + (double)pos.func_177958_n());
            edge.y2 = (float)(y2 + (double)pos.func_177956_o());
            edge.z2 = (float)(z2 + (double)pos.func_177952_p());
            this.cachedEdges.add(edge);
        });
    }
}

