/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.config;

import dev.ftb.mods.ftbultimine.FTBUltimine;
import java.io.File;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.MathHelper;

@Config(name="ftbultimine")
@Config.Gui.Background(value="minecraft:textures/block/stone.png")
public class FTBUltimineConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    private static ConfigHolder<FTBUltimineConfig> holder = null;
    @Comment(value="Max amount of blocks that can be ultimined at once\nRange: 1 - 32768")
    public int maxBlocks = 64;
    @Comment(value="Hunger multiplied for each block mined with ultimine\nRange: 0 - 10000")
    public double exhaustionPerBlock = 20.0;
    @Comment(value="Groups stone types together so you can mine all of them at once")
    public boolean mergeStone = true;
    @Comment(value="Disable warnings for potentially laggy config settings")
    public boolean noLagWarnings = false;
    @Comment(value="Manual x offset of FTB Ultimine overlay, required for some modpacks")
    @ConfigEntry.Gui.Excluded
    public int renderTextManually = -1;
    @Comment(value="Render the white outline around blocks to be mined\nShould be disabled for more than 512 blocks!")
    public boolean renderOutline = true;

    public static FTBUltimineConfig get() {
        return (FTBUltimineConfig)holder.get();
    }

    public static void init() {
        holder = AutoConfig.register(FTBUltimineConfig.class, JanksonConfigSerializer::new);
        holder.registerLoadListener((manager, data) -> {
            File oldConfig = Platform.getConfigFolder().resolve("ftbultimine-common.toml").toFile();
            if (oldConfig.exists()) {
                FTBUltimine.LOGGER.warn("Old config file ftbultimine-common.toml found, please use the new config format instead!");
                FTBUltimine.LOGGER.warn("The old config file will automatically be deleted on exit.");
                oldConfig.deleteOnExit();
            }
            return ActionResultType.PASS;
        });
        holder.registerSaveListener((manager, data) -> {
            data.validatePostLoad();
            return ActionResultType.PASS;
        });
    }

    public void validatePostLoad() {
        int outlineBlockWarning;
        this.maxBlocks = MathHelper.func_76125_a((int)this.maxBlocks, (int)1, (int)32768);
        if (!this.noLagWarnings && this.maxBlocks > 8192) {
            FTBUltimine.LOGGER.warn("maxBlocks is set to more than 8192 blocks!");
            FTBUltimine.LOGGER.warn("This may cause a lot of tick and FPS lag!");
        }
        this.exhaustionPerBlock = MathHelper.func_151237_a((double)this.exhaustionPerBlock, (double)0.0, (double)10000.0);
        int n = outlineBlockWarning = Platform.isModLoaded((String)"lithium") ? 512 : 256;
        if (!this.noLagWarnings && this.renderOutline && this.maxBlocks > outlineBlockWarning) {
            FTBUltimine.LOGGER.warn("Outline rendering is enabled for more than {} blocks per excavation!", (Object)outlineBlockWarning);
            FTBUltimine.LOGGER.warn("This will almost definitely cause a lot of FPS lag!");
        }
    }
}

