/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class PlayerUtils {
    public static boolean isPlayerReal(Entity player) {
        return player != null && player.field_70170_p != null && player.getClass() == ServerPlayerEntity.class;
    }

    public static UUID fixStrippedUUID(String uuidString) {
        return uuidString.length() != 32 ? null : UUID.fromString(uuidString.substring(0, 8) + "-" + uuidString.substring(8, 12) + "-" + uuidString.substring(12, 16) + "-" + uuidString.substring(16, 20) + "-" + uuidString.substring(20, 32));
    }

    public static boolean playerHasItem(PlayerEntity player, Item item) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !stack.func_77973_b().equals(item)) continue;
            return true;
        }
        for (EquipmentSlotType slotType : EquipmentSlotType.values()) {
            if (player.func_184582_a(slotType).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getStacksFromPlayer(PlayerEntity player, Item item) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != item) continue;
            items.add(stack);
        }
        for (EquipmentSlotType slotType : EquipmentSlotType.values()) {
            ItemStack stack = player.func_184582_a(slotType);
            if (stack.func_77973_b() != item) continue;
            items.add(stack);
        }
        return items;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ClientPlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isPlayerInGame() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g != null && mc.field_71441_e != null && mc.field_71439_g.field_70170_p != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static UUID getClientUUID() {
        return PlayerUtils.fixStrippedUUID(Minecraft.func_71410_x().func_110432_I().func_148255_b());
    }

    public static boolean isPlayerDamage(DamageSource source) {
        return source != null && source.func_76346_g() instanceof PlayerEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceLocation getPlayerTexture(GameProfile profile) {
        if (profile != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            Map map = minecraft.func_152342_ad().func_152788_a(profile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                return minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            }
            return DefaultPlayerSkin.func_177334_a((UUID)PlayerEntity.func_146094_a((GameProfile)profile));
        }
        return DefaultPlayerSkin.func_177335_a();
    }
}

