/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.ClientTicker;

@OnlyIn(value=Dist.CLIENT)
public final class RenderHelper {
    public static void renderStar(int color, float scale, long seed) {
        RenderHelper.renderStar(color, scale, scale, scale, seed);
    }

    public static void renderStar(int color, float xScale, float yScale, float zScale, long seed) {
        Tessellator tessellator = Tessellator.func_178181_a();
        float ticks = (float)(ClientTicker.ticksInGame % 200) + ClientTicker.partialTicks;
        if (ticks >= 100.0f) {
            ticks = 200.0f - ticks - 1.0f;
        }
        float f1 = ticks / 200.0f;
        float f2 = 0.0f;
        if (f1 > 0.7f) {
            f2 = (f1 - 0.7f) / 0.2f;
        }
        Random random = new Random(seed);
        RenderSystem.pushMatrix();
        RenderSystem.disableTexture();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.disableAlphaTest();
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.scalef((float)xScale, (float)yScale, (float)zScale);
        int i = 0;
        while ((float)i < (f1 + f1 * f1) / 2.0f * 90.0f + 30.0f) {
            RenderSystem.rotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.rotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.rotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.rotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.rotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.rotatef((float)(random.nextFloat() * 360.0f + f1 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_178180_c().func_181668_a(6, DefaultVertexFormats.field_181706_f);
            float f3 = random.nextFloat() * 20.0f + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + f2 * 2.0f;
            float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((color & 0xFF00) >> 8) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            tessellator.func_178180_c().func_225582_a_(0.0, 0.0, 0.0).func_227885_a_(r, g, b, 1.0f - f2).func_181675_d();
            tessellator.func_178180_c().func_225582_a_(-0.866 * (double)f4, (double)f3, (double)(-0.5f * f4)).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_178180_c().func_225582_a_(0.866 * (double)f4, (double)f3, (double)(-0.5f * f4)).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_178180_c().func_225582_a_(0.0, (double)f3, (double)(1.0f * f4)).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_178180_c().func_225582_a_(-0.866 * (double)f4, (double)f3, (double)(-0.5f * f4)).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
            ++i;
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.disableBlend();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableTexture();
        RenderSystem.enableAlphaTest();
        RenderSystem.popMatrix();
    }

    public static String getKeyDisplayString(String keyName) {
        KeyBinding[] keys;
        String key = null;
        for (KeyBinding otherKey : keys = Minecraft.func_71410_x().field_71474_y.field_74324_K) {
            if (!otherKey.func_151464_g().equals(keyName)) continue;
            key = otherKey.func_197982_m();
            break;
        }
        return I18n.func_135052_a(key, (Object[])new Object[0]);
    }
}

