/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="illagers_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModConfig {
    public static final Config COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static int archerTowerMinDist;
    public static int archerTowerMaxDist;
    public static int centreMinDist;
    public static int centreMaxDist;
    public static int fortMinDist;
    public static int fortMaxDist;
    public static int mineMinDist;
    public static int mineMaxDist;
    public static int towerMinDist;
    public static int towerMaxDist;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            ModConfig.bakeConfig();
        }
    }

    public static void bakeConfig() {
        archerTowerMinDist = (Integer)ModConfig.COMMON.archerTowerMinDist.get();
        archerTowerMaxDist = (Integer)ModConfig.COMMON.archerTowerMaxDist.get();
        centreMinDist = (Integer)ModConfig.COMMON.centreMinDist.get();
        centreMaxDist = (Integer)ModConfig.COMMON.centreMaxDist.get();
        fortMinDist = (Integer)ModConfig.COMMON.fortMinDist.get();
        fortMaxDist = (Integer)ModConfig.COMMON.fortMaxDist.get();
        mineMinDist = (Integer)ModConfig.COMMON.mineMinDist.get();
        mineMaxDist = (Integer)ModConfig.COMMON.mineMaxDist.get();
        towerMinDist = (Integer)ModConfig.COMMON.towerMinDist.get();
        towerMaxDist = (Integer)ModConfig.COMMON.towerMaxDist.get();
    }

    public static int getArcherTowerMinDist() {
        return archerTowerMinDist;
    }

    public static int getArcherTowerMaxDist() {
        return archerTowerMaxDist;
    }

    public static int getCentreMinDist() {
        return centreMinDist;
    }

    public static int getCentreMaxDist() {
        return centreMaxDist;
    }

    public static int getFortMinDist() {
        return fortMinDist;
    }

    public static int getFortMaxDist() {
        return fortMaxDist;
    }

    public static int getMineMinDist() {
        return mineMinDist;
    }

    public static int getMineMaxDist() {
        return mineMaxDist;
    }

    public static int getTowerMinDist() {
        return towerMinDist;
    }

    public static int getTowerMaxDist() {
        return towerMaxDist;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
    }

    public static class Config {
        public final ForgeConfigSpec.IntValue archerTowerMinDist;
        public final ForgeConfigSpec.IntValue archerTowerMaxDist;
        public final ForgeConfigSpec.IntValue centreMinDist;
        public final ForgeConfigSpec.IntValue centreMaxDist;
        public final ForgeConfigSpec.IntValue fortMinDist;
        public final ForgeConfigSpec.IntValue fortMaxDist;
        public final ForgeConfigSpec.IntValue mineMinDist;
        public final ForgeConfigSpec.IntValue mineMaxDist;
        public final ForgeConfigSpec.IntValue towerMinDist;
        public final ForgeConfigSpec.IntValue towerMaxDist;

        public Config(ForgeConfigSpec.Builder builder) {
            builder.push("Structure Feature Distance Values");
            builder.comment("NOTE: THE MINIMUM SPREAD DISTANCE CANNOT BE GREATER THAN THE MAXIMUM SPREAD DISTANCE!");
            this.archerTowerMinDist = builder.comment("Archer Tower: Minimum spread dist").translation("illagers_plus.config.atMin").defineInRange("archerTowerMinDist", 60, 1, 256);
            this.archerTowerMaxDist = builder.comment("Archer Tower: Maximum spread dist").translation("illagers_plus.config.atMax").defineInRange("archerTowerMaxDist", 90, 1, 256);
            this.centreMinDist = builder.comment("Centre: Minimum spread dist").translation("illagers_plus.config.cMin").defineInRange("centreMinDist", 60, 1, 256);
            this.centreMaxDist = builder.comment("Centre: Maximum spread dist").translation("illagers_plus.config.cMax").defineInRange("centreMaxDist", 90, 1, 256);
            this.fortMinDist = builder.comment("Fort: Minimum spread dist").translation("illagers_plus.config.fMin").defineInRange("fortMinDist", 60, 1, 256);
            this.fortMaxDist = builder.comment("Fort: Maximum spread dist").translation("illagers_plus.config.fMax").defineInRange("fortMaxDist", 90, 1, 256);
            this.mineMinDist = builder.comment("Mine: Minimum spread dist").translation("illagers_plus.config.mMin").defineInRange("mineMinDist", 75, 1, 256);
            this.mineMaxDist = builder.comment("Mine: Maximum spread dist").translation("illagers_plus.config.mMax").defineInRange("mineMaxDist", 90, 1, 256);
            this.towerMinDist = builder.comment("Tower: Minimum spread dist").translation("illagers_plus.config.tMin").defineInRange("towerMinDist", 75, 1, 256);
            this.towerMaxDist = builder.comment("Tower: Maximum spread dist").translation("illagers_plus.config.tMax").defineInRange("towerMaxDist", 90, 1, 256);
            builder.pop();
        }
    }
}

