/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.world.structures.pieces;

import com.litewolf101.illagers_plus.init.EntityInit;
import com.litewolf101.illagers_plus.objects.entity.EntityAbstractIllagerPlus;
import com.litewolf101.illagers_plus.objects.entity.EntityBlackIronGolem;
import com.litewolf101.illagers_plus.objects.entity.EntityFurantur;
import com.litewolf101.illagers_plus.utils.IllagerPlusLootTable;
import com.litewolf101.illagers_plus.world.ModStructurePieceTypes;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PaneBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class IllagerCentrePieces {
    public static final ResourceLocation piece = new ResourceLocation("illagers_plus", "illager_centre");

    public static void createCentre(TemplateManager manager, BlockPos pos, List<StructurePiece> components, Random random) {
        CentrePiece start = new CentrePiece(piece, manager, pos);
        components.add((StructurePiece)start);
    }

    public static class CentrePiece
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public CentrePiece(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ICP, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public CentrePiece(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ICP, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            EntityAbstractIllagerPlus entity;
            if ("spawnFurantur".equals(function)) {
                entity = (EntityFurantur)EntityInit.FURANTUR.func_200721_a((World)worldIn.func_201672_e());
                entity.func_110163_bv();
                entity.func_174828_a(pos, 0.0f, 0.0f);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Vector3i)entity.func_233580_cy_())), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)entity);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if ("spawnEvoker".equals(function)) {
                entity = (EvokerEntity)EntityType.field_200806_t.func_200721_a((World)worldIn.func_201672_e());
                entity.func_110163_bv();
                entity.func_174828_a(pos, 0.0f, 0.0f);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Vector3i)entity.func_233580_cy_())), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)entity);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if ("spawnBlackIronGolem".equals(function)) {
                entity = (EntityBlackIronGolem)EntityInit.BLACK_IRON_GOLEM.func_200721_a((World)worldIn.func_201672_e());
                entity.func_110163_bv();
                entity.func_174828_a(pos, 0.0f, 0.0f);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Vector3i)entity.func_233580_cy_())), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)entity);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if ("spawnChest".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.ILLAGER_CENTRE, Blocks.field_150486_ae.func_176223_P());
            }
            if ("gate".equals(function) && rand.nextInt(10) < 5) {
                for (int x = 0; x <= 3; ++x) {
                    for (int z = 0; z <= 1; ++z) {
                        for (int y = 0; y <= 4; ++y) {
                            worldIn.func_180501_a(pos.func_177982_a(x, y, z), (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 2);
                        }
                    }
                }
            }
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }
    }
}

