/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import de.maxhenkel.voicechat.corelib.config.ConfigBase;
import de.maxhenkel.voicechat.voice.client.HUDIconLocation;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig
extends ConfigBase {
    public final ForgeConfigSpec.DoubleValue voiceChatVolume;
    public final ForgeConfigSpec.DoubleValue voiceActivationThreshold;
    public final ForgeConfigSpec.DoubleValue microphoneAmplification;
    public final ForgeConfigSpec.EnumValue<MicrophoneActivationType> microphoneActivationType;
    public final ForgeConfigSpec.IntValue outputBufferSize;
    public final ForgeConfigSpec.IntValue deactivationDelay;
    public final ForgeConfigSpec.ConfigValue<String> microphone;
    public final ForgeConfigSpec.ConfigValue<String> speaker;
    public final ForgeConfigSpec.BooleanValue muted;
    public final ForgeConfigSpec.BooleanValue disabled;
    public final ForgeConfigSpec.BooleanValue stereo;
    public final ForgeConfigSpec.BooleanValue hideIcons;
    public final ForgeConfigSpec.BooleanValue showGroupHUD;
    public final ForgeConfigSpec.EnumValue<HUDIconLocation> hudIconLocation;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        super(builder);
        this.microphoneActivationType = builder.comment("Microphone activation type").defineEnum("microphone_activation_type", (Enum)MicrophoneActivationType.PTT);
        this.voiceActivationThreshold = builder.comment("The threshold for voice activation in dB").defineInRange("voice_activation_threshold", -50.0, -127.0, 0.0);
        this.voiceChatVolume = builder.comment("The voice chat volume").defineInRange("voice_chat_volume", 1.0, 0.0, 2.0);
        this.microphoneAmplification = builder.comment("The voice chat microphone amplification").defineInRange("microphone_amplification", 1.0, 0.0, 4.0);
        this.outputBufferSize = builder.comment(new String[]{"The size of the audio output buffer in packets", "Higher values mean a higher latency, but less crackles", "Increase this value if you have an unstable internet connection"}).defineInRange("output_buffer_size", 6, 1, 16);
        this.deactivationDelay = builder.comment(new String[]{"The time it takes for the microphone to deactivate when using voice activation", "A value of 1 means 20 milliseconds, 2=40 ms, 3=60 ms, ..."}).defineInRange("voice_deactivation_delay", 25, 0, 100);
        this.microphone = builder.comment(new String[]{"The microphone used by the voice chat", "Empty for default device"}).define("microphone", (Object)"");
        this.speaker = builder.comment(new String[]{"The microphone used by the voice chat", "Empty for default device"}).define("speaker", (Object)"");
        this.muted = builder.comment("If the microphone is muted (only when using voice activation)").define("muted", false);
        this.disabled = builder.comment("If the voice chat is disabled (sound and microphone off)").define("disabled", false);
        this.stereo = builder.comment("If the voice chat should use semi 3D stereo sound").define("stereo", true);
        this.hideIcons = builder.comment("If the voice chat icons should be hidden").define("hide_icons", false);
        this.showGroupHUD = builder.comment("If the group HUD should be visible").define("show_group_hud", true);
        this.hudIconLocation = builder.comment("The location of the HUD icons").defineEnum("hud_icon_location", (Enum)HUDIconLocation.LEFT);
    }
}

