/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.corelib.fluid;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FluidUtils {
    public static boolean isFluidHandler(IBlockReader world, BlockPos pos, Direction direction) {
        return FluidUtils.getFluidHandler(world, pos, direction) != null;
    }

    public static boolean isFluidHandlerOffset(IBlockReader world, BlockPos pos, Direction direction) {
        return FluidUtils.getFluidHandlerOffset(world, pos, direction) != null;
    }

    @Nullable
    public static IFluidHandler getFluidHandler(IBlockReader world, BlockPos pos, Direction direction) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction).orElse(null);
    }

    @Nullable
    public static IFluidHandler getFluidHandlerOffset(IBlockReader world, BlockPos pos, Direction direction) {
        return FluidUtils.getFluidHandler(world, pos.func_177972_a(direction), direction.func_176734_d());
    }

    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer, @Nullable Fluid filter) {
        int fillableAmount;
        FluidStack drainable = filter == null ? fluidSource.drain(maxAmount, IFluidHandler.FluidAction.SIMULATE) : fluidSource.drain(new FluidStack(filter, maxAmount), IFluidHandler.FluidAction.SIMULATE);
        if (drainable.getAmount() > 0 && (fillableAmount = fluidDestination.fill(drainable, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            if (doTransfer) {
                FluidStack drained = filter == null ? fluidSource.drain(fillableAmount, IFluidHandler.FluidAction.EXECUTE) : fluidSource.drain(new FluidStack(filter, fillableAmount), IFluidHandler.FluidAction.EXECUTE);
                drained.setAmount(fluidDestination.fill(drained, IFluidHandler.FluidAction.EXECUTE));
                return drained;
            }
            drainable.setAmount(fillableAmount);
            return drainable;
        }
        return FluidStack.EMPTY;
    }

    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        return FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)fluidSource, (int)maxAmount, (boolean)doTransfer);
    }

    public static boolean tryFluidInteraction(PlayerEntity player, Hand hand, World world, BlockPos pos) {
        ItemStack stack = player.func_184586_b(hand);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
        if (!fluidStack.isEmpty() && FluidUtils.handleEmpty((IBlockReader)world, pos, player, hand)) {
            return true;
        }
        IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
        return handler != null && FluidUtils.handleFill((IBlockReader)world, pos, player, hand);
    }

    public static boolean handleEmpty(IBlockReader world, BlockPos pos, PlayerEntity player, Hand hand) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)te;
        InvWrapper inv = new InvWrapper((IInventory)player.field_71071_by);
        ItemStack stack = player.func_184586_b(hand);
        FluidActionResult res = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
        if (res.isSuccess()) {
            player.func_184611_a(hand, res.result);
            return true;
        }
        return false;
    }

    public static boolean handleFill(IBlockReader world, BlockPos pos, PlayerEntity player, Hand hand) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler blockHandler = (IFluidHandler)te;
        InvWrapper inv = new InvWrapper((IInventory)player.field_71071_by);
        ItemStack stack = player.func_184586_b(hand);
        FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)blockHandler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
        if (result.isSuccess()) {
            player.func_184611_a(hand, result.result);
            return true;
        }
        return false;
    }
}

