/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.corelib.client.PlayerSkins;
import de.maxhenkel.voicechat.gui.GroupScreen;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.widgets.WidgetBase;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class CreateGroupList
extends WidgetBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_create_group.png");
    protected Supplier<List<PlayerState>> playerStates;
    protected int offset;
    private VoiceChatScreenBase.HoverArea[] hoverAreas;
    private int columnHeight;
    private int columnCount;

    public CreateGroupList(VoiceChatScreenBase screen, int posX, int posY, int xSize, int ySize, Supplier<List<PlayerState>> playerStates) {
        super(screen, posX, posY, xSize, ySize);
        this.playerStates = playerStates;
        this.columnHeight = 22;
        this.columnCount = 4;
        this.hoverAreas = new VoiceChatScreenBase.HoverArea[this.columnCount];
        for (int i = 0; i < this.hoverAreas.length; ++i) {
            this.hoverAreas[i] = new VoiceChatScreenBase.HoverArea(0, i * this.columnHeight, xSize, this.columnHeight);
        }
    }

    public List<Group> getGroups() {
        HashMap<String, Group> groups = new HashMap<String, Group>();
        List<PlayerState> playerStates = this.playerStates.get();
        for (PlayerState state : playerStates) {
            if (!state.hasGroup()) continue;
            Group group = groups.getOrDefault(state.getGroup(), new Group(state.getGroup()));
            group.members.add(state);
            group.members.sort(Comparator.comparing(o -> o.getGameProfile().getName()));
            groups.put(state.getGroup(), group);
        }
        return new ArrayList<Group>(groups.values());
    }

    @Override
    public void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        List<Group> entries = this.getGroups();
        for (int i = this.getOffset(); i < entries.size() && i < this.getOffset() + this.columnCount; ++i) {
            int pos = i - this.getOffset();
            VoiceChatScreenBase.HoverArea hoverArea = this.hoverAreas[pos];
            int startY = this.guiTop + pos * this.columnHeight;
            Group group = entries.get(i);
            StringTextComponent groupName = new StringTextComponent(group.name);
            this.mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)groupName, (float)(this.guiLeft + 3), (float)(startY + 7), 0);
            int textWidth = this.mc.field_71466_p.func_238414_a_((ITextProperties)groupName);
            int headsPerRow = (this.xSize - (3 + textWidth + 3 + 3)) / 9;
            for (int j = 0; j < group.members.size(); ++j) {
                PlayerState state = (PlayerState)group.members.get(j);
                int headXIndex = j % headsPerRow;
                int headYIndex = j / headsPerRow;
                if (headYIndex > 1) break;
                int headPosX = this.guiLeft + this.xSize - 8 - 2 - headXIndex * 9;
                int headPosY = startY + 2 + 10 - 10 * headYIndex;
                matrixStack.func_227860_a_();
                this.mc.func_110434_K().func_110577_a(PlayerSkins.getSkin(state.getGameProfile()));
                matrixStack.func_227861_a_((double)headPosX, (double)headPosY, 0.0);
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
                matrixStack.func_227865_b_();
            }
            if (!hoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) continue;
            ArrayList<IReorderingProcessor> tooltip = new ArrayList<IReorderingProcessor>();
            tooltip.add(new TranslationTextComponent("message.voicechat.group_members").func_240699_a_(TextFormatting.WHITE).func_241878_f());
            for (PlayerState state : group.members) {
                tooltip.add(new StringTextComponent("- " + state.getGameProfile().getName()).func_240699_a_(TextFormatting.GRAY).func_241878_f());
            }
            this.screen.func_238654_b_(matrixStack, tooltip, mouseX, mouseY);
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        List<Group> entries = this.getGroups();
        for (int i = this.getOffset(); i < entries.size() && i < this.getOffset() + this.columnCount; ++i) {
            this.mc.func_110434_K().func_110577_a(TEXTURE);
            int pos = i - this.getOffset();
            VoiceChatScreenBase.HoverArea hoverArea = this.hoverAreas[pos];
            boolean hovered = hoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY);
            int startY = this.guiTop + pos * this.columnHeight;
            Group group = entries.get(i);
            if (hovered) {
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)this.guiLeft, (int)startY, (float)195.0f, (float)39.0f, (int)160, (int)this.columnHeight, (int)512, (int)512);
                continue;
            }
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)this.guiLeft, (int)startY, (float)195.0f, (float)17.0f, (int)160, (int)this.columnHeight, (int)512, (int)512);
        }
        this.mc.func_110434_K().func_110577_a(TEXTURE);
        if (entries.size() > this.columnCount) {
            float h = this.ySize - 17;
            float perc = (float)this.getOffset() / (float)(entries.size() - this.columnCount);
            int posY = this.guiTop + (int)(h * perc);
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + this.xSize + 6), (int)posY, (float)195.0f, (float)0.0f, (int)12, (int)17, (int)512, (int)512);
        } else {
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + this.xSize + 6), (int)this.guiTop, (float)207.0f, (float)0.0f, (int)12, (int)17, (int)512, (int)512);
        }
    }

    public int getOffset() {
        List<Group> entries = this.getGroups();
        if (entries.size() <= this.columnCount) {
            this.offset = 0;
        } else if (this.offset > entries.size() - this.columnCount) {
            this.offset = entries.size() - this.columnCount;
        }
        return this.offset;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        List<Group> entries = this.getGroups();
        if (entries.size() > this.columnCount) {
            this.offset = delta < 0.0 ? Math.min(this.getOffset() + 1, entries.size() - this.columnCount) : Math.max(this.getOffset() - 1, 0);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        List<Group> entries = this.getGroups();
        for (int i = 0; i < this.hoverAreas.length && this.getOffset() + i < entries.size(); ++i) {
            if (!this.hoverAreas[i].isHovered(this.guiLeft, this.guiTop, (int)mouseX, (int)mouseY)) continue;
            Group group = entries.get(this.getOffset() + i);
            this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            Main.CLIENT_VOICE_EVENTS.getPlayerStateManager().setGroup(group.name);
            this.mc.func_147108_a((Screen)new GroupScreen());
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public static class Group {
        private String name;
        private List<PlayerState> members;

        public Group(String name) {
            this.name = name;
            this.members = new ArrayList<PlayerState>();
        }
    }
}

