/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.corelib.client.PlayerSkins;
import de.maxhenkel.voicechat.gui.AdjustVolumeScreen;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.widgets.WidgetBase;
import de.maxhenkel.voicechat.voice.client.Client;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GroupList
extends WidgetBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_group.png");
    private static final ResourceLocation SPEAKER_OFF = new ResourceLocation("voicechat", "textures/gui/speaker_off.png");
    private static final ResourceLocation SPEAKER = new ResourceLocation("voicechat", "textures/gui/speaker.png");
    private static final ResourceLocation CHANGE_VOLUME = new ResourceLocation("voicechat", "textures/gui/change_volume.png");
    private static final ResourceLocation DISCONNECT = new ResourceLocation("voicechat", "textures/gui/disconnected.png");
    protected Supplier<List<PlayerState>> playerStates;
    protected int offset;
    private VoiceChatScreenBase.HoverArea[] hoverAreas;
    private int columnHeight;
    private int columnCount;
    private Client voiceChatClient;

    public GroupList(VoiceChatScreenBase screen, int posX, int posY, int xSize, int ySize, Supplier<List<PlayerState>> playerStates) {
        super(screen, posX, posY, xSize, ySize);
        this.playerStates = playerStates;
        this.columnHeight = 22;
        this.columnCount = 8;
        this.hoverAreas = new VoiceChatScreenBase.HoverArea[this.columnCount];
        for (int i = 0; i < this.hoverAreas.length; ++i) {
            this.hoverAreas[i] = new VoiceChatScreenBase.HoverArea(0, i * this.columnHeight, xSize, this.columnHeight);
        }
        this.voiceChatClient = Main.CLIENT_VOICE_EVENTS.getClient();
        if (this.voiceChatClient == null) {
            this.mc.func_147108_a(null);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.voiceChatClient.isConnected()) {
            this.mc.func_147108_a(null);
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        List<PlayerState> entries = this.playerStates.get();
        for (int i = this.getOffset(); i < entries.size() && i < this.getOffset() + this.columnCount; ++i) {
            int pos = i - this.getOffset();
            int startY = this.guiTop + pos * this.columnHeight;
            PlayerState state = entries.get(i);
            this.mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(state.getGameProfile().getName()), (float)(this.guiLeft + 3 + 16 + 1 + 8 + 3), (float)(startY + 7), 0);
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        List<PlayerState> entries = this.playerStates.get();
        for (int i = this.getOffset(); i < entries.size() && i < this.getOffset() + this.columnCount; ++i) {
            PlayerState state = entries.get(i);
            this.mc.func_110434_K().func_110577_a(TEXTURE);
            int pos = i - this.getOffset();
            VoiceChatScreenBase.HoverArea hoverArea = this.hoverAreas[pos];
            boolean hovered = hoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY) && !state.getGameProfile().getId().equals(this.mc.field_71439_g.func_110124_au());
            int startY = this.guiTop + pos * this.columnHeight;
            if (hovered) {
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)this.guiLeft, (int)startY, (float)195.0f, (float)39.0f, (int)160, (int)this.columnHeight, (int)512, (int)512);
            } else {
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)this.guiLeft, (int)startY, (float)195.0f, (float)17.0f, (int)160, (int)this.columnHeight, (int)512, (int)512);
            }
            matrixStack.func_227860_a_();
            this.mc.func_110434_K().func_110577_a(PlayerSkins.getSkin(state.getGameProfile()));
            matrixStack.func_227861_a_((double)(this.guiLeft + 3), (double)(startY + 3), 0.0);
            matrixStack.func_227862_a_(2.0f, 2.0f, 1.0f);
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            matrixStack.func_227865_b_();
            if (state.isDisconnected()) {
                this.drawIcon(matrixStack, startY, DISCONNECT);
            } else if (state.isDisabled()) {
                this.drawIcon(matrixStack, startY, SPEAKER_OFF);
            } else if (this.voiceChatClient.getTalkCache().isTalking(state.getGameProfile().getId())) {
                this.drawIcon(matrixStack, startY, SPEAKER);
            }
            this.mc.func_110434_K().func_110577_a(CHANGE_VOLUME);
            if (!hovered) continue;
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + this.xSize - 3 - 16), (int)(startY + 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        this.mc.func_110434_K().func_110577_a(TEXTURE);
        if (entries.size() > this.columnCount) {
            float h = this.ySize - 17;
            float perc = (float)this.getOffset() / (float)(entries.size() - this.columnCount);
            int posY = this.guiTop + (int)(h * perc);
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + this.xSize + 6), (int)posY, (float)195.0f, (float)0.0f, (int)12, (int)17, (int)512, (int)512);
        } else {
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + this.xSize + 6), (int)this.guiTop, (float)207.0f, (float)0.0f, (int)12, (int)17, (int)512, (int)512);
        }
    }

    private void drawIcon(MatrixStack matrixStack, int startY, ResourceLocation texture) {
        matrixStack.func_227860_a_();
        this.mc.func_110434_K().func_110577_a(texture);
        matrixStack.func_227861_a_((double)(this.guiLeft + 3 + 16 + 1), (double)(startY + 3 + 8), 0.0);
        matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
        Screen.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        matrixStack.func_227865_b_();
    }

    public int getOffset() {
        List<PlayerState> entries = this.playerStates.get();
        if (entries.size() <= this.columnCount) {
            this.offset = 0;
        } else if (this.offset > entries.size() - this.columnCount) {
            this.offset = entries.size() - this.columnCount;
        }
        return this.offset;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        List<PlayerState> entries = this.playerStates.get();
        if (entries.size() > this.columnCount) {
            this.offset = delta < 0.0 ? Math.min(this.getOffset() + 1, entries.size() - this.columnCount) : Math.max(this.getOffset() - 1, 0);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        List<PlayerState> entries = this.playerStates.get();
        for (int i = 0; i < this.hoverAreas.length && this.getOffset() + i < entries.size(); ++i) {
            PlayerState state;
            if (!this.hoverAreas[i].isHovered(this.guiLeft, this.guiTop, (int)mouseX, (int)mouseY) || (state = entries.get(this.getOffset() + i)).getGameProfile().getId().equals(this.mc.field_71439_g.func_110124_au())) continue;
            this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.mc.func_147108_a((Screen)new AdjustVolumeScreen(this.screen, Collections.singletonList(state)));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

