/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.event.VoiceChatConnectedEvent;
import de.maxhenkel.voicechat.voice.client.AudioChannel;
import de.maxhenkel.voicechat.voice.client.MicThread;
import de.maxhenkel.voicechat.voice.client.TalkCache;
import de.maxhenkel.voicechat.voice.common.AuthenticateAckPacket;
import de.maxhenkel.voicechat.voice.common.AuthenticatePacket;
import de.maxhenkel.voicechat.voice.common.KeepAlivePacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jline.utils.Log;

public class Client
extends Thread {
    private DatagramSocket socket;
    private InetAddress address;
    private int port;
    private UUID playerUUID;
    private UUID secret;
    private MicThread micThread;
    private boolean running;
    private TalkCache talkCache;
    private boolean authenticated;
    private Map<UUID, AudioChannel> audioChannels;
    private AuthThread authThread;
    private long lastKeepAlive;

    public Client(String serverIp, int serverPort, UUID playerUUID, UUID secret) throws IOException {
        this.address = InetAddress.getByName(serverIp);
        this.port = serverPort;
        this.socket = new DatagramSocket();
        this.socket.setTrafficClass(4);
        this.playerUUID = playerUUID;
        this.secret = secret;
        this.lastKeepAlive = -1L;
        this.running = true;
        this.talkCache = new TalkCache();
        this.audioChannels = new HashMap<UUID, AudioChannel>();
        this.authThread = new AuthThread();
        this.authThread.start();
        this.setDaemon(true);
        this.setName("VoiceChatClientThread");
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public UUID getSecret() {
        return this.secret;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void reloadDataLines() {
        Log.debug((Object[])new Object[]{"Reloading data lines"});
        if (this.micThread != null) {
            Log.debug((Object[])new Object[]{"Restarting microphone thread"});
            this.micThread.close();
            this.micThread = null;
            this.startMicThread();
        }
        Log.debug((Object[])new Object[]{"Clearing audio channels"});
        this.audioChannels.forEach((uuid, audioChannel) -> audioChannel.closeAndKill());
        this.audioChannels.clear();
    }

    private void startMicThread() {
        try {
            this.micThread = new MicThread(this);
            this.micThread.start();
        }
        catch (Exception e) {
            Main.LOGGER.error("Mic unavailable " + e);
        }
    }

    @Override
    public void run() {
        block9: {
            try {
                while (this.running) {
                    Packet<SoundPacket> packet;
                    NetworkMessage in = NetworkMessage.readPacketClient(this.socket, this);
                    if (in.getPacket() instanceof AuthenticateAckPacket) {
                        if (this.authenticated) continue;
                        Main.LOGGER.info("Server acknowledged authentication");
                        this.authenticated = true;
                        MinecraftForge.EVENT_BUS.post((Event)new VoiceChatConnectedEvent(this));
                        this.startMicThread();
                        this.lastKeepAlive = System.currentTimeMillis();
                        continue;
                    }
                    if (in.getPacket() instanceof SoundPacket) {
                        if (!Main.CLIENT_VOICE_EVENTS.getPlayerStateManager().isDisabled()) {
                            packet = (SoundPacket)in.getPacket();
                            AudioChannel sendTo = this.audioChannels.get(((SoundPacket)packet).getSender());
                            if (sendTo == null) {
                                AudioChannel ch = new AudioChannel(this, ((SoundPacket)packet).getSender());
                                ch.addToQueue((SoundPacket)packet);
                                ch.start();
                                this.audioChannels.put(((SoundPacket)packet).getSender(), ch);
                            } else {
                                sendTo.addToQueue((SoundPacket)packet);
                            }
                        }
                        this.audioChannels.values().stream().filter(AudioChannel::canKill).forEach(AudioChannel::closeAndKill);
                        this.audioChannels.entrySet().removeIf(entry -> ((AudioChannel)entry.getValue()).isClosed());
                        continue;
                    }
                    if (in.getPacket() instanceof PingPacket) {
                        packet = (PingPacket)in.getPacket();
                        Main.LOGGER.info("Received ping {}, sending pong...", (Object)((PingPacket)packet).getId());
                        this.sendToServer(new NetworkMessage(packet));
                        continue;
                    }
                    if (!(in.getPacket() instanceof KeepAlivePacket)) continue;
                    this.lastKeepAlive = System.currentTimeMillis();
                    this.sendToServer(new NetworkMessage(new KeepAlivePacket()));
                }
            }
            catch (Exception e) {
                if (!this.running) break block9;
                Main.LOGGER.error("Failed to process packet from server: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void close() {
        Main.LOGGER.info("Disconnecting client");
        this.running = false;
        this.socket.close();
        this.authThread.close();
        if (this.micThread != null) {
            this.micThread.close();
        }
    }

    @Nullable
    public MicThread getMicThread() {
        return this.micThread;
    }

    public boolean isConnected() {
        return this.running && !this.socket.isClosed();
    }

    public TalkCache getTalkCache() {
        return this.talkCache;
    }

    public void sendToServer(NetworkMessage message) throws Exception {
        byte[] data = message.writeClient(this);
        this.socket.send(new DatagramPacket(data, data.length, this.address, this.port));
    }

    public void checkTimeout() {
        if (this.lastKeepAlive >= 0L && System.currentTimeMillis() - this.lastKeepAlive > (long)((Integer)Main.SERVER_CONFIG.keepAlive.get()).intValue() * 10L) {
            Main.LOGGER.info("Connection timeout");
            Main.CLIENT_VOICE_EVENTS.onDisconnect();
        }
    }

    private class AuthThread
    extends Thread {
        private boolean running = true;

        public AuthThread() {
            this.setDaemon(true);
            this.setName("VoiceChatAuthenticationThread");
        }

        @Override
        public void run() {
            while (this.running && !Client.this.authenticated) {
                block3: {
                    try {
                        Main.LOGGER.info("Trying to authenticate voice connection");
                        Client.this.sendToServer(new NetworkMessage(new AuthenticatePacket(Client.this.playerUUID, Client.this.secret)));
                    }
                    catch (Exception e) {
                        if (Client.this.socket.isClosed()) break block3;
                        Main.LOGGER.error("Failed to authenticate voice connection: {}", (Object)e.getMessage());
                    }
                }
                Utils.sleep(1000);
            }
        }

        public void close() {
            this.running = false;
        }
    }
}

