/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.net.PlayerStateMessage;
import de.maxhenkel.voicechat.net.PlayerStatesMessage;
import de.maxhenkel.voicechat.net.SetPlayerStateMessage;
import de.maxhenkel.voicechat.voice.client.Client;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;

public class ClientPlayerStateManager {
    private boolean muted;
    private PlayerState state;
    private Map<UUID, PlayerState> states;

    public ClientPlayerStateManager() {
        this.muted = (Boolean)Main.CLIENT_CONFIG.muted.get();
        this.state = new PlayerState((Boolean)Main.CLIENT_CONFIG.disabled.get(), true, Minecraft.func_71410_x().func_110432_I().func_148256_e());
        this.states = new HashMap<UUID, PlayerState>();
    }

    public void onPlayerStatePacket(PlayerStateMessage packet) {
        this.states.put(packet.getPlayerState().getGameProfile().getId(), packet.getPlayerState());
    }

    public void onPlayerStatesPacket(PlayerStatesMessage packet) {
        this.states = packet.getPlayerStates();
    }

    public void onVoiceChatDisconnected() {
        this.state.setDisconnected(true);
        this.syncOwnState();
    }

    public void onVoiceChatConnected(Client client) {
        this.state.setDisconnected(false);
        this.syncOwnState();
    }

    public void onDisconnect() {
        this.clearStates();
    }

    public boolean isPlayerDisabled(PlayerEntity player) {
        PlayerState playerState = this.states.get(player.func_110124_au());
        if (playerState == null) {
            return false;
        }
        return playerState.isDisabled();
    }

    public boolean isPlayerDisconnected(PlayerEntity player) {
        PlayerState playerState = this.states.get(player.func_110124_au());
        if (playerState == null) {
            return true;
        }
        return playerState.isDisconnected();
    }

    public void syncOwnState() {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new SetPlayerStateMessage(this.state));
    }

    public boolean isDisabled() {
        return this.state.isDisabled();
    }

    public boolean isDisconnected() {
        return this.state.isDisconnected();
    }

    public void setDisabled(boolean disabled) {
        this.state.setDisabled(disabled);
        Main.CLIENT_CONFIG.disabled.set((Object)disabled);
        Main.CLIENT_CONFIG.disabled.save();
        this.syncOwnState();
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
        Main.CLIENT_CONFIG.muted.set((Object)muted);
        Main.CLIENT_CONFIG.muted.save();
    }

    public boolean isInGroup() {
        return this.getGroup() != null;
    }

    public boolean isInGroup(PlayerEntity player) {
        PlayerState state = this.states.get(player.func_110124_au());
        if (state == null) {
            return false;
        }
        return state.hasGroup();
    }

    @Nullable
    public String getGroup(PlayerEntity player) {
        PlayerState state = this.states.get(player.func_110124_au());
        if (state == null) {
            return null;
        }
        return state.getGroup();
    }

    @Nullable
    public String getGroup() {
        return this.state.getGroup();
    }

    public void setGroup(@Nullable String group) {
        this.state.setGroup(group);
        this.syncOwnState();
    }

    public List<PlayerState> getPlayerStates() {
        return new ArrayList<PlayerState>(this.states.values());
    }

    @Nullable
    public PlayerState getState(UUID player) {
        return this.states.get(player);
    }

    public void clearStates() {
        this.states.clear();
    }
}

