/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.event.VoiceChatConnectedEvent;
import de.maxhenkel.voicechat.event.VoiceChatDisconnectedEvent;
import de.maxhenkel.voicechat.gui.CreateGroupScreen;
import de.maxhenkel.voicechat.gui.GroupScreen;
import de.maxhenkel.voicechat.gui.VoiceChatScreen;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.voice.client.Client;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.GroupChatManager;
import de.maxhenkel.voicechat.voice.client.HUDIconLocation;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.PTTKeyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientVoiceEvents {
    private static final ResourceLocation MICROPHONE_ICON = new ResourceLocation("voicechat", "textures/gui/microphone.png");
    private static final ResourceLocation MICROPHONE_OFF_ICON = new ResourceLocation("voicechat", "textures/gui/microphone_off.png");
    private static final ResourceLocation SPEAKER_ICON = new ResourceLocation("voicechat", "textures/gui/speaker.png");
    private static final ResourceLocation SPEAKER_OFF_ICON = new ResourceLocation("voicechat", "textures/gui/speaker_off.png");
    private static final ResourceLocation DISCONNECT_ICON = new ResourceLocation("voicechat", "textures/gui/disconnected.png");
    private static final ResourceLocation GROUP_ICON = new ResourceLocation("voicechat", "textures/gui/group.png");
    private Client client;
    private ClientPlayerStateManager playerStateManager = new ClientPlayerStateManager();
    private PTTKeyHandler pttKeyHandler = new PTTKeyHandler();
    private Minecraft minecraft = Minecraft.func_71410_x();

    public ClientVoiceEvents() {
        MinecraftForge.EVENT_BUS.register((Object)this.pttKeyHandler);
    }

    public void authenticate(UUID playerUUID, UUID secret) {
        ClientPlayNetHandler connection;
        Main.LOGGER.info("Received secret");
        if (this.client != null) {
            this.onDisconnect();
        }
        if ((connection = this.minecraft.func_147114_u()) != null) {
            try {
                SocketAddress socketAddress = connection.func_147298_b().channel().remoteAddress();
                if (socketAddress instanceof InetSocketAddress) {
                    InetSocketAddress address = (InetSocketAddress)socketAddress;
                    String ip = address.getHostString();
                    Main.LOGGER.info("Connecting to server: '" + ip + ":" + Main.SERVER_CONFIG.voiceChatPort.get() + "'");
                    this.client = new Client(ip, (Integer)Main.SERVER_CONFIG.voiceChatPort.get(), playerUUID, secret);
                    this.client.start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void disconnectEvent(WorldEvent.Unload event) {
        if (this.minecraft.field_71442_b == null) {
            this.playerStateManager.onDisconnect();
            this.onDisconnect();
        }
    }

    @SubscribeEvent
    public void connectedEvent(VoiceChatConnectedEvent event) {
        this.playerStateManager.onVoiceChatConnected(event.getClient());
    }

    @SubscribeEvent
    public void disconnectedEvent(VoiceChatDisconnectedEvent event) {
        this.playerStateManager.onVoiceChatDisconnected();
    }

    public void onDisconnect() {
        MinecraftForge.EVENT_BUS.post((Event)new VoiceChatDisconnectedEvent());
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    @Nullable
    public Client getClient() {
        return this.client;
    }

    public ClientPlayerStateManager getPlayerStateManager() {
        return this.playerStateManager;
    }

    public PTTKeyHandler getPttKeyHandler() {
        return this.pttKeyHandler;
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (!this.isMultiplayerServer()) {
            return;
        }
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CHAT)) {
            return;
        }
        if (((Boolean)Main.CLIENT_CONFIG.hideIcons.get()).booleanValue()) {
            return;
        }
        if (this.playerStateManager.isDisconnected()) {
            this.renderIcon(event.getMatrixStack(), DISCONNECT_ICON);
        } else if (this.playerStateManager.isDisabled()) {
            this.renderIcon(event.getMatrixStack(), SPEAKER_OFF_ICON);
        } else if (this.playerStateManager.isMuted() && ((MicrophoneActivationType)((Object)Main.CLIENT_CONFIG.microphoneActivationType.get())).equals((Object)MicrophoneActivationType.VOICE)) {
            this.renderIcon(event.getMatrixStack(), MICROPHONE_OFF_ICON);
        } else if (this.client != null && this.client.getMicThread() != null && this.client.getMicThread().isTalking()) {
            this.renderIcon(event.getMatrixStack(), MICROPHONE_ICON);
        }
        if (this.playerStateManager.isInGroup() && ((Boolean)Main.CLIENT_CONFIG.showGroupHUD.get()).booleanValue()) {
            GroupChatManager.renderIcons(event.getMatrixStack());
        }
    }

    private void renderIcon(MatrixStack matrixStack, ResourceLocation texture) {
        matrixStack.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(texture);
        int width = this.minecraft.func_228018_at_().func_198107_o();
        int height = this.minecraft.func_228018_at_().func_198087_p();
        HUDIconLocation location = (HUDIconLocation)((Object)Main.CLIENT_CONFIG.hudIconLocation.get());
        if (location.equals((Object)HUDIconLocation.RIGHT)) {
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)(width - 32), (int)(height - 32), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        } else if (location.equals((Object)HUDIconLocation.CENTER)) {
            if (this.minecraft.field_71442_b != null && this.minecraft.field_71442_b.func_78763_f()) {
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)(width / 2 - 8), (int)(height - 16 - 35 - 2), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            } else {
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)(width / 2 - 8), (int)(height - 35 - 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        } else {
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)16, (int)(height - 32), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        matrixStack.func_227865_b_();
    }

    @SubscribeEvent
    public void onInput(InputEvent.KeyInputEvent event) {
        if (Main.KEY_VOICE_CHAT.func_151468_f() && this.checkConnected()) {
            this.minecraft.func_147108_a((Screen)new VoiceChatScreen());
        }
        if (Main.KEY_GROUP.func_151468_f() && this.checkConnected()) {
            if (((Boolean)Main.SERVER_CONFIG.groupsEnabled.get()).booleanValue()) {
                if (this.playerStateManager.isInGroup()) {
                    this.minecraft.func_147108_a((Screen)new GroupScreen());
                } else {
                    this.minecraft.func_147108_a((Screen)new CreateGroupScreen());
                }
            } else {
                this.minecraft.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.voicechat.groups_disabled"), true);
            }
        }
        if (Main.KEY_VOICE_CHAT_SETTINGS.func_151468_f() && this.checkConnected()) {
            this.minecraft.func_147108_a((Screen)new VoiceChatSettingsScreen());
        }
        if (Main.KEY_PTT.func_151468_f()) {
            this.checkConnected();
        }
        if (Main.KEY_MUTE.func_151468_f() && this.checkConnected()) {
            this.playerStateManager.setMuted(!this.playerStateManager.isMuted());
        }
        if (Main.KEY_DISABLE.func_151468_f() && this.checkConnected()) {
            this.playerStateManager.setDisabled(!this.playerStateManager.isDisabled());
        }
        if (Main.KEY_HIDE_ICONS.func_151468_f()) {
            boolean hidden = (Boolean)Main.CLIENT_CONFIG.hideIcons.get() == false;
            Main.CLIENT_CONFIG.hideIcons.set((Object)hidden);
            Main.CLIENT_CONFIG.hideIcons.save();
            if (hidden) {
                this.minecraft.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.voicechat.icons_hidden"), true);
            } else {
                this.minecraft.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.voicechat.icons_visible"), true);
            }
        }
    }

    public boolean checkConnected() {
        if (Main.CLIENT_VOICE_EVENTS.getClient() == null || !Main.CLIENT_VOICE_EVENTS.getClient().isAuthenticated()) {
            this.sendUnavailableMessage();
            return false;
        }
        return true;
    }

    public void sendUnavailableMessage() {
        this.minecraft.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.voicechat.voice_chat_unavailable"), true);
    }

    public boolean isMultiplayerServer() {
        return this.minecraft.func_147104_D() != null && !this.minecraft.func_147104_D().func_181041_d();
    }

    @SubscribeEvent
    public void onRenderName(RenderNameplateEvent event) {
        if (!this.isMultiplayerServer()) {
            return;
        }
        if (((Boolean)Main.CLIENT_CONFIG.hideIcons.get()).booleanValue()) {
            return;
        }
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        if (event.getEntity() == this.minecraft.field_71439_g) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (!this.minecraft.field_71474_y.field_74319_N) {
            String group = this.playerStateManager.getGroup(player);
            if (this.playerStateManager.isPlayerDisconnected(player)) {
                this.renderPlayerIcon(player, DISCONNECT_ICON, event.getMatrixStack(), event.getRenderTypeBuffer(), event.getPackedLight());
            } else if (group != null && !group.equals(this.playerStateManager.getGroup())) {
                this.renderPlayerIcon(player, GROUP_ICON, event.getMatrixStack(), event.getRenderTypeBuffer(), event.getPackedLight());
            } else if (this.playerStateManager.isPlayerDisabled(player)) {
                this.renderPlayerIcon(player, SPEAKER_OFF_ICON, event.getMatrixStack(), event.getRenderTypeBuffer(), event.getPackedLight());
            } else if (this.client != null && this.client.getTalkCache().isTalking(player)) {
                this.renderPlayerIcon(player, SPEAKER_ICON, event.getMatrixStack(), event.getRenderTypeBuffer(), event.getPackedLight());
            }
        }
    }

    protected void renderPlayerIcon(PlayerEntity player, ResourceLocation texture, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStackIn.func_227861_a_(0.0, (double)player.func_213302_cg() + 0.5, 0.0);
        matrixStackIn.func_227863_a_(this.minecraft.func_175598_ae().func_229098_b_());
        matrixStackIn.func_227862_a_(-0.025f, -0.025f, 0.025f);
        matrixStackIn.func_227861_a_(0.0, -1.0, 0.0);
        float offset = this.minecraft.field_71466_p.func_238414_a_((ITextProperties)player.func_145748_c_()) / 2 + 2;
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228658_l_((ResourceLocation)texture));
        int alpha = 32;
        if (player.func_226273_bm_()) {
            ClientVoiceEvents.vertex(builder, matrixStackIn, offset, 10.0f, 0.0f, 0.0f, 1.0f, alpha, packedLightIn);
            ClientVoiceEvents.vertex(builder, matrixStackIn, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, packedLightIn);
            ClientVoiceEvents.vertex(builder, matrixStackIn, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, packedLightIn);
            ClientVoiceEvents.vertex(builder, matrixStackIn, offset, 0.0f, 0.0f, 0.0f, 0.0f, alpha, packedLightIn);
        } else {
            ClientVoiceEvents.vertex(builder, matrixStackIn, offset, 10.0f, 0.0f, 0.0f, 1.0f, packedLightIn);
            ClientVoiceEvents.vertex(builder, matrixStackIn, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, packedLightIn);
            ClientVoiceEvents.vertex(builder, matrixStackIn, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, packedLightIn);
            ClientVoiceEvents.vertex(builder, matrixStackIn, offset, 0.0f, 0.0f, 0.0f, 0.0f, packedLightIn);
            IVertexBuilder builderSeeThrough = bufferIn.getBuffer(RenderType.func_228660_m_((ResourceLocation)texture));
            ClientVoiceEvents.vertex(builderSeeThrough, matrixStackIn, offset, 10.0f, 0.0f, 0.0f, 1.0f, alpha, packedLightIn);
            ClientVoiceEvents.vertex(builderSeeThrough, matrixStackIn, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, packedLightIn);
            ClientVoiceEvents.vertex(builderSeeThrough, matrixStackIn, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, packedLightIn);
            ClientVoiceEvents.vertex(builderSeeThrough, matrixStackIn, offset, 0.0f, 0.0f, 0.0f, 0.0f, alpha, packedLightIn);
        }
        matrixStackIn.func_227865_b_();
    }

    private static void vertex(IVertexBuilder builder, MatrixStack matrixStack, float x, float y, float z, float u, float v, int light) {
        ClientVoiceEvents.vertex(builder, matrixStack, x, y, z, u, v, 255, light);
    }

    private static void vertex(IVertexBuilder builder, MatrixStack matrixStack, float x, float y, float z, float u, float v, int alpha, int light) {
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        builder.func_227888_a_(entry.func_227870_a_(), x, y, z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(entry.func_227872_b_(), 0.0f, 0.0f, -1.0f).func_181675_d();
    }
}

