/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.corelib.client.PlayerSkins;
import de.maxhenkel.voicechat.voice.client.Client;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;

public class GroupChatManager {
    private static final ResourceLocation TALK_OUTLINE = new ResourceLocation("voicechat", "textures/gui/talk_outline.png");
    private static final ResourceLocation SPEAKER_OFF_ICON = new ResourceLocation("voicechat", "textures/gui/speaker_off.png");
    private static final Minecraft minecraft = Minecraft.func_71410_x();

    public static void renderIcons(MatrixStack matrixStack) {
        Client client = Main.CLIENT_VOICE_EVENTS.getClient();
        if (client == null) {
            return;
        }
        List<PlayerState> groupMembers = GroupChatManager.getGroupMembers(false);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(8.0, 8.0, 0.0);
        matrixStack.func_227862_a_(2.0f, 2.0f, 1.0f);
        for (int i = 0; i < groupMembers.size(); ++i) {
            PlayerState state = groupMembers.get(i);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, (double)(i * 11), 0.0);
            if (client.getTalkCache().isTalking(state.getGameProfile().getId())) {
                minecraft.func_110434_K().func_110577_a(TALK_OUTLINE);
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)10, (int)10, (int)16, (int)16);
            }
            minecraft.func_110434_K().func_110577_a(PlayerSkins.getSkin(state.getGameProfile()));
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)1, (int)1, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)1, (int)1, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            if (state.isDisabled()) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(10.0, 5.0, 0.0);
                matrixStack.func_227862_a_(0.25f, 0.25f, 1.0f);
                minecraft.func_110434_K().func_110577_a(SPEAKER_OFF_ICON);
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                matrixStack.func_227865_b_();
            }
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    public static List<PlayerState> getGroupMembers() {
        return GroupChatManager.getGroupMembers(true);
    }

    public static List<PlayerState> getGroupMembers(boolean includeSelf) {
        ArrayList<PlayerState> entries = new ArrayList<PlayerState>();
        String group = GroupChatManager.getGroup();
        for (PlayerState state : Main.CLIENT_VOICE_EVENTS.getPlayerStateManager().getPlayerStates()) {
            if (!includeSelf && state.getGameProfile().getId().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au()) || state.getGroup() == null || !state.getGroup().equals(group)) continue;
            entries.add(state);
        }
        return entries;
    }

    public static String getGroup() {
        String group = Main.CLIENT_VOICE_EVENTS.getPlayerStateManager().getGroup();
        if (group == null) {
            return "";
        }
        return group;
    }
}

