/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class PingManager {
    private Map<UUID, Ping> listeners;
    private Server server;

    public PingManager(Server server) {
        this.server = server;
        this.listeners = new HashMap<UUID, Ping>();
    }

    public void onPongPacket(PingPacket packet) {
        Main.LOGGER.debug("Received pong {}", (Object)packet.getId());
        Ping ping = this.listeners.get(packet.getId());
        if (ping == null) {
            return;
        }
        ping.listener.onPong(packet);
        this.listeners.remove(packet.getId());
    }

    public void checkTimeouts() {
        List timedOut = this.listeners.entrySet().stream().filter(uuidPingEntry -> ((Ping)uuidPingEntry.getValue()).isTimedOut()).collect(Collectors.toList());
        for (Map.Entry ping : timedOut) {
            ((Ping)ping.getValue()).listener.onTimeout();
            this.listeners.remove(ping.getKey());
        }
    }

    public void sendPing(ClientConnection connection, long timeout, PingListener listener) throws Exception {
        UUID id = UUID.randomUUID();
        long timestamp = System.currentTimeMillis();
        this.server.sendPacket(new PingPacket(id, timestamp), connection);
        Main.LOGGER.debug("Sent ping {}", (Object)id);
        this.listeners.put(id, new Ping(listener, timestamp, timeout));
    }

    public static interface PingListener {
        public void onPong(PingPacket var1);

        public void onTimeout();
    }

    private static class Ping {
        private PingListener listener;
        private long timestamp;
        private long timeout;

        public Ping(PingListener listener, long timestamp, long timeout) {
            this.listener = listener;
            this.timestamp = timestamp;
            this.timeout = timeout;
        }

        public boolean isTimedOut() {
            return System.currentTimeMillis() - this.timestamp >= this.timeout;
        }
    }
}

