/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.corelib.net.NetUtils;
import de.maxhenkel.voicechat.net.PlayerStateMessage;
import de.maxhenkel.voicechat.net.PlayerStatesMessage;
import de.maxhenkel.voicechat.net.SetPlayerStateMessage;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;

public class PlayerStateManager {
    private Map<UUID, PlayerState> states = new HashMap<UUID, PlayerState>();

    public void onPlayerStatePacket(ServerPlayerEntity player, SetPlayerStateMessage message) {
        PlayerState state = message.getPlayerState();
        state.setGameProfile(player.func_146103_bH());
        this.states.put(player.func_110124_au(), state);
        this.broadcastState(player.field_71133_b, state);
    }

    private void broadcastState(MinecraftServer server, PlayerState state) {
        PlayerStateMessage packet = new PlayerStateMessage(state);
        server.func_184103_al().func_181057_v().forEach(p -> NetUtils.sendTo(Main.SIMPLE_CHANNEL, p, packet));
    }

    public void onPlayerLoggedIn(ServerPlayerEntity player) {
        this.notifyPlayer(player);
    }

    public void onPlayerLoggedOut(ServerPlayerEntity player) {
        this.removePlayer(player);
    }

    private void notifyPlayer(ServerPlayerEntity player) {
        PlayerStatesMessage msg = new PlayerStatesMessage(this.states);
        NetUtils.sendTo(Main.SIMPLE_CHANNEL, player, msg);
        this.broadcastState(player.field_71133_b, new PlayerState(false, true, player.func_146103_bH()));
    }

    private void removePlayer(ServerPlayerEntity player) {
        this.states.remove(player.func_110124_au());
        this.broadcastState(player.field_71133_b, new PlayerState(true, true, player.func_146103_bH()));
    }

    @Nullable
    public PlayerState getState(UUID playerUUID) {
        return this.states.get(playerUUID);
    }

    public List<PlayerState> getStates() {
        return new ArrayList<PlayerState>(this.states.values());
    }
}

