/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.voice.common.AuthenticateAckPacket;
import de.maxhenkel.voicechat.voice.common.AuthenticatePacket;
import de.maxhenkel.voicechat.voice.common.KeepAlivePacket;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.PlayerStateManager;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;

public class Server
extends Thread {
    private Map<UUID, ClientConnection> connections;
    private Map<UUID, UUID> secrets;
    private int port;
    private MinecraftServer server;
    private DatagramSocket socket;
    private ProcessThread processThread;
    private BlockingQueue<NetworkMessage> packetQueue;
    private PingManager pingManager;
    private PlayerStateManager playerStateManager;

    public Server(int port, MinecraftServer server) {
        this.port = port;
        this.server = server;
        this.connections = new HashMap<UUID, ClientConnection>();
        this.secrets = new HashMap<UUID, UUID>();
        this.packetQueue = new LinkedBlockingQueue<NetworkMessage>();
        this.pingManager = new PingManager(this);
        this.playerStateManager = new PlayerStateManager();
        this.setDaemon(true);
        this.setName("VoiceChatServerThread");
        this.processThread = new ProcessThread();
        this.processThread.start();
    }

    @Override
    public void run() {
        try {
            InetAddress address = null;
            String addr = (String)Main.SERVER_CONFIG.voiceChatBindAddress.get();
            try {
                if (!addr.isEmpty()) {
                    address = InetAddress.getByName(addr);
                }
            }
            catch (Exception e) {
                Main.LOGGER.error("Failed to parse bind IP address '" + addr + "'");
                Main.LOGGER.info("Binding to default IP address");
                e.printStackTrace();
            }
            try {
                this.socket = new DatagramSocket(this.port, address);
                this.socket.setTrafficClass(4);
            }
            catch (BindException e) {
                Main.LOGGER.error("Failed to bind to address '" + addr + "'");
                e.printStackTrace();
                System.exit(1);
                return;
            }
            Main.LOGGER.info("Server started at port " + this.port);
            while (!this.socket.isClosed()) {
                try {
                    NetworkMessage message = NetworkMessage.readPacketServer(this.socket, this);
                    this.packetQueue.add(message);
                }
                catch (Exception exception) {}
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public UUID getSecret(UUID playerUUID) {
        if (this.secrets.containsKey(playerUUID)) {
            return this.secrets.get(playerUUID);
        }
        UUID secret = UUID.randomUUID();
        this.secrets.put(playerUUID, secret);
        return secret;
    }

    public void disconnectClient(UUID playerUUID) {
        this.connections.remove(playerUUID);
        this.secrets.remove(playerUUID);
    }

    public void close() {
        this.socket.close();
        this.processThread.close();
    }

    private void processGroupPacket(PlayerState player, MicPacket packet) throws Exception {
        String group = player.getGroup();
        NetworkMessage soundMessage = new NetworkMessage(new SoundPacket(player.getGameProfile().getId(), packet.getData(), packet.getSequenceNumber()));
        for (PlayerState state : this.playerStateManager.getStates()) {
            ClientConnection connection;
            if (!group.equals(state.getGroup()) || player.getGameProfile().getId().equals(state.getGameProfile().getId()) || (connection = this.connections.get(state.getGameProfile().getId())) == null) continue;
            connection.send(this, soundMessage);
        }
    }

    private void processProximityPacket(PlayerEntity player, MicPacket packet) throws Exception {
        double distance = (Double)Main.SERVER_CONFIG.voiceChatDistance.get();
        List closeConnections = player.field_70170_p.func_175647_a(PlayerEntity.class, new AxisAlignedBB(player.func_226277_ct_() - distance, player.func_226278_cu_() - distance, player.func_226281_cx_() - distance, player.func_226277_ct_() + distance, player.func_226278_cu_() + distance, player.func_226281_cx_() + distance), playerEntity -> !playerEntity.func_110124_au().equals(player.func_110124_au())).stream().map(playerEntity -> this.connections.get(playerEntity.func_110124_au())).filter(Objects::nonNull).collect(Collectors.toList());
        NetworkMessage soundMessage = new NetworkMessage(new SoundPacket(player.func_110124_au(), packet.getData(), packet.getSequenceNumber()));
        for (ClientConnection clientConnection : closeConnections) {
            if (clientConnection.getPlayerUUID().equals(player.func_110124_au())) continue;
            clientConnection.send(this, soundMessage);
        }
    }

    private void keepAlive() throws Exception {
        long timestamp = System.currentTimeMillis();
        KeepAlivePacket keepAlive = new KeepAlivePacket();
        ArrayList<UUID> connectionsToDrop = new ArrayList<UUID>(this.connections.size());
        for (ClientConnection connection : this.connections.values()) {
            if (timestamp - connection.getLastKeepAliveResponse() >= (long)((Integer)Main.SERVER_CONFIG.keepAlive.get()).intValue() * 10L) {
                connectionsToDrop.add(connection.getPlayerUUID());
                continue;
            }
            if (timestamp - connection.getLastKeepAlive() < (long)((Integer)Main.SERVER_CONFIG.keepAlive.get()).intValue()) continue;
            connection.setLastKeepAlive(timestamp);
            this.sendPacket(keepAlive, connection);
        }
        for (UUID uuid : connectionsToDrop) {
            this.disconnectClient(uuid);
            Main.LOGGER.info("Player {} timed out", (Object)uuid);
            ServerPlayerEntity player = this.server.func_184103_al().func_177451_a(uuid);
            if (player != null) {
                Main.LOGGER.info("Reconnecting player {}", (Object)player.func_145748_c_().getString());
                Main.SERVER_VOICE_EVENTS.initializePlayerConnection(player);
                continue;
            }
            Main.LOGGER.warn("Reconnecting player {} failed (Could not find player)", (Object)player.func_145748_c_().getString());
        }
    }

    public Map<UUID, ClientConnection> getConnections() {
        return this.connections;
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    public void sendPacket(Packet<?> packet, ClientConnection connection) throws Exception {
        connection.send(this, new NetworkMessage(packet));
    }

    public PingManager getPingManager() {
        return this.pingManager;
    }

    public PlayerStateManager getPlayerStateManager() {
        return this.playerStateManager;
    }

    private class ProcessThread
    extends Thread {
        private boolean running = true;

        public ProcessThread() {
            this.setDaemon(true);
            this.setName("VoiceChatPacketProcessingThread");
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    UUID playerUUID;
                    Server.this.pingManager.checkTimeouts();
                    Server.this.keepAlive();
                    NetworkMessage message = (NetworkMessage)Server.this.packetQueue.poll(10L, TimeUnit.MILLISECONDS);
                    if (message == null || System.currentTimeMillis() - message.getTimestamp() > message.getTTL()) continue;
                    if (message.getPacket() instanceof AuthenticatePacket) {
                        AuthenticatePacket packet = (AuthenticatePacket)message.getPacket();
                        UUID secret = (UUID)Server.this.secrets.get(packet.getPlayerUUID());
                        if (secret != null && secret.equals(packet.getSecret())) {
                            ClientConnection connection;
                            if (!Server.this.connections.containsKey(packet.getPlayerUUID())) {
                                connection = new ClientConnection(packet.getPlayerUUID(), message.getAddress());
                                Server.this.connections.put(packet.getPlayerUUID(), connection);
                                Main.LOGGER.info("Successfully authenticated player {}", (Object)packet.getPlayerUUID());
                            } else {
                                connection = (ClientConnection)Server.this.connections.get(packet.getPlayerUUID());
                            }
                            Server.this.sendPacket(new AuthenticateAckPacket(), connection);
                        }
                    }
                    if ((playerUUID = message.getSender(Server.this)) == null) continue;
                    ClientConnection conn = (ClientConnection)Server.this.connections.get(playerUUID);
                    if (message.getPacket() instanceof MicPacket) {
                        MicPacket packet = (MicPacket)message.getPacket();
                        ServerPlayerEntity player = Server.this.server.func_184103_al().func_177451_a(playerUUID);
                        if (player == null) continue;
                        PlayerState state = Server.this.playerStateManager.getState(playerUUID);
                        if (state == null || !state.hasGroup()) {
                            Server.this.processProximityPacket((PlayerEntity)player, packet);
                            continue;
                        }
                        Server.this.processGroupPacket(state, packet);
                        continue;
                    }
                    if (message.getPacket() instanceof PingPacket) {
                        Server.this.pingManager.onPongPacket((PingPacket)message.getPacket());
                        continue;
                    }
                    if (!(message.getPacket() instanceof KeepAlivePacket)) continue;
                    conn.setLastKeepAliveResponse(System.currentTimeMillis());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void close() {
            this.running = false;
        }
    }
}

