/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.nbtedit;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.DoubleConfig;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.LongConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconWithBorder;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.net.EditNBTResponsePacket;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.NBTUtils;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class NBTEditorScreen
extends BaseScreen {
    public static final Icon NBT_BYTE = NBTEditorScreen.getIcon("byte");
    public static final Icon NBT_SHORT = NBTEditorScreen.getIcon("short");
    public static final Icon NBT_INT = NBTEditorScreen.getIcon("int");
    public static final Icon NBT_LONG = NBTEditorScreen.getIcon("long");
    public static final Icon NBT_FLOAT = NBTEditorScreen.getIcon("float");
    public static final Icon NBT_DOUBLE = NBTEditorScreen.getIcon("double");
    public static final Icon NBT_STRING = NBTEditorScreen.getIcon("string");
    public static final Icon NBT_LIST = NBTEditorScreen.getIcon("list");
    public static final Icon NBT_LIST_CLOSED = NBTEditorScreen.getIcon("list_closed");
    public static final Icon NBT_LIST_OPEN = NBTEditorScreen.getIcon("list_open");
    public static final Icon NBT_MAP = NBTEditorScreen.getIcon("map");
    public static final Icon NBT_MAP_CLOSED = NBTEditorScreen.getIcon("map_closed");
    public static final Icon NBT_MAP_OPEN = NBTEditorScreen.getIcon("map_open");
    public static final Icon NBT_BYTE_ARRAY = NBTEditorScreen.getIcon("byte_array");
    public static final Icon NBT_BYTE_ARRAY_CLOSED = NBTEditorScreen.getIcon("byte_array_closed");
    public static final Icon NBT_BYTE_ARRAY_OPEN = NBTEditorScreen.getIcon("byte_array_open");
    public static final Icon NBT_INT_ARRAY = NBTEditorScreen.getIcon("int_array");
    public static final Icon NBT_INT_ARRAY_CLOSED = NBTEditorScreen.getIcon("int_array_closed");
    public static final Icon NBT_INT_ARRAY_OPEN = NBTEditorScreen.getIcon("int_array_open");
    private final CompoundNBT info;
    private final ButtonNBTMap buttonNBTRoot;
    private ButtonNBT selected;
    public final Panel panelTopLeft;
    public final Panel panelTopRight;
    public final Panel panelNbt;
    public final PanelScrollBar scroll;
    private int shouldClose = 0;

    private static Icon getIcon(String name) {
        return Icon.getIcon("ftblibrary:textures/icons/nbt/" + name + ".png");
    }

    private ButtonNBT getFrom(ButtonNBTCollection b, String key) {
        INBT nbt = b.getTag(key);
        switch (nbt.func_74732_a()) {
            case 10: {
                return new ButtonNBTMap(this.panelNbt, b, key, (CompoundNBT)nbt);
            }
            case 9: {
                return new ButtonNBTList(this.panelNbt, b, key, (ListNBT)nbt);
            }
            case 7: {
                return new ButtonNBTByteArray(this.panelNbt, b, key, (ByteArrayNBT)nbt);
            }
            case 11: {
                return new ButtonNBTIntArray(this.panelNbt, b, key, (IntArrayNBT)nbt);
            }
        }
        return new ButtonNumericTag(this.panelNbt, b, key, nbt);
    }

    public SimpleButton newTag(Panel panel, String t, Icon icon, Supplier<INBT> supplier) {
        return new SimpleButton(panel, (ITextComponent)new StringTextComponent(t), icon, (gui, button) -> {
            if (this.selected instanceof ButtonNBTMap) {
                StringConfig value = new StringConfig(Pattern.compile("^.+$"));
                EditConfigFromStringScreen.open(value, "", "", arg_0 -> this.lambda$null$0(value, (Supplier)supplier, arg_0));
            } else if (this.selected instanceof ButtonNBTCollection) {
                ((ButtonNBTCollection)this.selected).setTag("-1", (INBT)supplier.get());
                this.selected.updateChildren(false);
                this.panelNbt.refreshWidgets();
            }
        }){

            @Override
            public void drawBackground(MatrixStack stack, Theme theme, int x, int y, int w, int h) {
                IconWithBorder.BUTTON_ROUND_GRAY.draw(stack, x, y, w, h);
            }
        };
    }

    public NBTEditorScreen(CompoundNBT i, CompoundNBT nbt) {
        this.info = i;
        this.panelTopLeft = new Panel(this){

            @Override
            public void addWidgets() {
                this.add(new SimpleButton(this, (ITextComponent)new TranslationTextComponent("selectServer.delete"), NBTEditorScreen.this.selected == NBTEditorScreen.this.buttonNBTRoot ? Icons.REMOVE_GRAY : Icons.REMOVE, (widget, button) -> {
                    if (NBTEditorScreen.this.selected != NBTEditorScreen.this.buttonNBTRoot) {
                        ((NBTEditorScreen)NBTEditorScreen.this).selected.parent.setTag(((NBTEditorScreen)NBTEditorScreen.this).selected.key, null);
                        ((NBTEditorScreen)NBTEditorScreen.this).selected.parent.updateChildren(false);
                        NBTEditorScreen.this.selected = ((NBTEditorScreen)NBTEditorScreen.this).selected.parent;
                        NBTEditorScreen.this.panelNbt.refreshWidgets();
                        NBTEditorScreen.this.panelTopLeft.refreshWidgets();
                    }
                }));
                boolean canRename = ((NBTEditorScreen)NBTEditorScreen.this).selected.parent instanceof ButtonNBTMap;
                this.add(new SimpleButton(this, (ITextComponent)new TranslationTextComponent("gui.rename"), canRename ? Icons.INFO : Icons.INFO_GRAY, (gui, button) -> {
                    if (canRename) {
                        StringConfig value = new StringConfig();
                        EditConfigFromStringScreen.open(value, ((NBTEditorScreen)NBTEditorScreen.this).selected.key, "", set -> {
                            if (set && !((String)value.value).isEmpty()) {
                                ButtonNBTCollection parent = ((NBTEditorScreen)NBTEditorScreen.this).selected.parent;
                                String s0 = ((NBTEditorScreen)NBTEditorScreen.this).selected.key;
                                INBT nbt = parent.getTag(s0);
                                parent.setTag(s0, null);
                                parent.setTag((String)value.value, nbt);
                                parent.updateChildren(false);
                                NBTEditorScreen.this.selected = parent.children.get(value.value);
                                NBTEditorScreen.this.panelNbt.refreshWidgets();
                            }
                            this.getGui().openGui();
                        });
                    }
                }));
                if (NBTEditorScreen.this.selected instanceof ButtonNumericTag) {
                    this.add(new SimpleButton(this, (ITextComponent)new TranslationTextComponent("selectServer.edit"), Icons.FEATHER, (widget, button) -> ((ButtonNumericTag)NBTEditorScreen.this.selected).edit()));
                }
                if (NBTEditorScreen.this.selected.canCreateNew(10)) {
                    this.add(NBTEditorScreen.this.newTag(this, "Compound", NBT_MAP, CompoundNBT::new));
                }
                if (NBTEditorScreen.this.selected.canCreateNew(9)) {
                    this.add(NBTEditorScreen.this.newTag(this, "List", NBT_LIST, ListNBT::new));
                }
                if (NBTEditorScreen.this.selected.canCreateNew(8)) {
                    this.add(NBTEditorScreen.this.newTag(this, "String", NBT_STRING, () -> StringNBT.func_229705_a_((String)"")));
                }
                if (NBTEditorScreen.this.selected.canCreateNew(1)) {
                    this.add(NBTEditorScreen.this.newTag(this, "Byte", NBT_BYTE, () -> ByteNBT.func_229671_a_((byte)0)));
                }
                if (NBTEditorScreen.this.selected.canCreateNew(2)) {
                    this.add(NBTEditorScreen.this.newTag(this, "Short", NBT_SHORT, () -> ShortNBT.func_229701_a_((short)0)));
                }
                if (NBTEditorScreen.this.selected.canCreateNew(3)) {
                    this.add(NBTEditorScreen.this.newTag(this, "Int", NBT_INT, () -> IntNBT.func_229692_a_((int)0)));
                }
                if (NBTEditorScreen.this.selected.canCreateNew(4)) {
                    this.add(NBTEditorScreen.this.newTag(this, "Long", NBT_LONG, () -> LongNBT.func_229698_a_((long)0L)));
                }
                if (NBTEditorScreen.this.selected.canCreateNew(5)) {
                    this.add(NBTEditorScreen.this.newTag(this, "Float", NBT_FLOAT, () -> FloatNBT.func_229689_a_((float)0.0f)));
                }
                if (NBTEditorScreen.this.selected.canCreateNew(6)) {
                    this.add(NBTEditorScreen.this.newTag(this, "Double", NBT_DOUBLE, () -> DoubleNBT.func_229684_a_((double)0.0)));
                }
                if (NBTEditorScreen.this.selected.canCreateNew(7)) {
                    this.add(NBTEditorScreen.this.newTag(this, "Byte Array", NBT_BYTE_ARRAY, () -> new ByteArrayNBT(new byte[0])));
                }
                if (NBTEditorScreen.this.selected.canCreateNew(11)) {
                    this.add(NBTEditorScreen.this.newTag(this, "Int Array", NBT_INT_ARRAY, () -> new IntArrayNBT(new int[0])));
                }
            }

            @Override
            public void alignWidgets() {
                this.setWidth(this.align(new WidgetLayout.Horizontal(2, 4, 2)));
            }
        };
        this.panelTopLeft.setPosAndSize(0, 2, 0, 16);
        this.panelTopRight = new Panel(this){

            @Override
            public void addWidgets() {
                this.add(new SimpleButton(this, (ITextComponent)new TranslationTextComponent("gui.copy"), ItemIcon.getItemIcon(Items.field_151121_aF), (widget, button) -> 3.setClipboardString(NBTEditorScreen.this.selected.copy().toString())));
                this.add(new SimpleButton(this, (ITextComponent)new TranslationTextComponent("gui.collapse_all"), Icons.REMOVE, (widget, button) -> {
                    for (Widget w : NBTEditorScreen.this.panelNbt.widgets) {
                        if (!(w instanceof ButtonNBTCollection)) continue;
                        ((ButtonNBTCollection)w).setCollapsed(true);
                    }
                    NBTEditorScreen.this.scroll.setValue(0.0);
                    NBTEditorScreen.this.panelNbt.refreshWidgets();
                }));
                this.add(new SimpleButton(this, (ITextComponent)new TranslationTextComponent("gui.expand_all"), Icons.ADD, (widget, button) -> {
                    for (Widget w : NBTEditorScreen.this.panelNbt.widgets) {
                        if (!(w instanceof ButtonNBTCollection)) continue;
                        ((ButtonNBTCollection)w).setCollapsed(false);
                    }
                    NBTEditorScreen.this.scroll.setValue(0.0);
                    NBTEditorScreen.this.panelNbt.refreshWidgets();
                }));
                this.add(new SimpleButton(this, (ITextComponent)new TranslationTextComponent("gui.cancel"), Icons.CANCEL, (widget, button) -> {
                    NBTEditorScreen.this.shouldClose = 2;
                    widget.getGui().closeGui();
                }));
                this.add(new SimpleButton(this, (ITextComponent)new TranslationTextComponent("gui.accept"), Icons.ACCEPT, (widget, button) -> {
                    NBTEditorScreen.this.shouldClose = 1;
                    widget.getGui().closeGui();
                }));
            }

            @Override
            public void alignWidgets() {
                this.setWidth(this.align(new WidgetLayout.Horizontal(2, 4, 2)));
            }
        };
        this.panelNbt = new Panel(this){

            @Override
            public void addWidgets() {
                this.add(NBTEditorScreen.this.buttonNBTRoot);
                NBTEditorScreen.this.buttonNBTRoot.addChildren();
            }

            @Override
            public void alignWidgets() {
                NBTEditorScreen.this.scroll.setMaxValue(this.align(WidgetLayout.VERTICAL) + 2);
            }
        };
        this.buttonNBTRoot = new ButtonNBTMap(this.panelNbt, null, this.info.func_74764_b("title") ? ITextComponent.Serializer.func_240643_a_((String)this.info.func_74779_i("title")).getString() : "ROOT", nbt);
        this.buttonNBTRoot.updateChildren(true);
        this.buttonNBTRoot.setCollapsedTree(true);
        this.buttonNBTRoot.setCollapsed(false);
        this.selected = this.buttonNBTRoot;
        this.scroll = new PanelScrollBar(this, this.panelNbt);
    }

    @Override
    public void addWidgets() {
        this.add(this.panelTopLeft);
        this.add(this.panelTopRight);
        this.add(this.panelNbt);
        this.add(this.scroll);
    }

    @Override
    public void alignWidgets() {
        this.panelTopRight.setPosAndSize(this.width - this.panelTopRight.width, 2, 0, 16);
        this.panelTopRight.alignWidgets();
        this.panelNbt.setPosAndSize(0, 21, this.width - this.scroll.width, this.height - 20);
        this.panelNbt.alignWidgets();
        this.scroll.setPosAndSize(this.width - this.scroll.width, 20, 16, this.panelNbt.height);
    }

    @Override
    public boolean onInit() {
        return this.setFullscreen();
    }

    @Override
    public void onClosed() {
        super.onClosed();
        if (this.shouldClose == 1) {
            if (NBTUtils.getSizeInBytes(this.buttonNBTRoot.map, false) >= 30000L) {
                FTBLibrary.LOGGER.error("NBT too large to send!");
            } else {
                new EditNBTResponsePacket(this.info, this.buttonNBTRoot.map).sendToServer();
            }
        }
    }

    @Override
    public void drawBackground(MatrixStack stack, Theme theme, int x, int y, int w, int h) {
        EditConfigScreen.COLOR_BACKGROUND.draw(stack, 0, 0, w, 20);
    }

    @Override
    public Theme getTheme() {
        return EditConfigScreen.THEME;
    }

    @Override
    public boolean doesGuiPauseGame() {
        return true;
    }

    private /* synthetic */ void lambda$null$0(StringConfig value, Supplier supplier, boolean set) {
        if (set && !((String)value.value).isEmpty()) {
            ((ButtonNBTCollection)this.selected).setTag((String)value.value, (INBT)supplier.get());
            this.selected.updateChildren(false);
            this.panelNbt.refreshWidgets();
        }
        this.openGui();
    }

    public class ButtonNBTIntArray
    extends ButtonNBTCollection {
        private final IntArrayList list;

        public ButtonNBTIntArray(Panel panel, ButtonNBTCollection p, String key, IntArrayNBT l) {
            super(panel, p, key, NBT_INT_ARRAY_OPEN, NBT_INT_ARRAY_CLOSED);
            this.list = new IntArrayList(l.func_150302_c());
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = NBTEditorScreen.this.getFrom(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public INBT getTag(String k) {
            return IntNBT.func_229692_a_((int)this.list.getInt(Integer.parseInt(k)));
        }

        @Override
        public void setTag(String k, @Nullable INBT base) {
            int id = Integer.parseInt(k);
            if (id == -1) {
                if (base != null) {
                    this.list.add(((NumberNBT)base).func_150287_d());
                }
            } else if (base != null) {
                this.list.set(id, ((NumberNBT)base).func_150287_d());
            } else {
                this.list.rem(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (INBT)new IntArrayNBT(this.list.toIntArray()));
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return id == 3;
        }

        @Override
        public CompoundNBT copy() {
            CompoundNBT n = new CompoundNBT();
            n.func_218657_a(this.key, (INBT)new IntArrayNBT(this.list.toIntArray()));
            return n;
        }
    }

    public class ButtonNBTByteArray
    extends ButtonNBTCollection {
        private final ByteArrayList list;

        public ButtonNBTByteArray(Panel panel, ButtonNBTCollection p, String key, ByteArrayNBT l) {
            super(panel, p, key, NBT_BYTE_ARRAY_OPEN, NBT_BYTE_ARRAY_CLOSED);
            this.list = new ByteArrayList(l.func_150292_c());
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = NBTEditorScreen.this.getFrom(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public INBT getTag(String k) {
            return ByteNBT.func_229671_a_((byte)this.list.getByte(Integer.parseInt(k)));
        }

        @Override
        public void setTag(String k, @Nullable INBT base) {
            int id = Integer.parseInt(k);
            if (id == -1) {
                if (base != null) {
                    this.list.add(((NumberNBT)base).func_150290_f());
                }
            } else if (base != null) {
                this.list.set(id, ((NumberNBT)base).func_150290_f());
            } else {
                this.list.removeByte(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (INBT)new ByteArrayNBT(this.list.toByteArray()));
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return id == 1;
        }

        @Override
        public CompoundNBT copy() {
            CompoundNBT n = new CompoundNBT();
            n.func_218657_a(this.key, (INBT)new ByteArrayNBT(this.list.toByteArray()));
            return n;
        }
    }

    public class ButtonNBTList
    extends ButtonNBTCollection {
        private final ListNBT list;

        public ButtonNBTList(Panel panel, ButtonNBTCollection p, String key, ListNBT l) {
            super(panel, p, key, NBT_LIST_OPEN, NBT_LIST_CLOSED);
            this.list = l;
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = NBTEditorScreen.this.getFrom(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public INBT getTag(String k) {
            return this.list.get(Integer.parseInt(k));
        }

        @Override
        public void setTag(String k, @Nullable INBT base) {
            int id = Integer.parseInt(k);
            if (id == -1) {
                if (base != null) {
                    this.list.add((Object)base);
                }
            } else if (base != null) {
                this.list.set(id, base);
            } else {
                this.list.remove(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (INBT)this.list);
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return this.list.isEmpty() || this.list.func_230528_d__() == id;
        }

        @Override
        public CompoundNBT copy() {
            CompoundNBT n = new CompoundNBT();
            n.func_218657_a(this.key, (INBT)this.list);
            return n;
        }
    }

    public class ButtonNBTMap
    extends ButtonNBTCollection {
        private final CompoundNBT map;
        private Icon hoverIcon;

        public ButtonNBTMap(@Nullable Panel panel, ButtonNBTCollection b, String key, CompoundNBT m) {
            super(panel, b, key, NBT_MAP_OPEN, NBT_MAP_CLOSED);
            this.hoverIcon = Icon.EMPTY;
            this.map = m;
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            ArrayList<Object> list = new ArrayList<Object>(this.map.func_150296_c());
            list.sort(StringUtils.IGNORE_CASE_COMPARATOR);
            for (String string : list) {
                ButtonNBT nbt = NBTEditorScreen.this.getFrom(this, string);
                this.children.put(string, nbt);
                nbt.updateChildren(first);
            }
            this.updateHoverIcon();
            if (first && !this.hoverIcon.isEmpty()) {
                this.setCollapsed(true);
            }
        }

        private void updateHoverIcon() {
            ItemStack stack;
            this.hoverIcon = Icon.EMPTY;
            if (this.map.func_150297_b("id", 8) && this.map.func_150297_b("Count", 99) && !(stack = ItemStack.func_199557_a((CompoundNBT)this.map)).func_190926_b()) {
                this.hoverIcon = ItemIcon.getItemIcon(stack);
            }
            this.setWidth(12 + NBTEditorScreen.this.getTheme().getStringWidth((ITextProperties)this.getTitle()) + (this.hoverIcon.isEmpty() ? 0 : 10));
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            ListNBT infoList;
            if (this == NBTEditorScreen.this.buttonNBTRoot && (infoList = NBTEditorScreen.this.info.func_150295_c("text", 8)).size() > 0) {
                list.add((ITextComponent)new TranslationTextComponent("gui.info").func_240702_b_(":"));
                for (int i = 0; i < infoList.size(); ++i) {
                    IFormattableTextComponent component = ITextComponent.Serializer.func_240643_a_((String)infoList.func_150307_f(i));
                    if (component == null) continue;
                    list.add((ITextComponent)component);
                }
            }
        }

        @Override
        public void draw(MatrixStack pose, Theme theme, int x, int y, int w, int h) {
            super.draw(pose, theme, x, y, w, h);
            if (!this.hoverIcon.isEmpty()) {
                this.hoverIcon.draw(pose, x + 12 + theme.getStringWidth((ITextProperties)this.getTitle()), y + 1, 8, 8);
            }
        }

        @Override
        @Nullable
        public Object getIngredientUnderMouse() {
            return new WrappedIngredient(this.hoverIcon.getIngredient()).tooltip();
        }

        @Override
        public INBT getTag(String k) {
            return this.map.func_74781_a(k);
        }

        @Override
        public void setTag(String k, @Nullable INBT base) {
            if (base != null) {
                this.map.func_218657_a(k, base);
            } else {
                this.map.func_82580_o(k);
            }
            this.updateHoverIcon();
            if (this.parent != null) {
                this.parent.setTag(this.key, (INBT)this.map);
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return true;
        }

        @Override
        public CompoundNBT copy() {
            CompoundNBT nbt = this.map.func_74737_b();
            if (this == NBTEditorScreen.this.buttonNBTRoot) {
                ListNBT infoList1 = new ListNBT();
                ListNBT infoList0 = NBTEditorScreen.this.info.func_150295_c("text", 8);
                if (infoList0.size() > 0) {
                    for (int i = 0; i < infoList0.size(); ++i) {
                        IFormattableTextComponent component = ITextComponent.Serializer.func_240643_a_((String)infoList0.func_150307_f(i));
                        if (component == null) continue;
                        infoList1.add((Object)StringNBT.func_229705_a_((String)component.getString()));
                    }
                    nbt.func_218657_a("_", (INBT)infoList1);
                }
            }
            return nbt;
        }
    }

    public abstract class ButtonNBTCollection
    extends ButtonNBT {
        public boolean collapsed;
        public final Map<String, ButtonNBT> children;
        public final Icon iconOpen;
        public final Icon iconClosed;

        public ButtonNBTCollection(@Nullable Panel panel, ButtonNBTCollection b, String key, Icon open, Icon closed) {
            super(panel, b, key);
            this.iconOpen = open;
            this.iconClosed = closed;
            this.setCollapsed(false);
            this.setWidth(this.width + 2 + NBTEditorScreen.this.getTheme().getStringWidth(key));
            this.children = new LinkedHashMap<String, ButtonNBT>();
        }

        @Override
        public void addChildren() {
            if (!this.collapsed) {
                for (ButtonNBT button : this.children.values()) {
                    NBTEditorScreen.this.panelNbt.add(button);
                    button.addChildren();
                }
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            if (this.getMouseX() <= this.getX() + this.height) {
                this.setCollapsed(!this.collapsed);
                NBTEditorScreen.this.panelNbt.refreshWidgets();
            } else {
                NBTEditorScreen.this.selected = this;
                NBTEditorScreen.this.panelTopLeft.refreshWidgets();
            }
        }

        public void setCollapsed(boolean c) {
            this.collapsed = c;
            this.setIcon(this.collapsed ? this.iconClosed : this.iconOpen);
        }

        public void setCollapsedTree(boolean c) {
            this.setCollapsed(c);
            for (ButtonNBT button : this.children.values()) {
                if (!(button instanceof ButtonNBTCollection)) continue;
                ((ButtonNBTCollection)button).setCollapsedTree(c);
            }
        }

        public abstract INBT getTag(String var1);

        public abstract void setTag(String var1, @Nullable INBT var2);
    }

    public class ButtonNumericTag
    extends ButtonNBT {
        private INBT nbt;

        public ButtonNumericTag(Panel panel, ButtonNBTCollection b, String k, INBT n) {
            super(panel, b, k);
            this.nbt = n;
            switch (this.nbt.func_74732_a()) {
                case 1: {
                    this.setIcon(NBT_BYTE);
                    break;
                }
                case 2: {
                    this.setIcon(NBT_SHORT);
                    break;
                }
                case 3: {
                    this.setIcon(NBT_INT);
                    break;
                }
                case 4: {
                    this.setIcon(NBT_LONG);
                    break;
                }
                case 5: {
                    this.setIcon(NBT_FLOAT);
                    break;
                }
                case 6: 
                case 99: {
                    this.setIcon(NBT_DOUBLE);
                    break;
                }
                case 8: {
                    this.setIcon(NBT_STRING);
                }
            }
            this.parent.setTag(this.key, this.nbt);
            this.updateTitle();
        }

        public void updateTitle() {
            Object title = "";
            switch (this.nbt.func_74732_a()) {
                case 1: 
                case 2: 
                case 3: {
                    title = ((NumberNBT)this.nbt).func_150287_d();
                    break;
                }
                case 4: {
                    title = ((NumberNBT)this.nbt).func_150291_c();
                    break;
                }
                case 5: 
                case 6: 
                case 99: {
                    title = ((NumberNBT)this.nbt).func_150286_g();
                    break;
                }
                case 8: {
                    title = this.nbt.func_150285_a_();
                }
            }
            this.setTitle((ITextComponent)new StringTextComponent(this.key + ": " + title));
            this.setWidth(12 + NBTEditorScreen.this.getTheme().getStringWidth(this.key + ": " + title));
        }

        @Override
        public void onClicked(MouseButton button) {
            NBTEditorScreen.this.selected = this;
            NBTEditorScreen.this.panelTopLeft.refreshWidgets();
            if (button.isRight()) {
                this.edit();
            }
        }

        public void edit() {
            switch (this.nbt.func_74732_a()) {
                case 1: 
                case 2: 
                case 3: {
                    IntConfig intConfig = new IntConfig(Integer.MIN_VALUE, Integer.MAX_VALUE);
                    EditConfigFromStringScreen.open(intConfig, ((NumberNBT)this.nbt).func_150287_d(), 0, accepted -> this.onCallback(intConfig, accepted));
                    break;
                }
                case 4: {
                    LongConfig longConfig = new LongConfig(Long.MIN_VALUE, Long.MAX_VALUE);
                    EditConfigFromStringScreen.open(longConfig, ((NumberNBT)this.nbt).func_150291_c(), 0L, accepted -> this.onCallback(longConfig, accepted));
                    break;
                }
                case 5: 
                case 6: 
                case 99: {
                    DoubleConfig doubleConfig = new DoubleConfig(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                    EditConfigFromStringScreen.open(doubleConfig, ((NumberNBT)this.nbt).func_150286_g(), 0.0, accepted -> this.onCallback(doubleConfig, accepted));
                    break;
                }
                case 8: {
                    StringConfig stringConfig = new StringConfig();
                    EditConfigFromStringScreen.open(stringConfig, this.nbt.func_150285_a_(), "", accepted -> this.onCallback(stringConfig, accepted));
                }
            }
        }

        public void onCallback(ConfigValue<?> value, boolean set) {
            if (set) {
                switch (this.nbt.func_74732_a()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.nbt = IntNBT.func_229692_a_((int)((Number)value.value).intValue());
                        break;
                    }
                    case 4: {
                        this.nbt = LongNBT.func_229698_a_((long)((Number)value.value).longValue());
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 99: {
                        this.nbt = DoubleNBT.func_229684_a_((double)((Number)value.value).doubleValue());
                        break;
                    }
                    case 8: {
                        this.nbt = StringNBT.func_229705_a_((String)value.value.toString());
                    }
                }
                this.parent.setTag(this.key, this.nbt);
                this.updateTitle();
            }
            NBTEditorScreen.this.openGui();
        }

        @Override
        public CompoundNBT copy() {
            CompoundNBT n = new CompoundNBT();
            n.func_218657_a(this.key, this.nbt);
            return n;
        }
    }

    public abstract class ButtonNBT
    extends Button {
        public final ButtonNBTCollection parent;
        public String key;

        public ButtonNBT(@Nullable Panel panel, ButtonNBTCollection b, String k) {
            super(panel);
            this.setPosAndSize(b == null ? 0 : b.posX + 10, 0, 10, 10);
            this.parent = b;
            this.key = k;
            this.setTitle((ITextComponent)new StringTextComponent(this.key));
        }

        public abstract CompoundNBT copy();

        public void updateChildren(boolean first) {
        }

        public void addChildren() {
        }

        public boolean canCreateNew(int id) {
            return false;
        }

        @Override
        public void addMouseOverText(TooltipList list) {
        }

        @Override
        public void draw(MatrixStack pose, Theme theme, int x, int y, int w, int h) {
            if (NBTEditorScreen.this.selected == this) {
                Color4I.WHITE.withAlpha(33).draw(pose, x, y, w, h);
            }
            IconWithBorder.BUTTON_ROUND_GRAY.draw(pose, x + 1, y + 1, 8, 8);
            this.drawIcon(pose, theme, x + 1, y + 1, 8, 8);
            theme.drawString(pose, this.getTitle(), x + 11, y + 1);
        }
    }
}

