/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.sidebar;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButton;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonCreatedEvent;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonGroup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;

public enum SidebarButtonManager implements IResourceManagerReloadListener
{
    INSTANCE;

    public final List<SidebarButtonGroup> groups = new ArrayList<SidebarButtonGroup>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonElement readJson(IResource resource) {
        try (InputStreamReader reader = new InputStreamReader(resource.func_199027_b());){
            JsonElement jsonElement = new JsonParser().parse((Reader)reader);
            return jsonElement;
        }
        catch (Exception exception) {
            return JsonNull.INSTANCE;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonElement readJson(File file) {
        try (FileReader reader = new FileReader(file);){
            JsonElement jsonElement = new JsonParser().parse((Reader)reader);
            return jsonElement;
        }
        catch (Exception exception) {
            return JsonNull.INSTANCE;
        }
    }

    public void func_195410_a(IResourceManager manager) {
        JsonElement json;
        this.groups.clear();
        JsonElement element = this.readJson(Platform.getConfigFolder().resolve("sidebar_buttons.json").toFile());
        JsonObject sidebarButtonConfig = element.isJsonObject() ? element.getAsJsonObject() : new JsonObject();
        HashMap<ResourceLocation, SidebarButtonGroup> groupMap = new HashMap<ResourceLocation, SidebarButtonGroup>();
        for (String domain : manager.func_199001_a()) {
            try {
                for (IResource resource : manager.func_199004_b(new ResourceLocation(domain, "sidebar_button_groups.json"))) {
                    json = this.readJson(resource);
                    for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                        JsonObject groupJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                        int y = 0;
                        if (groupJson.has("y")) {
                            y = groupJson.get("y").getAsInt();
                        }
                        SidebarButtonGroup group = new SidebarButtonGroup(new ResourceLocation(domain, (String)entry.getKey()), y);
                        groupMap.put(group.getId(), group);
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) continue;
                ex.printStackTrace();
            }
        }
        for (String domain : manager.func_199001_a()) {
            try {
                for (IResource resource : manager.func_199004_b(new ResourceLocation(domain, "sidebar_buttons.json"))) {
                    json = this.readJson(resource);
                    if (!json.isJsonObject()) continue;
                    for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                        SidebarButtonGroup group;
                        JsonObject buttonJson;
                        if (!((JsonElement)entry.getValue()).isJsonObject() || !(buttonJson = ((JsonElement)entry.getValue()).getAsJsonObject()).has("group") || buttonJson.has("dev_only") && buttonJson.get("dev_only").getAsBoolean() || (group = (SidebarButtonGroup)groupMap.get(new ResourceLocation(buttonJson.get("group").getAsString()))) == null) continue;
                        SidebarButton button = new SidebarButton(new ResourceLocation(domain, (String)entry.getKey()), group, buttonJson);
                        group.getButtons().add(button);
                        if (sidebarButtonConfig.has(button.id.func_110624_b())) {
                            JsonElement e = sidebarButtonConfig.get(button.id.func_110624_b());
                            if (!e.isJsonObject() || !e.getAsJsonObject().has(button.id.func_110623_a())) continue;
                            button.setConfig(e.getAsJsonObject().get(button.id.func_110623_a()).getAsBoolean());
                            continue;
                        }
                        if (!sidebarButtonConfig.has(button.id.toString())) continue;
                        button.setConfig(sidebarButtonConfig.get(button.id.toString()).getAsBoolean());
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) continue;
                ex.printStackTrace();
            }
        }
        for (SidebarButtonGroup group : groupMap.values()) {
            if (group.getButtons().isEmpty()) continue;
            group.getButtons().sort(null);
            this.groups.add(group);
        }
        this.groups.sort(null);
        for (SidebarButtonGroup group : this.groups) {
            for (SidebarButton button : group.getButtons()) {
                ((Consumer)SidebarButtonCreatedEvent.EVENT.invoker()).accept(new SidebarButtonCreatedEvent(button));
            }
        }
        this.saveConfig();
    }

    public void saveConfig() {
        JsonObject o = new JsonObject();
        for (SidebarButtonGroup group : this.groups) {
            for (SidebarButton button : group.getButtons()) {
                JsonObject o1 = o.getAsJsonObject(button.id.func_110624_b());
                if (o1 == null) {
                    o1 = new JsonObject();
                    o.add(button.id.func_110624_b(), (JsonElement)o1);
                }
                o1.addProperty(button.id.func_110623_a(), Boolean.valueOf(button.getConfig()));
            }
        }
        File file = Platform.getConfigFolder().resolve("sidebar_buttons.json").toFile();
        try {
            FileWriter writer = new FileWriter(file);
            Object object = null;
            try {
                Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
                JsonWriter jsonWriter = new JsonWriter((Writer)writer);
                jsonWriter.setIndent("\t");
                gson.toJson((JsonElement)o, jsonWriter);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (object != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

