/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.snbt.OrderedCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.SNBTBuilder;
import dev.ftb.mods.ftblibrary.snbt.SNBTParser;
import dev.ftb.mods.ftblibrary.snbt.SNBTSyntaxException;
import dev.ftb.mods.ftblibrary.snbt.SNBTUtils;
import dev.ftb.mods.ftblibrary.snbt.TagProperties;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.StringNBT;
import org.jetbrains.annotations.Nullable;

public class SNBT {
    public static CompoundNBT readLines(List<String> lines) {
        return SNBTParser.read(lines);
    }

    @Nullable
    public static CompoundNBT read(Path path) {
        if (Files.notExists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) || !Files.isReadable(path)) {
            return null;
        }
        try {
            return SNBT.readLines(Files.readAllLines(path, StandardCharsets.UTF_8));
        }
        catch (SNBTSyntaxException ex) {
            FTBLibrary.LOGGER.error("Failed to read " + Platform.getGameFolder().relativize(path) + ": " + ex.getMessage());
            return null;
        }
        catch (Exception ex) {
            FTBLibrary.LOGGER.error("Failed to read " + Platform.getGameFolder().relativize(path) + ": " + ex);
            ex.printStackTrace();
            return null;
        }
    }

    public static List<String> writeLines(CompoundNBT nbt) {
        SNBTBuilder builder = new SNBTBuilder();
        SNBT.append(builder, (INBT)nbt);
        builder.println();
        return builder.lines;
    }

    public static boolean write(Path path, CompoundNBT nbt) {
        try {
            if (Files.notExists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            Files.write(path, SNBT.writeLines(nbt), new OpenOption[0]);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static void append(SNBTBuilder builder, @Nullable INBT nbt) {
        if (nbt == null || nbt instanceof EndNBT) {
            builder.print("null");
        } else if (nbt instanceof CompoundNBT) {
            OrderedCompoundTag ocompound;
            CompoundNBT compound = (CompoundNBT)nbt;
            OrderedCompoundTag orderedCompoundTag = ocompound = compound instanceof OrderedCompoundTag ? (OrderedCompoundTag)compound : null;
            if (compound.isEmpty()) {
                builder.print("{ }");
                return;
            }
            if (ocompound != null && ocompound.singleLine) {
                ++builder.singleLine;
            }
            boolean singleLine = builder.singleLine > 0;
            builder.print("{");
            if (singleLine) {
                builder.print(" ");
            } else {
                builder.println();
                builder.push();
            }
            int index = 0;
            for (String key : compound.func_150296_c()) {
                TagProperties properties;
                ++index;
                TagProperties tagProperties = properties = ocompound == null ? TagProperties.DEFAULT : ocompound.getProperties(key);
                if (!properties.comment.isEmpty()) {
                    if (singleLine) {
                        throw new IllegalStateException("Can't have singleLine enabled and a comment at the same time!");
                    }
                    if (index != 1) {
                        builder.println();
                    }
                    for (String s : properties.comment.split("\n")) {
                        builder.print("# ");
                        builder.print(s);
                        builder.println();
                    }
                }
                builder.print(SNBTUtils.handleEscape(key));
                builder.print(": ");
                if (properties.valueType == 1) {
                    builder.print("false");
                } else if (properties.valueType == 2) {
                    builder.print("true");
                } else if (properties.valueType == 3) {
                    builder.print("@");
                    builder.print(compound.func_186857_a(key));
                } else {
                    if (properties.singleLine) {
                        ++builder.singleLine;
                    }
                    SNBT.append(builder, compound.func_74781_a(key));
                    if (properties.singleLine) {
                        --builder.singleLine;
                    }
                }
                if (singleLine && index != compound.func_186856_d()) {
                    builder.print(",");
                }
                if (singleLine) {
                    builder.print(" ");
                    continue;
                }
                builder.println();
            }
            if (!singleLine) {
                builder.pop();
            }
            builder.print("}");
            if (ocompound != null && ocompound.singleLine) {
                --builder.singleLine;
            }
        } else if (nbt instanceof CollectionNBT) {
            if (nbt instanceof ByteArrayNBT) {
                SNBT.appendCollection(builder, (CollectionNBT<? extends INBT>)((CollectionNBT)nbt), "B;");
            } else if (nbt instanceof IntArrayNBT) {
                SNBT.appendCollection(builder, (CollectionNBT<? extends INBT>)((CollectionNBT)nbt), "I;");
            } else if (nbt instanceof LongArrayNBT) {
                SNBT.appendCollection(builder, (CollectionNBT<? extends INBT>)((CollectionNBT)nbt), "L;");
            } else {
                SNBT.appendCollection(builder, (CollectionNBT<? extends INBT>)((CollectionNBT)nbt), "");
            }
        } else if (nbt instanceof StringNBT) {
            builder.print(SNBTUtils.quoteAndEscape(nbt.func_150285_a_()));
        } else {
            builder.print(nbt.toString());
        }
    }

    private static void appendCollection(SNBTBuilder builder, CollectionNBT<? extends INBT> nbt, String opening) {
        if (nbt.isEmpty()) {
            builder.print("[");
            builder.print(opening);
            builder.print(" ]");
            return;
        }
        if (nbt.size() == 1) {
            builder.print("[");
            builder.print(opening);
            SNBT.append(builder, (INBT)nbt.get(0));
            builder.print("]");
            return;
        }
        boolean singleLine = builder.singleLine > 0;
        builder.print("[");
        builder.print(opening);
        if (singleLine) {
            builder.print(" ");
        } else {
            builder.println();
            builder.push();
        }
        int index = 0;
        for (INBT value : nbt) {
            SNBT.append(builder, value);
            if (singleLine && ++index != nbt.size()) {
                builder.print(",");
            }
            if (singleLine) {
                builder.print(" ");
                continue;
            }
            builder.println();
        }
        if (!singleLine) {
            builder.pop();
        }
        builder.print("]");
    }
}

