/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.biome_dictionary;

import com.google.common.collect.ImmutableList;
import com.legacy.structure_gel.StructureGelConfig;
import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.biome_dictionary.BiomeType;
import com.legacy.structure_gel.biome_dictionary.ForgeType;
import com.legacy.structure_gel.util.Internal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.GravelBlock;
import net.minecraft.block.material.Material;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class BiomeDictionary {
    @Internal
    private static final String bop = "biomesoplenty";
    @Internal
    private static final String nethercraft = "nethercraft";
    @Internal
    private static final String endergetic = "endergetic";
    @Internal
    private static final String rediscovered = "rediscovered";
    @Internal
    private static final String moo = "moolands";
    @Internal
    private static final String pagamos = "pagamos";
    @Internal
    private static final String glacidus = "glacidus";
    @Internal
    private static final String byg = "byg";
    @Internal
    private static final String aether = "aether";
    public static final IForgeRegistry<BiomeType> REGISTRY = RegistryManager.ACTIVE.getRegistry(BiomeType.class);
    @Internal
    private static final Map<ResourceLocation, Set<BiomeType>> BIOME_TO_BIOMETYPE_CACHE = new HashMap<ResourceLocation, Set<BiomeType>>();
    @Internal
    protected static final ResourceLocation EMPTY_NAME = StructureGelMod.locate("empty");
    @Internal
    public static final BiomeType EMPTY = new BiomeType(EMPTY_NAME, new HashSet<ResourceLocation>(), new HashSet<ResourceLocation>());
    public static final BiomeType FROZEN_OCEAN = BiomeDictionary.register(BiomeType.create("frozen_ocean").biomes(Biomes.field_76776_l, Biomes.field_203620_Z));
    public static final BiomeType COLD_OCEAN = BiomeDictionary.register(BiomeType.create("cold_ocean").biomes(Biomes.field_203616_V, Biomes.field_203619_Y));
    public static final BiomeType WARM_OCEAN = BiomeDictionary.register(BiomeType.create("warm_ocean").biomes(Biomes.field_203614_T, Biomes.field_203617_W));
    public static final BiomeType OCEAN = BiomeDictionary.register(BiomeType.create("ocean").parents(COLD_OCEAN, WARM_OCEAN, FROZEN_OCEAN).biomes(Biomes.field_76771_b, Biomes.field_203618_X, Biomes.field_150575_M, Biomes.field_203615_U).biomes("byg", "dead_sea"));
    public static final BiomeType PLAINS = BiomeDictionary.register(BiomeType.create("plains").biomes(Biomes.field_76772_c, Biomes.field_185441_Q).biomes("biomesoplenty", "grove_clearing", "steppe", "highland", "tundra", "lush_grassland", "jade_grassland", "shrubland", "wooded_scrubland", "lush_savanna", "scrubland", "flower_meadow", "prairie", "golden_prairie").biomes("byg", "allium_fields", "amaranth_fields", "meadow", "prairie", "prairie_clearing", "shrublands", "wooded_meadow"));
    public static final BiomeType SNOWY_PLAINS = BiomeDictionary.register(BiomeType.create("snowy_plains").biomes(Biomes.field_76774_n));
    public static final BiomeType DESERT = BiomeDictionary.register(BiomeType.create("desert").biomes(Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_185442_R).biomes("biomesoplenty", "xeric_shrubland", "outback", "lush_desert").biomes("byg", "dunes", "lush_red_desert", "mojave_desert", "red_desert", "red_desert_dunes"));
    public static final BiomeType SAVANNA = BiomeDictionary.register(BiomeType.create("savanna").biomes(Biomes.field_150588_X, Biomes.field_150587_Y).biomes("biomesoplenty", "brushland").biomes("byg", "baobab_savanna"));
    public static final BiomeType MOUNTAIN_SAVANNA = BiomeDictionary.register(BiomeType.create("mountain_savanna").biomes(Biomes.field_185435_ag, Biomes.field_185436_ah));
    public static final BiomeType FLOWERY = BiomeDictionary.register(BiomeType.create("flowery").biomes(Biomes.field_185444_T, Biomes.field_185441_Q).biomes("biomesoplenty", "lavender_field", "lavender_forest", "lush_savanna", "flower_meadow").biomes("byg", "allium_fields", "amaranth_fields", "flowering_enchanted_grove", "flowering_grove", "flowering_meadow"));
    public static final BiomeType OAK_FOREST = BiomeDictionary.register(BiomeType.create("oak_forest").biomes(Biomes.field_76767_f, Biomes.field_76785_t).biomes("biomesoplenty", "maple_forest", "snowy_maple_forest", "orchard", "origin_hills", "rainforest", "silkglade_nest", "snowy_forest").biomes("byg", "deciduous_clearing", "deciduous_forest", "deciduous_forest_hills", "orchard", "red_oak_forest", "red_oak_forest_hills", "snowy_deciduous_clearing", "snowy_deciduous_forest", "snowy_deciduous_forest_hills", "woodlands"));
    public static final BiomeType BIRCH_FOREST = BiomeDictionary.register(BiomeType.create("birch_forest").biomes(Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_185448_Z, Biomes.field_185429_aa).biomes("biomesoplenty", "boreal_forest", "rainbow_valley").biomes("byg", "aspen_clearing", "aspen_forest", "aspen_forest_hills"));
    public static final BiomeType SPRUCE_FOREST = BiomeDictionary.register(BiomeType.create("spruce_forest").biomes(Biomes.field_76768_g, Biomes.field_76784_u, Biomes.field_150590_f).biomes("biomesoplenty", "coniferous_lakes", "grove", "meadow", "meadow_forest", "jade_cliffs").biomes("byg", "blue_taiga", "blue_taiga_hills", "boreal_clearing", "boreal_forest", "boreal_forest_hills", "evergreen_clearing", "evergreen_hills", "evergreen_taiga"));
    public static final BiomeType SNOWY_SPRUCE_FOREST = BiomeDictionary.register(BiomeType.create("snowy_spruce_forest").biomes(Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_185431_ac).biomes("byg", "apline_foothills", "snowy_blue_taiga", "snowy_blue_taiga_hills", "snowy_evergreen_clearing", "snowy_evergreen_hills", "snowy_evergreen_taiga"));
    public static final BiomeType LARGE_SPRUCE_FOREST = BiomeDictionary.register(BiomeType.create("large_spruce_forest").biomes(Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_150578_U, Biomes.field_150581_V).biomes("byg", "blue_giant_taiga", "snowy_blue_giant_taiga"));
    public static final BiomeType BAMBOO_JUNGLE = BiomeDictionary.register(BiomeType.create("bamboo_jungle").biomes(Biomes.field_222370_aw, Biomes.field_222371_ax));
    public static final BiomeType JUNGLE = BiomeDictionary.register(BiomeType.create("jungle").parents(BAMBOO_JUNGLE).biomes(Biomes.field_76782_w, Biomes.field_76792_x, Biomes.field_150574_L, Biomes.field_185446_X, Biomes.field_185447_Y).biomes("biomesoplenty", "rainforest_cliffs").biomes("byg", "guiana_clearing", "guiana_shield"));
    public static final BiomeType DARK_FOREST = BiomeDictionary.register(BiomeType.create("dark_forest").biomes(Biomes.field_150585_R, Biomes.field_185430_ab).biomes("byg", "ancient_forest", "ebony_woods", "ebony_hills", "flowering_ancient_forest"));
    public static final BiomeType CONIFEROUS_FOREST = BiomeDictionary.register(BiomeType.create("coniferous_forest").biomes("biomesoplenty", "snowy_coniferous_forest", "coniferous_forest", "fir_clearing", "snowy_fir_clearing").biomes("byg", "coniferous_clearing", "coniferous_forest", "coniferous_forest_hills", "snowy_coniferous_clearing", "snowy_coniferous_forest", "snowy_coniferous_forest_hills"));
    public static final BiomeType REDWOOD_FOREST = BiomeDictionary.register(BiomeType.create("redwood_forest").biomes("biomesoplenty", "redwood_forest", "redwood_forest_edge", "redwood_forest", "redwood_forest_hills", "redwood_hills").biomes("byg", "redwood_clearing", "redwood_mountains", "redwood_tropics"));
    public static final BiomeType AUTUMN_FOREST = BiomeDictionary.register(BiomeType.create("autumn_forest").biomes("biomesoplenty", "maple_forest", "seasonal_forest", "seasonal_orchard", "seasonal_pumpkin_patch").biomes("byg", "maple_hills", "maple_taiga", "seasonal_birch_forest", "seasonal_birch_forest_hills", "seasonal_deciduous_clearing", "seasonal_deciduous_forest", "seasonal_deciduous_forest_hills", "seasonal_forest", "seasonal_forest_hills", "seasonal_giant_taiga", "seasonal_taiga", "seasonal_taiga_hills", "zelkova_clearing", "zelkova_forest", "zelkova_forest_hills"));
    public static final BiomeType CHERRY_FOREST = BiomeDictionary.register(BiomeType.create("cherry_forest").biomes("biomesoplenty", "cherry_blossom_grove", "bamboo_blossom_grove").biomes("byg", "cherry_blossom_clearing", "cherry_blossom_forest", "skyris_highlands"));
    public static final BiomeType BAMBOO = BiomeDictionary.register(BiomeType.create("bamboo").parents(BAMBOO_JUNGLE).biomes("biomesoplenty", "bamboo_blossom_grove").biomes("byg", "jacaranda_clearing", "jacaranda_forest", "jacaranda_forest_hills", "bamboo_forest", "crag_gardens"));
    public static final BiomeType MOUNTAIN = BiomeDictionary.register(BiomeType.create("mountain").biomes(Biomes.field_76770_e, Biomes.field_76783_v, Biomes.field_185443_S, Biomes.field_185434_af, Biomes.field_150580_W).biomes("biomesoplenty", "steppe", "rainforest_cliffs", "highland_moor", "highland", "highland_crag", "shrubland_hills", "jade_cliffs").biomes("byg", "bluff_steeps", "cika_mountains", "crag_gardens", "dover_mountains", "grassland_plateau", "guiana_clearing", "guiana_shield", "redwood_mountains", "skyris_highlands", "wooded_grassland_plateau"));
    public static final BiomeType SNOWY_MOUNTAIN = BiomeDictionary.register(BiomeType.create("snowy_mountain").biomes(Biomes.field_76775_o).biomes("biomesoplenty", "alps", "alps_foothills").biomes("byg", "apls", "apline_foothills", "bluff_peaks", "bluff_steeps"));
    public static final BiomeType SWAMP = BiomeDictionary.register(BiomeType.create("swamp").biomes(Biomes.field_76780_h, Biomes.field_150599_m).biomes("biomesoplenty", "dead_swamp", "rainforest_floodplain", "bayou", "deep_bayou", "wetland", "lush_swamp", "bog", "wetland_marsh").biomes("byg", "bayou", "tundra_bog", "cold_swamplands", "cypress_swamplands", "glowshroom_bayou", "marshlands", "vibrant_swamplands"));
    public static final BiomeType MANGROVE = BiomeDictionary.register(BiomeType.create("mangrove").biomes("biomesoplenty", "bayou_mangrove").biomes("byg", "coral_mangroves", "cypress_swamplands", "mangrove_marshes"));
    public static final BiomeType BADLANDS = BiomeDictionary.register(BiomeType.create("badlands").biomes(Biomes.field_150589_Z, Biomes.field_150608_ab, Biomes.field_185437_ai, Biomes.field_185439_ak, Biomes.field_185438_aj, Biomes.field_150607_aa).biomes("biomesoplenty", "outback").biomes("byg", "lush_red_desert", "red_desert", "red_desert_dunes", "red_rock_highlands", "red_rock_lowlands", "red_rock_mountains", "sierra_range", "sierra_valley", "wooded_red_rock_mountains"));
    public static final BiomeType MUSHROOM = BiomeDictionary.register(BiomeType.create("mushroom").biomes(Biomes.field_76788_q, Biomes.field_76789_p).biomes("biomesoplenty", "fungal_jungle", "overgrown_fungal_jungle").biomes("byg", "glowing_ancient_forest", "glowshroom_bayou"));
    public static final BiomeType FUNGAL = BiomeDictionary.register(BiomeType.create("fungal").parents(MUSHROOM).biomes("biomesoplenty", "fungal_field").biomes("byg", "fungal_patch"));
    public static final BiomeType RIVER = BiomeDictionary.register(BiomeType.create("river").biomes(Biomes.field_76781_i, Biomes.field_76777_m));
    public static final BiomeType LAKE = BiomeDictionary.register(BiomeType.create("lake").biomes("biomesoplenty", "oasis", "grove_lakes").biomes("byg", "fresh_water_lake", "oasis", "frozen_lake", "great_lakes", "polluted_lake"));
    public static final BiomeType BEACH = BiomeDictionary.register(BiomeType.create("beach").biomes(Biomes.field_76787_r).biomes("biomesoplenty", "tropic_beach").biomes("byg", "rainbow_beach", "snowy_black_beach", "white_beach"));
    public static final BiomeType WOODED = BiomeDictionary.register(BiomeType.create("wooded").parents(OAK_FOREST, BIRCH_FOREST, SPRUCE_FOREST, SNOWY_SPRUCE_FOREST, DARK_FOREST, AUTUMN_FOREST, CHERRY_FOREST).biomes(Biomes.field_185444_T).biomes("biomesoplenty", "seasonal_forest", "lavender_field", "tropical_rainforest", "dead_forest").biomes("byg", "jacaranda_forest", "the_black_forest", "black_forest_hills", "bluff_peaks", "bluff_steeps", "enchanted_forest", "enchanted_forest_hills", "flowering_meadow", "forest_fault", "glowing_ancient_forest", "great_lake_isles", "grove", "weeping_witch_forest", "weeping_witch_clearing", "wooded_grassland_plateau", "wooded_meadow", "wooded_red_rock_mountains"));
    public static final BiomeType LARGE_WOODED = BiomeDictionary.register(BiomeType.create("large_wooded").parents(LARGE_SPRUCE_FOREST, JUNGLE, CONIFEROUS_FOREST, REDWOOD_FOREST).biomes("byg", "cika_wooded", "cika_mountains", "dover_mountains", "northern_forest"));
    public static final BiomeType SANDY = BiomeDictionary.register(BiomeType.create("sandy").parents(DESERT, BEACH).biomes(Biomes.field_235252_ay_, Biomes.field_150589_Z));
    public static final BiomeType GRAVELLY = BiomeDictionary.register(BiomeType.create("gravelly").biomes("biomesoplenty", "gravel_beach", "tundra_basin"));
    public static final BiomeType DIRTY = BiomeDictionary.register(BiomeType.create("dirty").biomes(Biomes.field_185432_ad, Biomes.field_185433_ae).biomes("byg", "black_forest_clearing"));
    public static final BiomeType TROPICAL = BiomeDictionary.register(BiomeType.create("tropical").biomes("biomesoplenty", "tropic_beach", "tropics", "tropic_plains", "rainforest", "tropical_rainforest", "rainforest_cliffs").biomes("byg", "tropical_fungal_forest", "tropical_fungal_rainforest_hills", "tropical_island", "tropical_rainforest", "tropical_rainforest_hills"));
    public static final BiomeType VOLCANIC = BiomeDictionary.register(BiomeType.create("volcanic").biomes("biomesoplenty", "volcanic_plains", "volcano"));
    public static final BiomeType DEAD = BiomeDictionary.register(BiomeType.create("dead").biomes(Biomes.field_235254_j_).biomes("biomesoplenty", "wooded_wasteland", "dry_boneyard", "burnt_forest", "dead_forest", "wasteland", "silkglade", "silkglade_nest", "xeric_shrubland", "brushland", "dead_swamp", "dryland").biomes("byg", "dead_sea"));
    public static final BiomeType SKY = BiomeDictionary.register(BiomeType.create("sky").biomes("rediscovered", "skylands"));
    public static final BiomeType FROZEN = BiomeDictionary.register(BiomeType.create("frozen").biomes(Biomes.field_76777_m, Biomes.field_185445_W).parents(FROZEN_OCEAN).biomes("byg", "frozen_lake", "shattered_glacier"));
    public static final BiomeType SNOWY = BiomeDictionary.register(BiomeType.create("snowy").parents(SNOWY_SPRUCE_FOREST, SNOWY_PLAINS).biomes(Biomes.field_76777_m, Biomes.field_150577_O).biomes("biomesoplenty", "snowy_forest", "snowy_coniferous_forest", "snowy_fir_clearing", "muskeg", "alps", "alps_foothills", "snowy_black_beach", "snowy_blue_taiga", "snowy_blue_taiga_hills", "snowy_giant_blue_taiga", "snowy_coniferous_clearing", "snowy_coniferous_forest", "snowy_coniferous_forest_hills", "snowy_deciduous_clearing", "snowy_deciduous_forest", "snowy_deciduous_forest_hills", "snowy_evergreen_clearing", "snowy_evergreen_hills", "snowy_evergreen_taiga", "snowy_maple_forest", "snowy_rocky_black_beach"));
    public static final BiomeType COLD = BiomeDictionary.register(BiomeType.create("cold").parents(SPRUCE_FOREST, LARGE_SPRUCE_FOREST, CONIFEROUS_FOREST).biomes(Biomes.field_76770_e, Biomes.field_185443_S, Biomes.field_150580_W, Biomes.field_185434_af, Biomes.field_150576_N).biomes("biomesoplenty", "tundra", "tundra_bog", "tundra_basin").biomes("byg", "cold_swamplands", "lush_tundra", "rocky_beach"));
    public static final BiomeType NEUTRAL_TEMP = BiomeDictionary.register(BiomeType.create("neutral_temp").parents(PLAINS, OAK_FOREST, BIRCH_FOREST, DARK_FOREST).biomes(Biomes.field_185444_T));
    public static final BiomeType WARM = BiomeDictionary.register(BiomeType.create("warm").parents(SWAMP, MANGROVE, JUNGLE, MUSHROOM, TROPICAL));
    public static final BiomeType HOT = BiomeDictionary.register(BiomeType.create("hot").parents(DESERT, BADLANDS, SAVANNA, MOUNTAIN_SAVANNA, VOLCANIC));
    public static final BiomeType FIERY = BiomeDictionary.register(BiomeType.create("fiery").biomes(Biomes.field_235254_j_, Biomes.field_235252_ay_, Biomes.field_235251_aB_).biomes("byg", "embur_bog"));
    public static final BiomeType HUMID = BiomeDictionary.register(BiomeType.create("humid").parents(SWAMP, JUNGLE, TROPICAL));
    public static final BiomeType DRY = BiomeDictionary.register(BiomeType.create("dry").parents(DESERT, BADLANDS, SAVANNA, MOUNTAIN_SAVANNA, DEAD).biomes("biomesoplenty", "dryland"));
    public static final BiomeType VOID = BiomeDictionary.register(BiomeType.create("void").biomes(Biomes.field_185440_P));
    public static final BiomeType MAGICAL = BiomeDictionary.register(BiomeType.create("magical").biomes("biomesoplenty", "mystic_grove", "mystic_plains", "rainbow_hills").biomes("byg", "enchanted_forest", "enchanted_forest_hills", "enchanted_grove", "flowering_enchanted_grove"));
    public static final BiomeType SPOOKY = BiomeDictionary.register(BiomeType.create("spooky").parents(DARK_FOREST).biomes("biomesoplenty", "ominous_woods", "ominous_mire", "pumpkin_patch", "silkglade_nest", "visceral_heap", "withered_abyss", "dryland").biomes("byg", "pumpkin_forest", "weeping_witch_forest", "weeping_witch_clearing"));
    public static final BiomeType RARE = BiomeDictionary.register(BiomeType.create("rare").biomes(Biomes.field_150574_L, Biomes.field_76788_q, Biomes.field_76789_p, Biomes.field_185445_W).biomes("biomesoplenty", "mystic_grove", "origin_valley", "rainbow_hills").biomes("byg", "rainbow_beach", "tropical_island"));
    public static final BiomeType SPACE = BiomeDictionary.register(BiomeType.create("space").biomes("glacidus", "glacidus"));
    public static final BiomeType PUMPKIN = BiomeDictionary.register(BiomeType.create("pumpkin").biomes("biomesoplenty", "pumpkin_patch", "seasonal_pumpkin_patch").biomes("byg", "pumpkin_forest", "autumnal_valley", "cika_wooded", "cika_mountains"));
    public static final BiomeType OVERGROWN_NETHER = BiomeDictionary.register(BiomeType.create("overgrown_nether").biomes("biomesoplenty", "undergrowth"));
    public static final BiomeType WARPED = BiomeDictionary.register(BiomeType.create("warped").biomes(Biomes.field_235250_aA_).biomes("byg", "warped_desert"));
    public static final BiomeType CRIMSON = BiomeDictionary.register(BiomeType.create("crimson").biomes(Biomes.field_235253_az_));
    public static final BiomeType NETHER_FOREST = BiomeDictionary.register(BiomeType.create("nether_forest").biomes(Biomes.field_235253_az_, Biomes.field_235250_aA_).biomes("nethercraft", "glowing_grove"));
    public static final BiomeType NETHER_FUNGAL = BiomeDictionary.register(BiomeType.create("nether_fungal").biomes(Biomes.field_235253_az_, Biomes.field_235250_aA_).biomes("nethercraft", "glowshroom_garden").biomes("byg", "glowstone_gardens"));
    public static final BiomeType NETHER_SANDY = BiomeDictionary.register(BiomeType.create("nether_sandy").biomes(Biomes.field_235252_ay_).biomes("nethercraft", "volcanic_rushes").biomes("byg", "warped_desert"));
    public static final BiomeType NETHER_EXTREME = BiomeDictionary.register(BiomeType.create("nether_extreme").biomes(Biomes.field_235251_aB_));
    public static final BiomeType NETHER_FLESHY = BiomeDictionary.register(BiomeType.create("nether_fleshy").biomes("biomesoplenty", "visceral_heap"));
    public static final BiomeType OUTER_END_ISLAND = BiomeDictionary.register(BiomeType.create("outer_end_island").biomes(Biomes.field_201938_R, Biomes.field_201937_Q).biomes("endergetic", "poise_forest", "chorus_plains", "end_midlands", "end_highlands").biomes("byg", "ivis_fields"));
    public static final BiomeType OUTER_END = BiomeDictionary.register(BiomeType.create("outer_end").parents(OUTER_END_ISLAND).biomes(Biomes.field_201939_S, Biomes.field_201936_P));
    public static final BiomeType NETHER = BiomeDictionary.register(BiomeType.create("nether").parents(WARPED, CRIMSON, NETHER_FOREST, OVERGROWN_NETHER, NETHER_FUNGAL, NETHER_SANDY, NETHER_EXTREME, NETHER_FLESHY).biomes(Biomes.field_235254_j_).biomes("biomesoplenty", "crystalline_chasm", "withered_abyss").biomes("byg", "embur_bog", "sythian_torrids"));
    public static final BiomeType END = BiomeDictionary.register(BiomeType.create("end").parents(OUTER_END).biomes(Biomes.field_76779_k));
    public static final BiomeType AETHER = BiomeDictionary.register(BiomeType.create("aether").biomes("aether", "aether_skylands"));
    public static final BiomeType OVERWORLD = BiomeDictionary.register(BiomeType.create("overworld").setBiomes(BiomeDictionary.getOverworldBiomes()));
    public static final BiomeType SKYLANDS = BiomeDictionary.register(BiomeType.create("skylands").biomes("rediscovered", "skylands"));
    public static final BiomeType MOOLANDS = BiomeDictionary.register(BiomeType.create("moolands").biomes("moolands", "awkward_heights"));
    public static final BiomeType PAGAMOS = BiomeDictionary.register(BiomeType.create("pagamos").biomes("pagamos", "frozen_hell"));
    public static final BiomeType GLACIDUS = BiomeDictionary.register(BiomeType.create("glacidus").biomes("glacidus", "glacidus"));
    public static final BiomeType GOOD_DREAM = BiomeDictionary.register(BiomeType.create("good_dream"));
    public static final BiomeType NIGHTMARE = BiomeDictionary.register(BiomeType.create("nightmare"));
    public static final ForgeType FORGE_HOT = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.HOT));
    public static final ForgeType FORGE_COLD = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.COLD));
    public static final ForgeType FORGE_SPARSE = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.SPARSE));
    public static final ForgeType FORGE_DENSE = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.DENSE));
    public static final ForgeType FORGE_WET = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.WET));
    public static final ForgeType FORGE_DRY = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.DRY));
    public static final ForgeType FORGE_SAVANNA = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.SAVANNA));
    public static final ForgeType FORGE_CONIFEROUS = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.CONIFEROUS));
    public static final ForgeType FORGE_JUNGLE = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.JUNGLE));
    public static final ForgeType FORGE_SPOOKY = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.SPOOKY));
    public static final ForgeType FORGE_DEAD = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.DEAD));
    public static final ForgeType FORGE_LUSH = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.LUSH));
    public static final ForgeType FORGE_MUSHROOM = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.MUSHROOM));
    public static final ForgeType FORGE_MAGICAL = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.MAGICAL));
    public static final ForgeType FORGE_RARE = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.RARE));
    public static final ForgeType FORGE_PLATEAU = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.PLATEAU));
    public static final ForgeType FORGE_MODIFIED = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.MODIFIED));
    public static final ForgeType FORGE_OCEAN = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.OCEAN));
    public static final ForgeType FORGE_RIVER = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.RIVER));
    public static final ForgeType FORGE_WATER = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.WATER));
    public static final ForgeType FORGE_MESA = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.MESA));
    public static final ForgeType FORGE_FOREST = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.FOREST));
    public static final ForgeType FORGE_PLAINS = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.PLAINS));
    public static final ForgeType FORGE_MOUNTAIN = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.MOUNTAIN));
    public static final ForgeType FORGE_HILLS = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.HILLS));
    public static final ForgeType FORGE_SWAMP = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.SWAMP));
    public static final ForgeType FORGE_SANDY = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.SANDY));
    public static final ForgeType FORGE_SNOWY = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.SNOWY));
    public static final ForgeType FORGE_WASTELAND = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.WASTELAND));
    public static final ForgeType FORGE_BEACH = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.BEACH));
    public static final ForgeType FORGE_VOID = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.VOID));
    public static final ForgeType FORGE_OVERWORLD = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.OVERWORLD));
    public static final ForgeType FORGE_NETHER = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.NETHER));
    public static final ForgeType FORGE_END = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.END));

    public static void init() {
        if (!REGISTRY.containsKey(EMPTY_NAME)) {
            REGISTRY.register((IForgeRegistryEntry)EMPTY);
        }
    }

    public static <T extends BiomeType> T register(T biomeType) {
        ResourceLocation key = biomeType.getRegistryName();
        if (biomeType.getRegistryName().equals((Object)EMPTY_NAME)) {
            StructureGelMod.LOGGER.warn(String.format("Registry failed: Attempted to register a biome dictionary entry under the name \"%s\" and that shouldn't be done.", EMPTY_NAME.toString()));
            return biomeType;
        }
        if (REGISTRY.containsKey(key)) {
            ((BiomeType)REGISTRY.getValue(key)).addBiomes(biomeType.getBiomes()).addParents(biomeType.getParents());
        } else {
            REGISTRY.register(biomeType);
        }
        if (!BIOME_TO_BIOMETYPE_CACHE.isEmpty()) {
            BIOME_TO_BIOMETYPE_CACHE.clear();
        }
        return biomeType;
    }

    @Internal
    private static ForgeType register(ForgeType forgeType) {
        REGISTRY.register((IForgeRegistryEntry)forgeType);
        return forgeType;
    }

    public static void registerAll(BiomeType ... biomeTypes) {
        for (BiomeType type : biomeTypes) {
            BiomeDictionary.register(type);
        }
    }

    public static Set<ResourceLocation> getOverworldBiomes() {
        HashSet<ResourceLocation> biomes = new HashSet<ResourceLocation>();
        ForgeRegistries.BIOMES.getValues().stream().filter(b -> ImmutableList.of((Object)"minecraft", (Object)bop, (Object)byg).contains((Object)b.getRegistryName().func_110624_b()) && !NETHER.contains((Biome)b) && !END.contains((Biome)b)).forEach(b -> {
            if (b.getRegistryName() != null) {
                biomes.add(b.getRegistryName());
            } else if (BiomeDictionary.getBiomeKey(b) != null) {
                biomes.add(BiomeDictionary.getBiomeKey(b).func_240901_a_());
            }
        });
        return biomes;
    }

    @Internal
    public static Map<ResourceLocation, Set<BiomeType>> makeGuess() {
        HashMap<ResourceLocation, Set<BiomeType>> newlyRegistered = new HashMap<ResourceLocation, Set<BiomeType>>();
        HashMap<Biome.Category, Function<Biome, BiomeType>> categoryToType = new HashMap<Biome.Category, Function<Biome, BiomeType>>();
        categoryToType.put(Biome.Category.TAIGA, b -> b.func_201851_b() == Biome.RainType.SNOW ? SNOWY_SPRUCE_FOREST : SPRUCE_FOREST);
        categoryToType.put(Biome.Category.EXTREME_HILLS, b -> b.func_201851_b() == Biome.RainType.SNOW ? SNOWY_MOUNTAIN : MOUNTAIN);
        categoryToType.put(Biome.Category.JUNGLE, b -> JUNGLE);
        categoryToType.put(Biome.Category.MESA, b -> BADLANDS);
        categoryToType.put(Biome.Category.PLAINS, b -> b.func_201851_b() == Biome.RainType.SNOW ? SNOWY_PLAINS : PLAINS);
        categoryToType.put(Biome.Category.SAVANNA, b -> SAVANNA);
        categoryToType.put(Biome.Category.ICY, b -> SNOWY);
        categoryToType.put(Biome.Category.THEEND, b -> END);
        categoryToType.put(Biome.Category.BEACH, b -> BEACH);
        categoryToType.put(Biome.Category.FOREST, b -> WOODED);
        categoryToType.put(Biome.Category.OCEAN, b -> b.func_201851_b() == Biome.RainType.SNOW ? FROZEN_OCEAN : OCEAN);
        categoryToType.put(Biome.Category.DESERT, b -> DESERT);
        categoryToType.put(Biome.Category.RIVER, b -> RIVER);
        categoryToType.put(Biome.Category.SWAMP, b -> SWAMP);
        categoryToType.put(Biome.Category.MUSHROOM, b -> MUSHROOM);
        categoryToType.put(Biome.Category.NETHER, b -> NETHER);
        HashMap<BiomeDictionary.Type, Function<Biome, BiomeType>> forgeToType = new HashMap<BiomeDictionary.Type, Function<Biome, BiomeType>>();
        forgeToType.put(BiomeDictionary.Type.OVERWORLD, b -> OVERWORLD);
        forgeToType.put(BiomeDictionary.Type.NETHER, b -> NETHER);
        forgeToType.put(BiomeDictionary.Type.END, b -> END);
        forgeToType.put(BiomeDictionary.Type.BEACH, b -> BEACH);
        forgeToType.put(BiomeDictionary.Type.CONIFEROUS, b -> CONIFEROUS_FOREST);
        forgeToType.put(BiomeDictionary.Type.DEAD, b -> DEAD);
        forgeToType.put(BiomeDictionary.Type.DRY, b -> DRY);
        forgeToType.put(BiomeDictionary.Type.FOREST, b -> WOODED);
        forgeToType.put(BiomeDictionary.Type.HOT, b -> HOT);
        forgeToType.put(BiomeDictionary.Type.JUNGLE, b -> JUNGLE);
        forgeToType.put(BiomeDictionary.Type.MAGICAL, b -> MAGICAL);
        forgeToType.put(BiomeDictionary.Type.MESA, b -> BADLANDS);
        forgeToType.put(BiomeDictionary.Type.MOUNTAIN, b -> b.func_201851_b() == Biome.RainType.SNOW ? SNOWY_MOUNTAIN : MOUNTAIN);
        forgeToType.put(BiomeDictionary.Type.MUSHROOM, b -> MUSHROOM);
        forgeToType.put(BiomeDictionary.Type.OCEAN, b -> b.func_201851_b() == Biome.RainType.SNOW ? FROZEN_OCEAN : OCEAN);
        forgeToType.put(BiomeDictionary.Type.PLAINS, b -> b.func_201851_b() == Biome.RainType.SNOW ? SNOWY_PLAINS : PLAINS);
        forgeToType.put(BiomeDictionary.Type.RARE, b -> RARE);
        forgeToType.put(BiomeDictionary.Type.RIVER, b -> RIVER);
        forgeToType.put(BiomeDictionary.Type.SANDY, b -> SANDY);
        forgeToType.put(BiomeDictionary.Type.SAVANNA, b -> SAVANNA);
        forgeToType.put(BiomeDictionary.Type.SNOWY, b -> SNOWY);
        forgeToType.put(BiomeDictionary.Type.SPOOKY, b -> SPOOKY);
        forgeToType.put(BiomeDictionary.Type.SWAMP, b -> SWAMP);
        forgeToType.put(BiomeDictionary.Type.VOID, b -> VOID);
        forgeToType.put(BiomeDictionary.Type.WASTELAND, b -> DEAD);
        HashMap<String, BiomeType> nameToType = new HashMap<String, BiomeType>();
        nameToType.put("frozen", FROZEN);
        nameToType.put("snowy", SNOWY);
        nameToType.put("redwood", REDWOOD_FOREST);
        nameToType.put("coniferous", CONIFEROUS_FOREST);
        nameToType.put("bamboo", BAMBOO);
        nameToType.put("flower", FLOWERY);
        nameToType.put("tulip", FLOWERY);
        nameToType.put("orchid", FLOWERY);
        nameToType.put("dandelion", FLOWERY);
        nameToType.put("allium", FLOWERY);
        nameToType.put("poppy", FLOWERY);
        nameToType.put("daisy", FLOWERY);
        nameToType.put("lilac", FLOWERY);
        nameToType.put("peony", FLOWERY);
        nameToType.put("lavender", FLOWERY);
        nameToType.put("ocean", OCEAN);
        nameToType.put("river", RIVER);
        nameToType.put("beach", BEACH);
        nameToType.put("shroom", MUSHROOM);
        nameToType.put("fungal", FUNGAL);
        nameToType.put("seasonal", AUTUMN_FOREST);
        nameToType.put("autumn", AUTUMN_FOREST);
        nameToType.put("tropic", TROPICAL);
        List<String> ignoredMods = StructureGelConfig.COMMON.getIgnoredMods();
        ForgeRegistries.BIOMES.getValues().stream().filter(biome -> !ignoredMods.contains(biome.getRegistryName().func_110624_b()) && !BiomeDictionary.getAllTypes(biome).stream().filter(BiomeDictionary::filterTypeForAutoRegister).findAny().isPresent()).forEach(biome -> {
            float t;
            if (categoryToType.containsKey(biome.func_201856_r())) {
                ((BiomeType)((Function)categoryToType.get(biome.func_201856_r())).apply(biome)).addBiome((Biome)biome);
            }
            if ((t = biome.func_242445_k()) <= 0.05f) {
                SNOWY.addBiome((Biome)biome);
            } else if (t <= 0.25f) {
                COLD.addBiome((Biome)biome);
            } else if (t <= 1.0f) {
                NEUTRAL_TEMP.addBiome((Biome)biome);
            } else if (t <= 1.5f) {
                WARM.addBiome((Biome)biome);
            } else {
                HOT.addBiome((Biome)biome);
            }
            if (biome.func_76736_e()) {
                HUMID.addBiome((Biome)biome);
            }
            switch (biome.func_201851_b()) {
                case NONE: {
                    if (!(biome.func_185355_j() > 0.0f)) break;
                    DRY.addBiome((Biome)biome);
                    break;
                }
                case SNOW: {
                    SNOWY.addBiome((Biome)biome);
                    break;
                }
            }
            if (biome.getRegistryName() != null) {
                net.minecraftforge.common.BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName())).forEach(type -> {
                    if (forgeToType.containsKey(type)) {
                        ((BiomeType)((Function)forgeToType.get(type)).apply(biome)).addBiome((Biome)biome);
                    }
                });
                String name = biome.getRegistryName().func_110623_a();
                nameToType.forEach((string, type) -> {
                    if (name.contains((CharSequence)string)) {
                        type.addBiome((Biome)biome);
                    }
                });
            }
            if (biome.func_242440_e().func_242502_e().func_204108_a().func_185904_a() == Material.field_151595_p) {
                SANDY.addBiome((Biome)biome);
            }
            if (biome.func_242440_e().func_242502_e().func_204108_a().func_185904_a() == Material.field_151578_c) {
                DIRTY.addBiome((Biome)biome);
            }
            if (biome.func_242440_e().func_242502_e().func_204108_a().func_177230_c() instanceof GravelBlock) {
                GRAVELLY.addBiome((Biome)biome);
            }
            BIOME_TO_BIOMETYPE_CACHE.clear();
            newlyRegistered.put(biome.getRegistryName(), BiomeDictionary.getAllTypes(biome));
        });
        BIOME_TO_BIOMETYPE_CACHE.clear();
        return newlyRegistered;
    }

    @Internal
    public static boolean filterTypeForAutoRegister(BiomeType type) {
        return !(type instanceof ForgeType) && type != OVERWORLD;
    }

    public static RegistryKey<Biome> getBiomeKey(Biome biome) {
        return RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)biome.getRegistryName());
    }

    public static Set<BiomeType> getAllTypes(RegistryKey<Biome> biome) {
        return BiomeDictionary.getAllTypes(biome.func_240901_a_());
    }

    public static Set<BiomeType> getAllTypes(Biome biome) {
        return BiomeDictionary.getAllTypes(biome.getRegistryName());
    }

    public static Set<BiomeType> getAllTypes(ResourceLocation biome) {
        if (BIOME_TO_BIOMETYPE_CACHE.containsKey(biome)) {
            return BIOME_TO_BIOMETYPE_CACHE.get(biome);
        }
        HashSet<BiomeType> types = new HashSet<BiomeType>();
        REGISTRY.forEach((T type) -> {
            if (type.getAllBiomes().stream().map(RegistryKey::func_240901_a_).anyMatch(arg_0 -> ((ResourceLocation)biome).equals(arg_0))) {
                types.add((BiomeType)type);
            }
        });
        BIOME_TO_BIOMETYPE_CACHE.put(biome, types);
        return types;
    }

    public static boolean contains(ResourceLocation name) {
        return REGISTRY.containsKey(name);
    }

    public static BiomeType get(ResourceLocation name) {
        return (BiomeType)REGISTRY.getValue(name);
    }

    public static void forEach(Consumer<BiomeType> action) {
        REGISTRY.forEach(action);
    }
}

