/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin;

import com.legacy.structure_gel.SGCrashHandler;
import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.events.RegisterDimensionEvent;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin {
    private static final String REGISTER_DIMENSION_FAILED_MESSAGE = "Huh. Well this is awkward. Looks like you crashed while using custom server software. Some of the stuff that we need doesn't exist because they changed stuff in the code. If you could report it to them, that would be nice. Send them to our repo so they can look at this class and see where we get the values from.";

    @Inject(at={@At(value="HEAD")}, method={"loadLevel()V"})
    private void initServer(CallbackInfo callback) {
        try {
            MinecraftForge.EVENT_BUS.post((Event)new RegisterDimensionEvent((SimpleRegistry<Dimension>)this.func_240793_aU_().func_230418_z_().func_236224_e_(), (Registry<DimensionType>)this.func_244267_aX().func_243612_b(Registry.field_239698_ad_), (Registry<Biome>)this.func_244267_aX().func_243612_b(Registry.field_239720_u_), (Registry<DimensionSettings>)this.func_244267_aX().func_243612_b(Registry.field_243549_ar), this.func_240793_aU_().func_230418_z_().func_236221_b_()));
        }
        catch (Throwable r) {
            StructureGelMod.LOGGER.fatal(REGISTER_DIMENSION_FAILED_MESSAGE);
            ArrayList<String> nullItems = new ArrayList<String>();
            if (this.func_240793_aU_() == null) {
                StructureGelMod.LOGGER.fatal("The server's configuration is null!");
                nullItems.add("configuration");
            } else if (this.func_240793_aU_().func_230418_z_() == null) {
                StructureGelMod.LOGGER.fatal("The server's dimension generator settings is null!");
                nullItems.add("dimension generator");
            } else {
                if (this.func_240793_aU_().func_230418_z_().func_236224_e_() == null) {
                    StructureGelMod.LOGGER.fatal("The dimension registry is null!");
                    nullItems.add("dimension registry");
                }
                if (this.func_240793_aU_().func_230418_z_().func_236221_b_() == ((Long)null).longValue()) {
                    StructureGelMod.LOGGER.fatal("The dimension generator settings seed is... null. But how though?");
                    nullItems.add("dimension generator settings seed");
                }
            }
            if (this.func_244267_aX() == null) {
                StructureGelMod.LOGGER.fatal("The server's DynamicRegistries is null!");
                nullItems.add("DynamicRegistries");
            } else {
                if (this.func_244267_aX().func_243612_b(Registry.field_239698_ad_) == null) {
                    StructureGelMod.LOGGER.fatal("The dimension type registry is null!");
                    nullItems.add("dimension type registry");
                }
                if (this.func_244267_aX().func_243612_b(Registry.field_239720_u_) == null) {
                    StructureGelMod.LOGGER.fatal("The biome key registry is null!");
                    nullItems.add("biome key registry");
                }
                if (this.func_244267_aX().func_243612_b(Registry.field_243549_ar) == null) {
                    StructureGelMod.LOGGER.fatal("The noise settings registry is null!");
                    nullItems.add("noise settings registry");
                }
            }
            StructureGelMod.LOGGER.fatal("That should be everything. Anyway, have a good day :)");
            StructureGelMod.LOGGER.fatal((Object)r);
            MinecraftServerMixin.prepareCrashReport(nullItems);
            throw r;
        }
    }

    @Shadow
    public IServerConfiguration func_240793_aU_() {
        throw new IllegalStateException("Mixin failed to shadow getServerConfiguration()");
    }

    @Shadow
    public DynamicRegistries func_244267_aX() {
        throw new IllegalStateException("Mixin failed to shadow registryAccess()");
    }

    private static void prepareCrashReport(ArrayList<String> nullItems) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(REGISTER_DIMENSION_FAILED_MESSAGE);
        stringBuilder.append("\n");
        stringBuilder.append("Reason: ");
        if (nullItems.size() > 0) {
            stringBuilder.append("The server's ");
            for (int i = 0; i < nullItems.size(); ++i) {
                if (i == nullItems.size() - 1) {
                    stringBuilder.append(String.format("%s%s", nullItems.size() == 1 ? "" : "and ", nullItems.get(i)));
                    continue;
                }
                stringBuilder.append(String.format("%s%s ", nullItems.get(i), nullItems.size() == 2 ? "" : ","));
            }
            stringBuilder.append(String.format(" %s null.\n", nullItems.size() > 1 ? "were" : "was"));
        } else {
            stringBuilder.append("Well, we're not really sure why this crash happened, but make sure nothing in your custom server software is null when it shouldn't be. If all else fails, you can talk to us on the Modding Legacy Discord server. This crash might be an interesting rabbit hole to traverse.\n");
        }
        stringBuilder.append("Anyway, here's the rest of the crash report. Have a good day :)");
        SGCrashHandler.prepareAdditionalCrashInfo(stringBuilder.toString());
    }
}

