/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.registrars;

import com.google.common.collect.ImmutableMap;
import com.legacy.structure_gel.registrars.IForgeRegistrar;
import com.legacy.structure_gel.util.GelCollectors;
import com.legacy.structure_gel.util.RegistryHelper;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.registries.IForgeRegistry;

public class StructureRegistrar2<C extends IFeatureConfig, S extends Structure<C>>
implements IForgeRegistrar<StructureRegistrar2<C, S>, Structure<?>> {
    private final ResourceLocation name;
    private final S structure;
    private final Map<String, IStructurePieceType> pieceTypes;
    private final Map<String, StructureFeature<C, S>> structureFeatures;
    private final GenerationStage.Decoration generationStage;
    private final Supplier<StructureSeparationSettings> separationSettings;

    public StructureRegistrar2(ResourceLocation name, S structure, IStructurePieceType pieceType, C config, GenerationStage.Decoration generationStage, Supplier<StructureSeparationSettings> separationSettings) {
        this(name, structure, (Map<String, IStructurePieceType>)ImmutableMap.of((Object)"", (Object)pieceType), (Map<String, C>)ImmutableMap.of((Object)"", config), generationStage, separationSettings);
    }

    public StructureRegistrar2(ResourceLocation name, S structure, IStructurePieceType pieceType, Map<String, C> configs, GenerationStage.Decoration generationStage, Supplier<StructureSeparationSettings> separationSettings) {
        this(name, structure, (Map<String, IStructurePieceType>)ImmutableMap.of((Object)"", (Object)pieceType), configs, generationStage, separationSettings);
    }

    public StructureRegistrar2(ResourceLocation name, S structure, Map<String, IStructurePieceType> pieceTypes, C config, GenerationStage.Decoration generationStage, Supplier<StructureSeparationSettings> separationSettings) {
        this(name, structure, pieceTypes, (Map<String, C>)ImmutableMap.of((Object)"", config), generationStage, separationSettings);
    }

    public StructureRegistrar2(ResourceLocation name, S structure, Map<String, IStructurePieceType> pieceTypes, Map<String, C> configs, GenerationStage.Decoration generationStage, Supplier<StructureSeparationSettings> separationSettings) {
        this.name = name;
        this.structure = structure;
        this.pieceTypes = pieceTypes;
        this.structureFeatures = configs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> structure.func_236391_a_((IFeatureConfig)v.getValue())));
        this.generationStage = generationStage;
        this.separationSettings = separationSettings;
    }

    public static <C extends IFeatureConfig, S extends Structure<C>> StructureRegistrar2<C, S> of(ResourceLocation name, S structure, IStructurePieceType pieceType, Map<String, C> configs, GenerationStage.Decoration generationStage, Supplier<StructureSeparationSettings> separationSettings) {
        return new StructureRegistrar2<C, S>(name, structure, pieceType, configs, generationStage, separationSettings);
    }

    public static <C extends IFeatureConfig, S extends Structure<C>> StructureRegistrar2<C, S> of(ResourceLocation name, S structure, IStructurePieceType pieceType, C config, GenerationStage.Decoration generationStage, Supplier<StructureSeparationSettings> separationSettings) {
        return new StructureRegistrar2<C, S>(name, structure, pieceType, config, generationStage, separationSettings);
    }

    public static <C extends IFeatureConfig, S extends Structure<C>> StructureRegistrar2<C, S> of(ResourceLocation name, S structure, Map<String, IStructurePieceType> pieceTypes, Map<String, C> configs, GenerationStage.Decoration generationStage, Supplier<StructureSeparationSettings> separationSettings) {
        return new StructureRegistrar2<C, S>(name, structure, pieceTypes, configs, generationStage, separationSettings);
    }

    public static <C extends IFeatureConfig, S extends Structure<C>> StructureRegistrar2<C, S> of(ResourceLocation name, S structure, Map<String, IStructurePieceType> pieceTypes, C config, GenerationStage.Decoration generationStage, Supplier<StructureSeparationSettings> separationSettings) {
        return new StructureRegistrar2<C, S>(name, structure, pieceTypes, config, generationStage, separationSettings);
    }

    public S getStructure() {
        return this.structure;
    }

    public Map<String, IStructurePieceType> getPieceTypes() {
        return this.pieceTypes;
    }

    @Nullable
    public IStructurePieceType getPieceType(String name) {
        return this.pieceTypes.get(name);
    }

    public IStructurePieceType getPieceType() {
        if (this.pieceTypes.size() > 0) {
            return this.pieceTypes.get(this.pieceTypes.keySet().toArray()[0]);
        }
        return null;
    }

    public Map<String, StructureFeature<C, S>> getStructureFeatures() {
        return this.structureFeatures;
    }

    @Nullable
    public StructureFeature<C, S> getStructureFeature(String name) {
        return this.structureFeatures.get(name);
    }

    @Nullable
    public StructureFeature<C, S> getStructureFeature() {
        if (this.structureFeatures.size() > 0) {
            return this.structureFeatures.get(this.structureFeatures.keySet().toArray()[0]);
        }
        return null;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public GenerationStage.Decoration getGenerationStage() {
        return this.generationStage;
    }

    public StructureSeparationSettings getSeparationSettings() {
        return this.separationSettings.get();
    }

    @Override
    public StructureRegistrar2<C, S> handle() {
        this.pieceTypes.forEach((name, pieceType) -> RegistryHelper.registerStructurePiece(name.isEmpty() ? this.name : new ResourceLocation(this.name.func_110624_b(), this.name.func_110623_a() + "_" + name), pieceType));
        this.structureFeatures.forEach((name, feature) -> RegistryHelper.registerStructureFeature(name.isEmpty() ? this.name : new ResourceLocation(this.name.func_110624_b(), this.name.func_110623_a() + "_" + name), feature));
        return this;
    }

    @Override
    public StructureRegistrar2<C, S> handleForge(IForgeRegistry<Structure<?>> registry) {
        if (this.getStructure().getRegistryName() == null) {
            this.getStructure().setRegistryName(this.getRegistryName());
        }
        registry.register(this.getStructure());
        Structure.field_236365_a_.put((Object)this.getRegistryName().toString(), this.getStructure());
        Structure.field_236385_u_.put(this.getStructure(), this.getGenerationStage());
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(this.getStructure(), (Object)this.getSeparationSettings()).build();
        FlatGenerationSettings.field_202247_j = GelCollectors.addToMap(FlatGenerationSettings.field_202247_j, this.getStructure(), this.getStructureFeature());
        RegistryHelper.STRUCTURE_SETTINGS_MAP.put((Structure<?>)this.getStructure(), this.getSeparationSettings());
        return this;
    }
}

