/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials;

import dev.ftb.mods.ftbessentials.FTBEssentials;
import dev.ftb.mods.ftbessentials.FTBRanksIntegration;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class FTBEConfig {
    public static int maxBack;
    public static int maxHomes;
    public static long backCooldown;
    public static long spawnCooldown;
    public static long warpCooldown;
    public static long homeCooldown;
    public static long tpaCooldown;
    public static long rtpCooldown;
    public static int rtpMaxTries;
    public static double rtpMinDistance;
    public static double rtpMaxDistance;
    private static Pair<ServerConfig, ForgeConfigSpec> server;

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().register(FTBEConfig.class);
        server = new ForgeConfigSpec.Builder().configure(x$0 -> new ServerConfig((ForgeConfigSpec.Builder)x$0));
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (ForgeConfigSpec)server.getRight());
    }

    @SubscribeEvent
    public static void reload(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == server.getRight()) {
            ServerConfig c = (ServerConfig)server.getLeft();
            maxBack = (Integer)c.maxBack.get();
            maxHomes = (Integer)c.maxHomes.get();
            backCooldown = (Long)c.backCooldown.get();
            spawnCooldown = (Long)c.spawnCooldown.get();
            warpCooldown = (Long)c.warpCooldown.get();
            homeCooldown = (Long)c.homeCooldown.get();
            tpaCooldown = (Long)c.tpaCooldown.get();
            rtpCooldown = (Long)c.rtpCooldown.get();
            rtpMaxTries = (Integer)c.rtpMaxTries.get();
            rtpMinDistance = (Double)c.rtpMinDistance.get();
            rtpMaxDistance = (Double)c.rtpMaxDistance.get();
        }
    }

    public static int getMaxBack(ServerPlayerEntity player) {
        if (FTBEssentials.ranksMod) {
            return FTBRanksIntegration.getMaxBack(player, maxBack);
        }
        return maxBack;
    }

    public static long getMaxHomes(ServerPlayerEntity player) {
        if (FTBEssentials.ranksMod) {
            return FTBRanksIntegration.getMaxHomes(player, maxHomes);
        }
        return maxHomes;
    }

    public static long getBackCooldown(ServerPlayerEntity player) {
        if (FTBEssentials.ranksMod) {
            return FTBRanksIntegration.getBackCooldown(player, backCooldown);
        }
        return backCooldown;
    }

    public static long getSpawnCooldown(ServerPlayerEntity player) {
        if (FTBEssentials.ranksMod) {
            return FTBRanksIntegration.getSpawnCooldown(player, spawnCooldown);
        }
        return spawnCooldown;
    }

    public static long getWarpCooldown(ServerPlayerEntity player) {
        if (FTBEssentials.ranksMod) {
            return FTBRanksIntegration.getWarpCooldown(player, warpCooldown);
        }
        return warpCooldown;
    }

    public static long getHomeCooldown(ServerPlayerEntity player) {
        if (FTBEssentials.ranksMod) {
            return FTBRanksIntegration.getHomeCooldown(player, homeCooldown);
        }
        return homeCooldown;
    }

    public static long getTpaCooldown(ServerPlayerEntity player) {
        if (FTBEssentials.ranksMod) {
            return FTBRanksIntegration.getTpaCooldown(player, tpaCooldown);
        }
        return tpaCooldown;
    }

    public static long getRtpCooldown(ServerPlayerEntity player) {
        if (FTBEssentials.ranksMod) {
            return FTBRanksIntegration.getRtpCooldown(player, rtpCooldown);
        }
        return rtpCooldown;
    }

    private static class ServerConfig {
        private final ForgeConfigSpec.IntValue maxBack;
        private final ForgeConfigSpec.IntValue maxHomes;
        private final ForgeConfigSpec.LongValue backCooldown;
        private final ForgeConfigSpec.LongValue spawnCooldown;
        private final ForgeConfigSpec.LongValue warpCooldown;
        private final ForgeConfigSpec.LongValue homeCooldown;
        private final ForgeConfigSpec.LongValue tpaCooldown;
        private final ForgeConfigSpec.LongValue rtpCooldown;
        private final ForgeConfigSpec.IntValue rtpMaxTries;
        private final ForgeConfigSpec.DoubleValue rtpMinDistance;
        private final ForgeConfigSpec.DoubleValue rtpMaxDistance;

        private ServerConfig(ForgeConfigSpec.Builder builder) {
            this.maxBack = builder.comment("Max number of times you can use /back").defineInRange("maxBack", 10, 0, Integer.MAX_VALUE);
            this.maxHomes = builder.comment("Max homes").defineInRange("maxHomes", 1, 0, Integer.MAX_VALUE);
            this.backCooldown = builder.comment("/back cooldown in seconds").defineInRange("backCooldown", 30L, 0L, 604800L);
            this.spawnCooldown = builder.comment("/spawn cooldown in seconds").defineInRange("spawnCooldown", 10L, 0L, 604800L);
            this.warpCooldown = builder.comment("/warp cooldown in seconds").defineInRange("warpCooldown", 10L, 0L, 604800L);
            this.homeCooldown = builder.comment("/home cooldown in seconds").defineInRange("homeCooldown", 10L, 0L, 604800L);
            this.tpaCooldown = builder.comment("/tpa cooldown in seconds").defineInRange("tpaCooldown", 10L, 0L, 604800L);
            this.rtpCooldown = builder.comment("/rtp cooldown in seconds").defineInRange("rtpCooldown", 600L, 0L, 604800L);
            this.rtpMaxTries = builder.comment("Number of tries before /rtp gives up").defineInRange("rtpMaxTries", 100, 1, 1000);
            this.rtpMinDistance = builder.comment("/rtp min distance from spawn point").defineInRange("rtpMinDistance", 1000.0, 0.0, 3.0E7);
            this.rtpMaxDistance = builder.comment("/rtp max distance from spawn point").defineInRange("rtpMaxDistance", 100000.0, 0.0, 3.0E7);
        }
    }
}

