/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.Leaderboard;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.apache.commons.lang3.tuple.Pair;

public class MiscCommands {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"kickme").executes(context -> MiscCommands.kickme(((CommandSource)context.getSource()).func_197035_h())));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"trashcan").executes(context -> MiscCommands.trashcan(((CommandSource)context.getSource()).func_197035_h())));
        LiteralArgumentBuilder leaderboardCommand = Commands.func_197057_a((String)"leaderboard");
        for (Leaderboard<?> leaderboard : Leaderboard.MAP.values()) {
            leaderboardCommand = (LiteralArgumentBuilder)leaderboardCommand.then(Commands.func_197057_a((String)leaderboard.name).executes(context -> MiscCommands.leaderboard((CommandSource)context.getSource(), leaderboard, false)));
        }
        dispatcher.register(leaderboardCommand);
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"recording").executes(context -> MiscCommands.recording(((CommandSource)context.getSource()).func_197035_h())));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"streaming").executes(context -> MiscCommands.streaming(((CommandSource)context.getSource()).func_197035_h())));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"hat").executes(context -> MiscCommands.hat(((CommandSource)context.getSource()).func_197035_h())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"nickname").executes(context -> MiscCommands.nickname(((CommandSource)context.getSource()).func_197035_h(), ""))).then(Commands.func_197056_a((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).executes(context -> MiscCommands.nickname(((CommandSource)context.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)context, (String)"nickname")))));
    }

    public static int kickme(ServerPlayerEntity player) {
        player.field_71135_a.func_194028_b((ITextComponent)new StringTextComponent("You kicked yourself!"));
        return 1;
    }

    public static int trashcan(ServerPlayerEntity player) {
        player.func_213829_a(new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Trash Can");
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
                return ChestContainer.func_216991_d((int)id, (PlayerInventory)playerInventory);
            }
        });
        return 1;
    }

    public static <T extends Number> int leaderboard(CommandSource source, Leaderboard<T> leaderboard, boolean reverse) {
        try {
            Files.list(FTBEWorldData.instance.mkdirs("playerdata")).filter(path -> path.toString().endsWith(".json")).map(Path::getFileName).map(path -> new GameProfile(UUID.fromString(path.toString().replace(".json", "")), null)).filter(profile -> !FTBEPlayerData.MAP.containsKey(profile.getId())).map(FTBEPlayerData::get).forEach(FTBEPlayerData::load);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<Pair> list = new ArrayList<Pair>();
        int self = -1;
        for (FTBEPlayerData playerData : FTBEPlayerData.MAP.values()) {
            ServerStatisticsManager stats = source.func_197028_i().func_184103_al().func_152602_a((PlayerEntity)FakePlayerFactory.get((ServerWorld)source.func_197023_e(), (GameProfile)new GameProfile(playerData.uuid, playerData.name)));
            Number num = (Number)leaderboard.valueGetter.apply(stats);
            if (!leaderboard.filter.test(num)) continue;
            list.add(Pair.of((Object)playerData, (Object)num));
        }
        if (reverse) {
            list.sort(Comparator.comparingDouble(pair -> ((Number)pair.getRight()).doubleValue()));
        } else {
            list.sort((pair1, pair2) -> Double.compare(((Number)pair2.getRight()).doubleValue(), ((Number)pair1.getRight()).doubleValue()));
        }
        if (source.func_197022_f() instanceof ServerPlayerEntity) {
            for (int i = 0; i < list.size(); ++i) {
                if (!((FTBEPlayerData)((Pair)list.get((int)i)).getLeft()).uuid.equals(source.func_197022_f().func_110124_au())) continue;
                self = list.size();
                break;
            }
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("== Leaderboard [" + leaderboard.name + "] ==").func_240699_a_(TextFormatting.DARK_GREEN), false);
        if (list.isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("No data!").func_240699_a_(TextFormatting.GRAY), false);
            return 1;
        }
        for (int i = 0; i < Math.min(20, list.size()); ++i) {
            Pair pair3 = (Pair)list.get(i);
            String num = String.valueOf(i + 1);
            if (i < 10) {
                num = "0" + num;
            }
            StringTextComponent component = new StringTextComponent("");
            component.func_240699_a_(TextFormatting.GRAY);
            if (i == 0) {
                component.func_230529_a_((ITextComponent)new StringTextComponent("#" + num + " ").func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)13938487))));
            } else if (i == 1) {
                component.func_230529_a_((ITextComponent)new StringTextComponent("#" + num + " ").func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0xC0C0C0))));
            } else if (i == 2) {
                component.func_230529_a_((ITextComponent)new StringTextComponent("#" + num + " ").func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)10451508))));
            } else {
                component.func_230529_a_((ITextComponent)new StringTextComponent("#" + num + " "));
            }
            component.func_230529_a_((ITextComponent)new StringTextComponent(((FTBEPlayerData)pair3.getLeft()).name).func_240699_a_(i == self ? TextFormatting.GREEN : TextFormatting.YELLOW));
            component.func_230529_a_((ITextComponent)new StringTextComponent(": "));
            component.func_230529_a_((ITextComponent)new StringTextComponent(leaderboard.stringGetter.apply(pair3.getRight())));
            source.func_197030_a((ITextComponent)component, false);
        }
        return 1;
    }

    public static int recording(ServerPlayerEntity player) {
        FTBEPlayerData data = FTBEPlayerData.get((PlayerEntity)player);
        data.recording = data.recording == 1 ? 0 : 1;
        data.save();
        player.refreshDisplayName();
        if (data.recording == 1) {
            player.field_71133_b.func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)player.func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.YELLOW)).func_240702_b_(" is now recording!"), ChatType.CHAT, Util.field_240973_b_);
        } else {
            player.field_71133_b.func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)player.func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.YELLOW)).func_240702_b_(" is no longer recording!"), ChatType.CHAT, Util.field_240973_b_);
        }
        data.sendTabName(player.field_71133_b);
        return 1;
    }

    public static int streaming(ServerPlayerEntity player) {
        FTBEPlayerData data = FTBEPlayerData.get((PlayerEntity)player);
        data.recording = data.recording == 2 ? 0 : 2;
        data.save();
        player.refreshDisplayName();
        if (data.recording == 2) {
            player.field_71133_b.func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)player.func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.YELLOW)).func_240702_b_(" is now streaming!"), ChatType.CHAT, Util.field_240973_b_);
        } else {
            player.field_71133_b.func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)player.func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.YELLOW)).func_240702_b_(" is no longer streaming!"), ChatType.CHAT, Util.field_240973_b_);
        }
        data.sendTabName(player.field_71133_b);
        return 1;
    }

    public static int hat(ServerPlayerEntity player) {
        ItemStack hstack = player.func_184582_a(EquipmentSlotType.HEAD);
        ItemStack istack = player.func_184582_a(EquipmentSlotType.MAINHAND);
        player.func_184201_a(EquipmentSlotType.HEAD, istack);
        player.func_184201_a(EquipmentSlotType.MAINHAND, hstack);
        player.field_71069_bz.func_75142_b();
        return 1;
    }

    public static int nickname(ServerPlayerEntity player, String nick) {
        if (nick.length() > 30) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Nickname too long!"), false);
            return 0;
        }
        FTBEPlayerData data = FTBEPlayerData.get((PlayerEntity)player);
        data.nick = nick.trim();
        data.save();
        player.refreshDisplayName();
        if (data.nick.isEmpty()) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Nickname reset!"), false);
        } else {
            player.func_146105_b((ITextComponent)new StringTextComponent("Nickname changed to '" + data.nick + "'"), false);
        }
        data.sendTabName(player.field_71133_b);
        return 1;
    }
}

