/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftblibrary.snbt.OrderedCompoundTag;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TeleportPos {
    public final RegistryKey<World> dimension;
    public final BlockPos pos;
    public long time;

    public TeleportPos(RegistryKey<World> d, BlockPos p) {
        this.dimension = d;
        this.pos = p;
        this.time = System.currentTimeMillis();
    }

    public TeleportPos(World world, BlockPos p) {
        this((RegistryKey<World>)world.func_234923_W_(), p);
    }

    public TeleportPos(Entity entity) {
        this(entity.field_70170_p, entity.func_233580_cy_());
    }

    public TeleportPos(CompoundNBT tag) {
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(tag.func_74779_i("dim")));
        this.pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
        this.time = tag.func_74763_f("time");
    }

    public TeleportResult teleport(ServerPlayerEntity player) {
        ServerWorld world = player.field_71133_b.func_71218_a(this.dimension);
        if (world == null) {
            return TeleportResult.DIMENSION_NOT_FOUND;
        }
        int lvl = player.field_71068_ca;
        player.func_200619_a(world, (double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.1, (double)this.pos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
        player.func_195399_b(lvl);
        return TeleportResult.SUCCESS;
    }

    public CompoundNBT write() {
        OrderedCompoundTag tag = new OrderedCompoundTag();
        tag.singleLine = true;
        tag.func_74778_a("dim", this.dimension.func_240901_a_().toString());
        tag.func_74768_a("x", this.pos.func_177958_n());
        tag.func_74768_a("y", this.pos.func_177956_o());
        tag.func_74768_a("z", this.pos.func_177952_p());
        tag.func_74772_a("time", this.time);
        return tag;
    }

    public String distanceString(TeleportPos origin) {
        if (origin.dimension == this.dimension) {
            double dx = this.pos.func_177958_n() - origin.pos.func_177958_n();
            double dz = this.pos.func_177952_p() - origin.pos.func_177952_p();
            return (int)Math.sqrt(dx * dx + dz * dz) + "m";
        }
        ResourceLocation s = this.dimension.func_240901_a_();
        if (s.func_110624_b().equals("minecraft")) {
            switch (s.func_110623_a()) {
                case "overworld": {
                    return "Overworld";
                }
                case "the_nether": {
                    return "The Nether";
                }
                case "the_end": {
                    return "The End";
                }
            }
            return s.func_110623_a();
        }
        return s.func_110623_a() + " [" + s.func_110624_b() + "]";
    }

    @FunctionalInterface
    public static interface CooldownTeleportResult
    extends TeleportResult {
        public long getCooldown();

        @Override
        default public int runCommand(ServerPlayerEntity player) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Can't teleport yet! Cooldown: " + TimeUtils.prettyTimeString((long)(this.getCooldown() / 1000L))), false);
            return 0;
        }
    }

    @FunctionalInterface
    public static interface TeleportResult {
        public static final TeleportResult SUCCESS = new TeleportResult(){

            @Override
            public int runCommand(ServerPlayerEntity player) {
                return 1;
            }

            @Override
            public boolean isSuccess() {
                return true;
            }
        };
        public static final TeleportResult DIMENSION_NOT_FOUND = player -> {
            player.func_146105_b((ITextComponent)new StringTextComponent("Dimension not found!"), false);
            return 0;
        };

        public int runCommand(ServerPlayerEntity var1);

        default public boolean isSuccess() {
            return false;
        }
    }
}

