/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import snownee.snow.CoreModule;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.SnowRealMagic;
import snownee.snow.block.ModSnowBlock;
import snownee.snow.entity.FallingSnowEntity;

public class WorldTickHandler {
    private static Method METHOD;

    public static void tick(TickEvent.WorldTickEvent event) {
        Iterable holders;
        if (SnowCommonConfig.retainOriginalBlocks || METHOD == null) {
            return;
        }
        ServerWorld world = (ServerWorld)event.world;
        int blizzard = world.func_82736_K().func_223592_c(CoreModule.BLIZZARD_STRENGTH);
        if (blizzard == 0 && !world.func_72896_J()) {
            return;
        }
        if (world.func_72863_F().func_201711_g() instanceof DebugChunkGenerator) {
            return;
        }
        try {
            holders = (Iterable)METHOD.invoke((Object)world.func_72863_F().field_217237_a, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            SnowRealMagic.LOGGER.catching((Throwable)e);
            METHOD = null;
            return;
        }
        holders.forEach(holder -> {
            Chunk chunk = holder.func_219298_c();
            if (chunk == null || !world.func_72863_F().func_222865_a(chunk.func_76632_l())) {
                return;
            }
            if (world.field_73012_v.nextInt(16) == 0) {
                int x = chunk.func_76632_l().func_180334_c();
                int y = chunk.func_76632_l().func_180333_d();
                BlockPos pos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, world.func_217383_a(x, 0, y, 15)).func_177977_b();
                Biome biome = world.func_226691_t_(pos);
                if (world.isAreaLoaded(pos, 1)) {
                    if (blizzard > 0) {
                        WorldTickHandler.doBlizzard(world, pos, blizzard);
                        return;
                    }
                    if (!ModUtil.isColdAt((World)world, biome, pos)) {
                        return;
                    }
                    BlockState state = world.func_180495_p(pos);
                    if (!ModSnowBlock.canContainState(state)) {
                        return;
                    }
                    if (world.func_226658_a_(LightType.BLOCK, pos.func_177984_a()) > 11) {
                        return;
                    }
                    ModSnowBlock.convert((IWorld)world, pos, state, 1, 3);
                }
            }
        });
    }

    private static void doBlizzard(ServerWorld world, BlockPos pos, int blizzard) {
        if (pos.func_177956_o() == world.func_217301_I()) {
            return;
        }
        blizzard = MathHelper.func_76125_a((int)blizzard, (int)1, (int)8);
        pos = pos.func_177981_b(64);
        FallingSnowEntity entity = new FallingSnowEntity((World)world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() + 0.5, blizzard);
        world.func_217376_c((Entity)entity);
    }

    static {
        try {
            METHOD = ObfuscationReflectionHelper.findMethod(ChunkManager.class, (String)"func_223491_f", (Class[])new Class[0]);
        }
        catch (Exception e) {
            SnowRealMagic.LOGGER.catching((Throwable)e);
        }
    }
}

