/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.block.WitherRoseBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import snownee.snow.CoreModule;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.ModSnowBlock;
import snownee.snow.block.SnowTile;
import snownee.snow.block.WrappedWorld;

public class ModSnowTileBlock
extends ModSnowBlock {
    public ModSnowTileBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SnowTile();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = super.func_220071_b(state, worldIn, pos, context);
        shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)this.getContainedState(worldIn, pos).func_196952_d(worldIn, pos), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        return VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197868_b(), (IBooleanFunction)IBooleanFunction.field_223238_i_);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = super.func_220053_a(state, worldIn, pos, context);
        return VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)this.getContainedState(worldIn, pos).func_215700_a(worldIn, pos, context), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    }

    @Override
    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        if (useContext.func_195996_i().func_77973_b() == CoreModule.BLOCK.func_199767_j()) {
            return super.func_196253_a(state, useContext);
        }
        if (!super.func_196253_a(state, useContext)) {
            return false;
        }
        return this.getContainedState((IBlockReader)useContext.func_195991_k(), useContext.func_195995_a()).func_196953_a(useContext);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return this.getContainedState(worldIn, pos).func_196957_g(worldIn, pos, type);
    }

    @Override
    public BlockState getContainedState(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof SnowTile) {
            return ((SnowTile)tile).getState();
        }
        return super.getContainedState(world, pos);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileEntity tile;
        if (willHarvest) {
            this.getBlock().func_176208_a(world, pos, state, player);
        }
        if ((tile = world.func_175625_s(pos)) instanceof SnowTile) {
            BlockState newState = ((SnowTile)tile).getState();
            world.func_175656_a(pos, newState);
        }
        return true;
    }

    public String func_149739_a() {
        return CoreModule.BLOCK.func_149739_a();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getContainedState(world, pos).getPickBlock(target, world, pos, player);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            BlockState stateIn;
            if (!worldIn.field_72995_K && worldIn.func_175659_aa() != Difficulty.PEACEFUL) {
                LivingEntity livingentity;
                if (this.getContainedState((IBlockReader)worldIn, pos).func_177230_c() instanceof WitherRoseBlock && !(livingentity = (LivingEntity)entityIn).func_180431_b(DamageSource.field_82727_n)) {
                    livingentity.func_195064_c(new EffectInstance(Effects.field_82731_v, 40));
                }
            } else if (entityIn.func_200600_R() != EntityType.field_220356_B && entityIn.func_200600_R() != EntityType.field_226289_e_ && (stateIn = this.getContainedState((IBlockReader)worldIn, pos)).func_177230_c() instanceof SweetBerryBushBlock) {
                entityIn.func_213295_a(state, new Vector3d((double)0.8f, 0.75, (double)0.8f));
                if (!(worldIn.field_72995_K || (Integer)stateIn.func_177229_b((Property)SweetBerryBushBlock.field_220125_a) <= 0 || entityIn.field_70142_S == entityIn.func_226277_ct_() && entityIn.field_70136_U == entityIn.func_226281_cx_())) {
                    double d0 = Math.abs(entityIn.func_226277_ct_() - entityIn.field_70142_S);
                    double d1 = Math.abs(entityIn.func_226281_cx_() - entityIn.field_70136_U);
                    if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                        entityIn.func_70097_a(DamageSource.field_220302_v, 1.0f);
                    }
                }
            }
        }
    }

    @Override
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        BlockState stateIn = this.getContainedState((IBlockReader)worldIn, pos);
        if (SnowCommonConfig.retainOriginalBlocks) {
            worldIn.func_175656_a(pos, stateIn);
            return;
        }
        super.func_225542_b_(state, worldIn, pos, random);
        if (stateIn.func_177230_c() instanceof TallGrassBlock) {
            return;
        }
        BlockState stateNow = worldIn.func_180495_p(pos);
        if (stateNow.func_177230_c() != state.func_177230_c()) {
            return;
        }
        stateIn.func_227034_b_(worldIn, pos, random);
        BlockState stateNow2 = worldIn.func_180495_p(pos);
        if (stateNow2.func_177230_c() != state.func_177230_c()) {
            ModSnowTileBlock.convert((IWorld)worldIn, pos, stateNow2, (Integer)stateNow.func_177229_b((Property)field_176315_a), 3);
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        this.getContainedState((IBlockReader)worldIn, pos).func_227031_a_(ModSnowTileBlock.wrapWorld(worldIn), player, handIn, hit);
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        if (worldIn.field_72995_K) {
            return;
        }
        try {
            BlockState contained = this.getContainedState((IBlockReader)worldIn, pos);
            if (contained.func_185887_b((IBlockReader)worldIn, pos) == 0.0f) {
                worldIn.func_217379_c(2001, pos, Block.func_196246_j((BlockState)contained));
                Block.func_220054_a((BlockState)contained, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)ItemStack.field_190927_a);
                int layers = (Integer)state.func_177229_b((Property)field_176315_a);
                worldIn.func_175656_a(pos, (BlockState)CoreModule.BLOCK.func_176223_P().func_206870_a((Property)field_176315_a, (Comparable)Integer.valueOf(layers)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static World wrapWorld(World world) {
        if (SnowCommonConfig.advancedBlockInteraction) {
            return new WrappedWorld(world);
        }
        return world;
    }
}

