/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.kiwi.RenderLayer;
import snownee.kiwi.block.ModBlock;
import snownee.kiwi.tile.TextureTile;
import snownee.kiwi.util.Util;
import snownee.snow.CoreModule;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.WrappedSoundType;
import snownee.snow.block.IWaterLoggableSnowVariant;
import snownee.snow.block.SnowTextureTile;

@RenderLayer(value=RenderLayer.Layer.CUTOUT)
public class SnowSlabBlock
extends ModBlock
implements IWaterLoggableSnowVariant {
    protected static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape BOTTOM_RENDER_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public SnowSlabBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SnowTextureTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        Block block;
        TileEntity tile = worldIn.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(handIn);
        if (hit.func_216354_b() == Direction.UP && tile instanceof TextureTile && ((TextureTile)tile).getMark("0") == stack.func_77973_b() && stack.func_77973_b() instanceof BlockItem && stack.func_77973_b().func_206844_a((ITag)ItemTags.field_203442_w) && (block = ((BlockItem)stack.func_77973_b()).func_179223_d()) instanceof SlabBlock) {
            BlockState state2 = (BlockState)block.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE);
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, state2);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, stack);
                }
            }
            SoundType soundtype = state2.getSoundType((IWorldReader)worldIn, pos, (Entity)player);
            worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BOTTOM_SHAPE;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return BOTTOM_RENDER_SHAPE;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String key = Util.getTextureItem((ItemStack)stack, (String)"0");
        if (!key.isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(key).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        CoreModule.fillTextureItems((ITag.INamedTag<Item>)ItemTags.field_203442_w, (Block)this, items);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (SnowCommonConfig.retainOriginalBlocks) {
            worldIn.func_175656_a(pos, this.getRaw(state, (IBlockReader)worldIn, pos));
        } else if (ModUtil.shouldMelt((World)worldIn, pos)) {
            worldIn.func_175656_a(pos, this.getRaw(state, (IBlockReader)worldIn, pos));
        }
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return WrappedSoundType.get(this.getRaw(state, (IBlockReader)world, pos).getSoundType(world, pos, entity));
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return this.getRaw(state, worldIn, pos).func_185903_a(player, worldIn, pos);
    }
}

