/*
 * Decompiled with CFR 0.152.
 */
package pregenerator;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.server.ServerPropertiesProvider;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pregenerator.PregenConfig;
import pregenerator.client.ClientHandler;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.common.commands.PregenCommand;
import pregenerator.common.commands.arguments.CenterArgument;
import pregenerator.common.commands.arguments.RadiusArgument;
import pregenerator.common.commands.arguments.SuggestableEnumArgument;
import pregenerator.common.commands.arguments.UnloadedDimensionArgument;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.DimensionManager;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.structures.StructureManager;
import pregenerator.common.tracker.ServerTracker;
import pregenerator.common.utils.misc.ReflectionHelper;

@Mod(value="chunkpregen")
public class ChunkPregenerator {
    public static ChunkPregenerator INSTANCE;
    public static Logger LOGGER;

    public ChunkPregenerator() {
        INSTANCE = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)this);
        PregenConfig.INSTANCE.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)StructureManager.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ClientHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStart);
        MinecraftForge.EVENT_BUS.addListener(this::onCommandLoad);
        MinecraftForge.EVENT_BUS.addListener(DimensionManager.INSTANCE::onServerStarting);
        ITask.init();
        IDeletionTask.init();
        IProcessorInfo.init();
        NetworkManager.INSTANCE.init();
        ServerTracker.INSTANCE.init();
        this.registerArguments();
    }

    public void registerArguments() {
        ArgumentTypes.func_218136_a((String)"chunkpregen:pregen_coord", CenterArgument.class, (IArgumentSerializer)new ArgumentSerializer(CenterArgument::center));
        ArgumentTypes.func_218136_a((String)"chunkpregen:pregen_radius", RadiusArgument.class, (IArgumentSerializer)new ArgumentSerializer(RadiusArgument::integer));
        ArgumentTypes.func_218136_a((String)"chunkpregen:pregen_enum", SuggestableEnumArgument.class, (IArgumentSerializer)new SuggestableEnumArgument.Serializer());
        ArgumentTypes.func_218136_a((String)"chunkpregen:pregen_unload", UnloadedDimensionArgument.class, (IArgumentSerializer)new UnloadedDimensionArgument.Serializer());
    }

    public void registerPermissions() {
        PermissionAPI.registerNode((String)"pregen.retrogen", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"allows to set Retrogen Permissions");
        PermissionAPI.registerNode((String)"pregen.mass.deletion", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"allows to remove Entities/TileEntities in mass");
        PermissionAPI.registerNode((String)"pregen.chunkscraping", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"allows to scan the entire loaded world for detailed data");
        PermissionAPI.registerNode((String)"pregen.commands", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"allows to use In-Gui-Commands");
        PermissionAPI.registerNode((String)"pregen.world_gui", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"allows to access the InGui WorldData");
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientLoad(FMLClientSetupEvent event) {
        ClientHandler.INSTANCE.initClient();
    }

    @SubscribeEvent
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        ServerManager.INSTANCE.init();
        this.registerPermissions();
    }

    public void onServerStart(FMLServerAboutToStartEvent event) {
        if (((Boolean)PregenConfig.INSTANCE.blockOptimization.get()).booleanValue()) {
            return;
        }
        if (event.getServer() instanceof DedicatedServer) {
            ServerPropertiesProvider provider = (ServerPropertiesProvider)ReflectionHelper.getValueSave(DedicatedServer.class, (DedicatedServer)event.getServer(), new String[]{"settings", "field_71340_o"});
            ReflectionHelper.setFinalValue(ServerProperties.class, provider.func_219034_a(), false, "field_241078_O_", "field_241078_O_");
        } else if (event.getServer() instanceof IntegratedServer) {
            this.fixClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void fixClient() {
        Minecraft.func_71410_x().field_71474_y.field_241568_aS_ = false;
    }

    public void onCommandLoad(RegisterCommandsEvent event) {
        PregenCommand.registerCommand((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    static {
        LOGGER = LogManager.getLogger((String)"Chunk Pregenerator");
    }
}

