/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.client.gui.CommandScreen;
import pregenerator.client.helpers.IDimensionAcceptor;
import pregenerator.common.base.IBaseTask;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.networking.dimrequests.DimensionInfoRequest;
import pregenerator.common.utils.misc.GenShape;

public abstract class BaseCommandScreen
extends BasePregenScreen
implements IDimensionAcceptor {
    protected List<ResourceLocation> dimensions = new ObjectArrayList();
    protected int dimensionIndex = -1;
    protected List<GenerationType> generationTypes = ObjectArrayList.wrap((Object[])GenerationType.values());
    protected int generationType = 1;
    protected List<GenShape> shapeTypes = ObjectArrayList.wrap((Object[])GenShape.values());
    protected int shapeType = 0;
    protected Button dimensionButton;
    protected Button generationButton;
    protected Button shapeButton;
    protected Button startButton;
    protected String taskName;

    protected BaseCommandScreen() {
        super((ITextComponent)new StringTextComponent("Base Pregen Screen"));
    }

    public abstract boolean usesDimension();

    public abstract IBaseTask<?> createTask(String var1, RegistryKey<World> var2, GenShape var3, int var4);

    public ITask createGenTask() {
        return (ITask)this.createTask(this.taskName, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)this.dimensions.get(this.dimensionIndex)), this.shapeTypes.get(this.shapeType), this.generationTypes.get(this.generationType).getIndex());
    }

    public IDeletionTask createDeletionTask() {
        return (IDeletionTask)this.createTask(this.taskName, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)this.dimensions.get(this.dimensionIndex)), this.shapeTypes.get(this.shapeType), this.generationTypes.get(this.generationType).getIndex());
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        if (this.usesDimension()) {
            this.sendToServer(new DimensionInfoRequest(true));
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.tick % 1000 == 0 && this.usesDimension()) {
            this.sendToServer(new DimensionInfoRequest(true));
        }
    }

    @Override
    public void onDimensionSync(List<ResourceLocation> location) {
        ResourceLocation oldDim = this.dimensionIndex < 0 || this.dimensionIndex >= this.dimensions.size() ? null : this.dimensions.get(this.dimensionIndex);
        this.dimensions.clear();
        this.dimensions.addAll(location);
        int newIndex = this.dimensions.indexOf(oldDim);
        if (newIndex != this.dimensionIndex) {
            this.dimensionIndex = newIndex;
        } else if (this.dimensionIndex == -1) {
            if (this.dimensionButton != null) {
                this.dimensionButton.field_230693_o_ = true;
            }
            if (this.startButton != null) {
                this.startButton.field_230693_o_ = this.taskName != null && this.taskName.length() > 0;
            }
            this.setDimension(this.dimensions.indexOf(DimensionType.field_235999_c_.getRegistryName()));
        }
    }

    public void setDimension(int index) {
        if (this.dimensionIndex != index && index >= 0 && index < this.dimensions.size()) {
            this.dimensionIndex = index;
            if (this.dimensionButton != null) {
                this.dimensionButton.func_238482_a_((ITextComponent)new StringTextComponent("Dim: " + this.getDimensionName()));
            }
        }
    }

    public void setGenerationType(int index) {
        if (this.generationType != index && index >= 0 && index < this.generationTypes.size()) {
            this.generationType = index;
            if (this.generationButton != null) {
                this.generationButton.func_238482_a_((ITextComponent)new StringTextComponent("Generation: " + this.getGenerationName()));
            }
        }
    }

    public void setShapeType(int index) {
        if (this.shapeType != index && index >= 0 && index < this.shapeTypes.size()) {
            this.shapeType = index;
            if (this.shapeButton != null) {
                this.shapeButton.func_238482_a_((ITextComponent)new StringTextComponent("Shape: " + this.getShapeName()));
            }
        }
    }

    protected void toggleDimension(Button button) {
        if (this.dimensions.isEmpty()) {
            return;
        }
        this.setDimension((this.dimensionIndex + 1) % this.dimensions.size());
    }

    protected void toggleShape(Button button) {
        if (this.shapeTypes.isEmpty()) {
            return;
        }
        this.setShapeType((this.shapeType + 1) % this.shapeTypes.size());
    }

    protected void toggleGeneration(Button button) {
        if (this.generationTypes.isEmpty()) {
            return;
        }
        this.setGenerationType((this.generationType + 1) % this.generationTypes.size());
    }

    protected void setName(String s) {
        this.taskName = s;
        if (this.startButton != null) {
            this.startButton.field_230693_o_ = this.taskName != null && this.taskName.length() > 0 && this.dimensionIndex >= 0 && this.dimensionIndex < this.dimensions.size();
        }
    }

    protected void back(Button button) {
        this.getMinecraft().func_147108_a((Screen)new CommandScreen());
    }

    public String getShapeName() {
        return this.shapeType < 0 || this.shapeType >= this.shapeTypes.size() ? "Unknown" : this.shapeTypes.get(this.shapeType).name();
    }

    public String getGenerationName() {
        return this.generationType < 0 || this.generationType >= this.generationTypes.size() ? "Unknown" : this.generationTypes.get(this.generationType).name();
    }

    public String getDimensionName() {
        return this.dimensionIndex < 0 || this.dimensionIndex >= this.dimensions.size() ? "Loading" : ChunkLogger.toPascalCase(this.dimensions.get(this.dimensionIndex).func_110623_a());
    }
}

