/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ICharacterConsumer;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.client.gui.widget.Slider;
import pregenerator.base.impl.PregenCheckBox;
import pregenerator.base.impl.PregenSlider;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;

public abstract class BasePregenScreen
extends Screen {
    protected int centerX;
    protected int centerY;
    protected int tick;

    protected BasePregenScreen(ITextComponent titleIn) {
        super(titleIn);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.centerX = this.field_230708_k_ / 2;
        this.centerY = this.field_230709_l_ / 2;
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.tick;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
        super.func_230430_a_(matrix, mouseX, mouseY, partial);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public Button registerButton(int x, int y, int width, int height, String name, Button.IPressable pressable) {
        ExtendedButton button = new ExtendedButton(x + this.centerX, y + this.centerY, width, height, (ITextComponent)new StringTextComponent(name), pressable);
        this.func_230480_a_((Widget)button);
        return button;
    }

    public Button registerSimpleButton(int x, int y, int width, int height, String name, Button.IPressable pressable) {
        ExtendedButton button = new ExtendedButton(x, y, width, height, (ITextComponent)new StringTextComponent(name), pressable);
        this.func_230480_a_((Widget)button);
        return button;
    }

    public PregenCheckBox registerCheckbox(int x, int y, int width, int height, String text, boolean checked) {
        PregenCheckBox check = new PregenCheckBox(x + this.centerX, y + this.centerY, width, height, text, checked, T -> {});
        this.func_230480_a_((Widget)check);
        return check;
    }

    public PregenCheckBox registerCheckbox(int x, int y, int width, int height, String text, boolean checked, Button.IPressable handler) {
        PregenCheckBox check = new PregenCheckBox(x + this.centerX, y + this.centerY, width, height, text, checked, handler);
        this.func_230480_a_((Widget)check);
        return check;
    }

    public TextFieldWidget registerText(int x, int y, int width, int height, String original) {
        TextFieldWidget widget = new TextFieldWidget(this.field_230712_o_, x + this.centerX, y + this.centerY, width, height, (ITextComponent)new StringTextComponent(""));
        widget.func_146180_a(original);
        this.func_230480_a_((Widget)widget);
        return widget;
    }

    public TextFieldWidget registerSimpleText(int x, int y, int width, int height, String original) {
        TextFieldWidget widget = new TextFieldWidget(this.field_230712_o_, x, y, width, height, (ITextComponent)new StringTextComponent(""));
        widget.func_146180_a(original);
        this.func_230480_a_((Widget)widget);
        return widget;
    }

    public PregenSlider registerSlider(int x, int y, int width, int height, String prefix, String postfix, double minVal, double maxVal, double currentVal, Slider.ISlider par) {
        PregenSlider slider = new PregenSlider(x + this.centerX, y + this.centerY, width, height, prefix, postfix, minVal, maxVal, currentVal, par);
        this.func_230480_a_((Widget)slider);
        return slider;
    }

    public PregenSlider registerSimpleSlider(int x, int y, int width, int height, String prefix, String postfix, double minVal, double maxVal, double currentVal, Slider.ISlider par) {
        PregenSlider slider = new PregenSlider(x, y, width, height, prefix, postfix, minVal, maxVal, currentVal, par);
        this.func_230480_a_((Widget)slider);
        return slider;
    }

    public void drawText(MatrixStack matrix, String s, int x, int y, int color) {
        this.field_230712_o_.func_238422_b_(matrix, new StringTextComponent(s).func_241878_f(), (float)(this.centerX + x), (float)(this.centerY + y), color);
    }

    public void drawText(MatrixStack matrix, ITextProperties s, int x, int y, int color) {
        this.field_230712_o_.func_238422_b_(matrix, LanguageMap.func_74808_a().func_241870_a(s), (float)(this.centerX + x), (float)(this.centerY + y), color);
    }

    public void drawSimpleText(MatrixStack matrix, String s, int x, int y, int color) {
        this.field_230712_o_.func_238422_b_(matrix, new StringTextComponent(s).func_241878_f(), (float)x, (float)y, color);
    }

    public void drawCenterText(MatrixStack matrix, String s, int x, int y, int color) {
        this.field_230712_o_.func_238422_b_(matrix, new StringTextComponent(s).func_241878_f(), (float)(this.centerX + x - this.field_230712_o_.func_78256_a(s) / 2), (float)(this.centerY + y), color);
    }

    public void drawLeftText(MatrixStack matrix, String s, int x, int y, int color) {
        this.field_230712_o_.func_238422_b_(matrix, new StringTextComponent(s).func_241878_f(), (float)(this.centerX + x - this.field_230712_o_.func_78256_a(s)), (float)(this.centerY + y), color);
    }

    public void renderTextureWithOffset(MatrixStack stack, float x, float y, float width, float height) {
        this.renderTexture(stack, x + (float)this.centerX, y + (float)this.centerY, width, height);
    }

    public void renderTexture(MatrixStack stack, float x, float y, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix, x, y + height, (float)this.func_230927_p_()).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x + width, y + height, (float)this.func_230927_p_()).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x + width, y, (float)this.func_230927_p_()).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x, y, (float)this.func_230927_p_()).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawSimpleRect(MatrixStack stack, int minX, int minY, int maxX, int maxY, int color, boolean drop) {
        if (drop) {
            BasePregenScreen.func_238467_a_((MatrixStack)stack, (int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-13158601);
            BasePregenScreen.func_238467_a_((MatrixStack)stack, (int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-1);
        } else {
            BasePregenScreen.func_238467_a_((MatrixStack)stack, (int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-13158601);
            BasePregenScreen.func_238467_a_((MatrixStack)stack, (int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-1);
        }
        BasePregenScreen.func_238467_a_((MatrixStack)stack, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)color);
    }

    public void drawRectangle(MatrixStack stack, int xSize, int ySize, int xOffset, int yOffset, int color, boolean drop) {
        int minX = this.centerX - xSize + xOffset;
        int minY = this.centerY - ySize + yOffset;
        int maxX = this.centerX + xSize + xOffset;
        int maxY = this.centerY + ySize + yOffset;
        if (drop) {
            BasePregenScreen.func_238467_a_((MatrixStack)stack, (int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-13158601);
            BasePregenScreen.func_238467_a_((MatrixStack)stack, (int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-1);
        } else {
            BasePregenScreen.func_238467_a_((MatrixStack)stack, (int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-13158601);
            BasePregenScreen.func_238467_a_((MatrixStack)stack, (int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-1);
        }
        BasePregenScreen.func_238467_a_((MatrixStack)stack, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)color);
    }

    public boolean isInsideBox(int mouseX, int mouseY, int minX, int minY, int maxX, int maxY) {
        return mouseX >= this.centerX + minX && mouseX < this.centerX + maxX && mouseY >= this.centerY + minY && mouseY <= this.centerY + maxY;
    }

    public void fill(MatrixStack stack, float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227621_I_();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        bufferbuilder.func_227888_a_(matrix, minX, maxY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, maxX, maxY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, maxX, minY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, minX, minY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_227619_H_();
        GlStateManager.func_227737_l_();
    }

    public void drawQuadArea(MatrixStack matrix, float left, float top, float right, float bottom, BufferBuilder builder, int color) {
        if (left < right) {
            float i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            float j = top;
            top = bottom;
            bottom = j;
        }
        Matrix4f stack = matrix.func_227866_c_().func_227870_a_();
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        builder.func_227888_a_(stack, left, bottom, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        builder.func_227888_a_(stack, right, bottom, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        builder.func_227888_a_(stack, right, top, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        builder.func_227888_a_(stack, left, top, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
    }

    public void sendToServer(IPregenPacket packet) {
        NetworkManager.INSTANCE.sendToServer(packet);
    }

    public static String convertText(ITextComponent component) {
        StringConsumer consumer = new StringConsumer();
        component.func_241878_f().accept((ICharacterConsumer)consumer);
        return consumer.getBuilder().toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class StringConsumer
    implements ICharacterConsumer {
        StringBuilder builder = new StringBuilder();
        TextFormatting formatting = TextFormatting.RESET;

        public boolean accept(int index, Style style, int character) {
            TextFormatting format = this.getFormat(style);
            if (format != this.formatting) {
                this.formatting = format;
                this.builder.append(format.toString());
            }
            this.builder.append((char)character);
            return true;
        }

        protected TextFormatting getFormat(Style style) {
            TextFormatting format = style.func_240711_a_() == null ? null : TextFormatting.func_96300_b((String)style.func_240711_a_().func_240747_b_());
            return format == null ? TextFormatting.RESET : format;
        }

        public StringBuilder getBuilder() {
            return this.builder;
        }
    }
}

