/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import pregenerator.base.api.Align;
import pregenerator.base.api.IRenderHelper;

public class RenderHelper
implements IRenderHelper {
    public static final float TEXTURE_SCALE = 0.00390625f;
    float scale = 1.0f;
    Minecraft mc;
    FontRenderer render;
    MatrixStack matrix;

    @Override
    public void init(MatrixStack matrix) {
        this.mc = Minecraft.func_71410_x();
        this.render = this.mc.field_71466_p;
        GlStateManager.func_227731_j_();
        this.matrix = matrix;
    }

    @Override
    public void drawText(float x, float y, Align align, String text) {
        float textScale = 0.5f;
        float invScale = 1.0f / textScale;
        this.matrix.func_227862_a_(textScale, textScale, textScale);
        this.render.func_238405_a_(this.matrix, text, x * invScale + align.align(this.render.func_78256_a(text)), y * invScale, 0xFFFFFF);
        this.matrix.func_227862_a_(invScale, invScale, invScale);
    }

    @Override
    public void drawArea(int x, int y, int widht, int height) {
        GlStateManager.func_227621_I_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227700_d_();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_227762_u_((int)7425);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buffer = tes.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int minX = 4 + x;
        int maxX = minX + widht;
        int minY = 4 + y;
        int maxY = minY + height;
        this.fillGradient(minX - 3, minY - 4, maxX + 3, minY - 3, -267386864, buffer);
        this.fillGradient(minX - 3, maxY + 3, maxX + 3, maxY + 4, -267386864, buffer);
        this.fillGradient(minX - 3, minY - 3, maxX + 3, maxY + 3, -267386864, buffer);
        this.fillGradient(minX - 4, minY - 3, minX - 3, maxY + 3, -267386864, buffer);
        this.fillGradient(maxX + 3, minY - 3, maxX + 4, maxY + 3, -267386864, buffer);
        this.fillGradient(minX - 3, minY - 3 + 1, minX - 3 + 1, maxY + 3 - 1, 0x505000FF, buffer);
        this.fillGradient(maxX + 2, minY - 3 + 1, maxX + 3, maxY + 3 - 1, 0x505000FF, buffer);
        this.fillGradient(minX - 3, minY - 3, maxX + 3, minY - 3 + 1, 0x505000FF, buffer);
        this.fillGradient(minX - 3, maxY + 2, maxX + 3, maxY + 3, 1344798847, buffer);
        tes.func_78381_a();
        GlStateManager.func_227762_u_((int)7424);
        GlStateManager.func_227737_l_();
        GlStateManager.func_227709_e_();
        GlStateManager.func_227619_H_();
    }

    @Override
    public void drawProgressBar(int x, int y, int width, int height, float progress, String text) {
        progress = MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f);
        Tessellator test = Tessellator.func_178181_a();
        BufferBuilder builder = test.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.mc.func_110434_K().func_110577_a(Screen.field_230665_h_);
        this.drawTexture(x, y, 0.0f, 74.0f, 182, 5, width, height, builder);
        if (progress > 0.0f) {
            this.drawTexture(x, y, 0.0f, 79.0f, (int)(182.0f * progress), 5, (int)((float)width * progress), height, builder);
        }
        test.func_78381_a();
        this.drawText(x + width / 2, y + 1, Align.CENTER, text);
    }

    protected void fillGradient(int left, int top, int right, int bottom, int color, BufferBuilder buffer) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Matrix4f stack = this.matrix.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(stack, (float)right, (float)top, -10.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(stack, (float)left, (float)top, -10.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(stack, (float)left, (float)bottom, -10.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(stack, (float)right, (float)bottom, -10.0f).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public void drawTexture(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, BufferBuilder builder) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Matrix4f stack = this.matrix.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(stack, (float)x, (float)(y + height), 0.0f).func_225583_a_(u * f, (v + (float)vHeight) * f1).func_181675_d();
        builder.func_227888_a_(stack, (float)(x + width), (float)(y + height), 0.0f).func_225583_a_((u + (float)uWidth) * f, (v + (float)vHeight) * f1).func_181675_d();
        builder.func_227888_a_(stack, (float)(x + width), (float)y, 0.0f).func_225583_a_((u + (float)uWidth) * f, v * f1).func_181675_d();
        builder.func_227888_a_(stack, (float)x, (float)y, 0.0f).func_225583_a_(u * f, v * f1).func_181675_d();
    }
}

