/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.impl.RenderHelper;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.processing.ProcessorInfoRequest;

public class ProcessorRenderer {
    Map<RegistryKey<World>, IProcessorInfo> byType = new Object2ObjectOpenHashMap();
    List<RegistryKey<World>> infos = new ObjectArrayList();

    public void onInfoPacketReceived(byte[] data) {
        if (data.length <= 0) {
            this.byType.clear();
            this.infos.clear();
            return;
        }
        PacketBuffer buffer = new PacketBuffer(Unpooled.wrappedBuffer((byte[])data));
        ObjectOpenHashSet found = new ObjectOpenHashSet();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            RegistryKey type = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buffer.func_192575_l());
            found.add(type);
            IProcessorInfo info = this.byType.get(type);
            if (info != null) {
                buffer.readByte();
                info.read(buffer);
                continue;
            }
            info = IProcessorInfo.create(buffer.readByte());
            info.read(buffer);
            this.byType.put((RegistryKey<World>)type, info);
            this.infos.add((RegistryKey<World>)type);
        }
        this.infos.retainAll((Collection<?>)found);
        this.byType.keySet().retainAll((Collection<?>)found);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onUIRenderer(RenderGameOverlayEvent.Post event) {
        if (!this.shouldRender()) {
            return;
        }
        int yLevel = 0;
        int m = this.infos.size();
        for (int i = 0; i < m; ++i) {
            IProcessorInfo info = this.byType.get(this.infos.get(i));
            yLevel += info != null ? info.getHeight() : 0;
        }
        RenderHelper helper = new RenderHelper();
        MatrixStack stack = event.getMatrixStack();
        helper.init(stack);
        PregenConfig config = PregenConfig.INSTANCE;
        float zoom = ((Double)config.pregenZoom.get()).floatValue();
        float invZoom = 1.0f / zoom;
        yLevel = (int)((float)yLevel + (float)yLevel * zoom);
        stack.func_227860_a_();
        if (zoom != 1.0f) {
            stack.func_227862_a_(zoom, zoom, 1.0f);
        }
        Align vertical = (Align)((Object)config.pregenVAlign.get());
        Align horizontal = (Align)((Object)config.pregenHAlign.get());
        yLevel = (int)((float)this.calculateHeight(vertical, this.getScreenHeight(), yLevel) * invZoom);
        int screenX = (int)((float)this.getScreenWidth() * invZoom);
        int m2 = this.infos.size();
        for (int i = 0; i < m2; ++i) {
            IProcessorInfo info = this.byType.get(this.infos.get(i));
            if (info == null) continue;
            info.render(helper, this.calculateXOffset(horizontal, screenX, info), yLevel);
            yLevel += info.getHeight();
        }
        stack.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void update() {
        NetworkManager.INSTANCE.sendToServer(new ProcessorInfoRequest());
    }

    public boolean shouldRender() {
        return (Boolean)PregenConfig.INSTANCE.pregenOverlay.get();
    }

    public void setVisible(boolean value) {
        PregenConfig config = PregenConfig.INSTANCE;
        config.pregenOverlay.set((Object)value);
        config.pregenOverlay.save();
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getScreenHeight() {
        return Minecraft.func_71410_x().func_228018_at_().func_198087_p();
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getScreenWidth() {
        return Minecraft.func_71410_x().func_228018_at_().func_198107_o();
    }

    @OnlyIn(value=Dist.CLIENT)
    private int calculateXOffset(Align align, int screenWidth, IProcessorInfo info) {
        switch (align) {
            case CENTER: {
                return screenWidth / 2 - info.getWidth() / 2;
            }
            case END: {
                return screenWidth - info.getWidth();
            }
        }
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    private int calculateHeight(Align align, int screenHeight, int yLevel) {
        if (align == Align.END) {
            return screenHeight - yLevel;
        }
        if (align == Align.CENTER) {
            return screenHeight / 2 - yLevel / 2;
        }
        return 1;
    }
}

