/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.impl.RenderHelper;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.client.info.TrackerInfo;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.tracking.TrackerInfoRequest;

public class TrackerRenderer {
    TrackerInfo tracker = new TrackerInfo();
    boolean dataReceived = false;

    public void onTrackerInfoReceived(byte[] data) {
        if (data.length <= 0) {
            this.tracker.clear();
            this.dataReceived = false;
            return;
        }
        this.tracker.read(new PacketBuffer(Unpooled.wrappedBuffer((byte[])data)));
        this.dataReceived = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onUIRenderer(RenderGameOverlayEvent.Post event) {
        PregenConfig config = PregenConfig.INSTANCE;
        if (!this.shouldTrack() || !this.dataReceived) {
            return;
        }
        MatrixStack stack = event.getMatrixStack();
        RenderHelper helper = new RenderHelper();
        helper.init(stack);
        float zoom = ((Double)config.trackerZoom.get()).floatValue();
        float invZoom = 1.0f / zoom;
        int yLevel = this.tracker.getHeight();
        yLevel = (int)((float)yLevel + (float)yLevel * zoom);
        stack.func_227860_a_();
        if (zoom != 1.0f) {
            stack.func_227862_a_(zoom, (float)yLevel, 1.0f);
        }
        Align vertical = (Align)((Object)config.trackerHAlign.get());
        Align horizontal = (Align)((Object)config.trackerVAlign.get());
        this.tracker.render(helper, this.calculateXOffset(horizontal, (int)((float)this.getScreenWidth() * invZoom), this.tracker), (int)((float)this.calculateHeight(vertical, this.getScreenHeight(), yLevel) * invZoom));
        stack.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void update() {
        if (this.shouldTrack()) {
            PregenConfig config = PregenConfig.INSTANCE;
            ResourceLocation location = ResourceLocation.func_208304_a((String)((String)config.detailDimension.get()));
            NetworkManager.INSTANCE.sendToServer(new TrackerInfoRequest(location == null ? World.field_234918_g_.func_240901_a_() : location));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getScreenHeight() {
        return Minecraft.func_71410_x().func_228018_at_().func_198087_p();
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getScreenWidth() {
        return Minecraft.func_71410_x().func_228018_at_().func_198107_o();
    }

    @OnlyIn(value=Dist.CLIENT)
    private int calculateXOffset(Align align, int screenWidth, IProcessorInfo info) {
        switch (align) {
            case CENTER: {
                return screenWidth / 2 - info.getWidth() / 2;
            }
            case END: {
                return screenWidth - info.getWidth();
            }
        }
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    private int calculateHeight(Align align, int screenHeight, int yLevel) {
        if (align == Align.END) {
            return screenHeight - yLevel;
        }
        if (align == Align.CENTER) {
            return screenHeight / 2 - yLevel / 2;
        }
        return 1;
    }

    public boolean shouldWarn() {
        return !this.dataReceived && this.shouldTrack();
    }

    public boolean shouldTrack() {
        return (Boolean)PregenConfig.INSTANCE.trackerOverlay.get();
    }

    public void setVisible(boolean value) {
        PregenConfig config = PregenConfig.INSTANCE;
        config.trackerOverlay.set((Object)value);
        config.trackerOverlay.save();
    }
}

