/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.client.gui.ChunkEntityScreen;
import pregenerator.client.gui.WorldScreen;
import pregenerator.client.helpers.IDimensionAcceptor;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.networking.chunk.ChunkInfoRequest;
import pregenerator.common.networking.chunk.ChunkTPAction;
import pregenerator.common.networking.dimrequests.DimensionInfoRequest;
import pregenerator.common.tracker.ChunkEntry;
import pregenerator.common.tracker.TypeEntry;

public class ChunkScreen
extends BasePregenScreen
implements IDimensionAcceptor {
    static final DecimalFormat FORMAT = new DecimalFormat("###,###");
    List<ResourceLocation> dimensions = new ObjectArrayList();
    int dimensionIndex = -1;
    List<ChunkEntry> chunks = new ObjectArrayList();
    int offset = 0;
    List<String> sorterName = ObjectArrayList.wrap((Object[])new String[]{"Distance", "EntityCount", "TileCount", "TickingTileCount", "RandomUpdates"});
    int sorterIndex = 0;
    Button[] buttonArray = new Button[17];

    public ChunkScreen() {
        super((ITextComponent)new StringTextComponent("Chunk Entry"));
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.sendToServer(new DimensionInfoRequest());
        this.registerButton(86, 92, 60, 14, "Back", T -> this.back());
        this.registerButton(116, -101, 14, 14, "-", T -> this.move(-1));
        this.registerButton(131, -101, 14, 14, "+", T -> this.move(1));
        this.registerButton(-146, 92, 180, 14, "SortBy: " + this.sorterName.get(this.sorterIndex), this::sort);
        this.buttonArray[16] = this.registerButton(-146, -101, 120, 14, "Dim: " + this.getDimensionName(), T -> this.toggleDimension());
        int yOffset = -84;
        for (int i = 0; i < 4; ++i) {
            int index = i;
            this.buttonArray[i * 4] = this.registerButton(95, yOffset, 50, 20, "Entities", T -> this.entities(index));
            this.buttonArray[i * 4 + 1] = this.registerButton(95, yOffset + 20, 50, 20, "Tiles", T -> this.tileEntities(index));
            this.buttonArray[i * 4 + 2] = this.registerButton(44, yOffset, 50, 20, "Teleport", T -> this.teleporter(index));
            this.buttonArray[i * 4 + 3] = this.registerButton(44, yOffset + 20, 50, 20, "Biomes", T -> this.biomes(index));
            yOffset += 43;
            if (i == 0) {
                --yOffset;
                continue;
            }
            ++yOffset;
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.tick % 1000 == 0) {
            this.sendToServer(new DimensionInfoRequest());
        }
        if (this.tick % 500 == 0) {
            this.requestData();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int i;
        for (i = 0; i < 4; ++i) {
            boolean visible;
            this.buttonArray[i * 4].field_230694_p_ = visible = this.offset + i < this.chunks.size();
            this.buttonArray[i * 4 + 1].field_230694_p_ = visible;
            this.buttonArray[i * 4 + 2].field_230694_p_ = visible;
            this.buttonArray[i * 4 + 3].field_230694_p_ = visible;
        }
        this.buttonArray[16].field_230693_o_ = this.dimensions.size() > 0;
        this.func_230446_a_(matrix);
        this.drawRectangle(matrix, 150, 110, 0, 0, -3750202, false);
        this.drawRectangle(matrix, 145, 86, 0, 1, -7631989, true);
        for (i = 0; i < 3; ++i) {
            this.func_238465_a_(matrix, this.centerX - 145, this.centerX + 144, -44 + 44 * i + this.centerY, -13158601);
        }
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.drawCenterText(matrix, "Chunk View", 4, -105, 0x404040);
        this.drawLeftText(matrix, this.offset + "/" + Math.max(0, this.chunks.size() - 9), 114, -95, 0x404040);
        int startY = -84;
        boolean isChunks = !Screen.func_231172_r_();
        for (int i2 = 0; i2 + this.offset < this.chunks.size() && i2 < 4; ++i2) {
            ChunkEntry entry = this.chunks.get(i2 + this.offset);
            String[] data = this.createData(entry, isChunks);
            this.drawText(matrix, data[0], -144, startY, 0x404040);
            this.drawText(matrix, data[1], -144, startY + 10, 0x404040);
            this.drawText(matrix, data[2], -144, startY + 20, 0x404040);
            this.drawText(matrix, data[3], -144, startY + 30, 0x404040);
            startY += 44;
        }
    }

    private String[] createData(ChunkEntry entry, boolean isChunk) {
        StringBuilder builder = new StringBuilder();
        builder.append(TextFormatting.DARK_BLUE).append(isChunk ? "Chunk " : "Block ").append("X:").append(entry.xPos * (isChunk ? 1 : 16)).append(", ");
        builder.append("Z:").append(entry.zPos * (isChunk ? 1 : 16)).append(" ");
        builder.append("(Dist: ").append(FORMAT.format(entry.distance((PlayerEntity)this.getMinecraft().field_71439_g, isChunk))).append(isChunk ? "C" : "B").append(TextFormatting.DARK_BLUE).append(")").append("\n");
        builder.append(TextFormatting.GREEN).append("Entities: ").append(entry.entities).append(" (Types: ").append(entry.entityCount.size()).append(")").append("\n");
        builder.append(TextFormatting.DARK_RED).append("TileEntities: ").append(entry.tileEntities).append(" (Types: ").append(entry.tileEntityCount.size()).append(", Ticking: ").append(entry.tickableTileEntities).append(")").append("\n");
        builder.append(TextFormatting.GOLD).append("Ticking Blocks: ").append(entry.randomBlockTicks);
        return builder.toString().split("\n");
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        int scrolling = (int)scroll;
        if (scrolling != 0) {
            this.offset = MathHelper.func_76125_a((int)(this.offset - scrolling), (int)0, (int)Math.max(0, this.chunks.size() - 9));
            return true;
        }
        return false;
    }

    private void teleporter(int index) {
        if ((index += this.offset) < 0 || index >= this.chunks.size() || this.dimensionIndex < 0 || this.dimensionIndex >= this.dimensions.size()) {
            return;
        }
        ChunkEntry entry = this.chunks.get(index);
        this.sendToServer(new ChunkTPAction(this.dimensions.get(this.dimensionIndex), ChunkPos.func_77272_a((int)entry.xPos, (int)entry.zPos)));
    }

    private void entities(int index) {
        if ((index += this.offset) < 0 || index >= this.chunks.size() || this.dimensionIndex < 0 || this.dimensionIndex >= this.dimensions.size()) {
            return;
        }
        ChunkEntry entry = this.chunks.get(index);
        this.getMinecraft().func_147108_a((Screen)new ChunkEntityScreen(1, "Entity Types", this, ChunkPos.func_77272_a((int)entry.xPos, (int)entry.zPos), this.dimensions.get(this.dimensionIndex), TypeEntry.toList(entry.entityCount)));
    }

    private void tileEntities(int index) {
        if ((index += this.offset) < 0 || index >= this.chunks.size() || this.dimensionIndex < 0 || this.dimensionIndex >= this.dimensions.size()) {
            return;
        }
        ChunkEntry entry = this.chunks.get(index);
        this.getMinecraft().func_147108_a((Screen)new ChunkEntityScreen(0, "TileEntity Types", this, ChunkPos.func_77272_a((int)entry.xPos, (int)entry.zPos), this.dimensions.get(this.dimensionIndex), TypeEntry.toList(entry.tileEntityCount)));
    }

    private void biomes(int index) {
        if ((index += this.offset) < 0 || index >= this.chunks.size() || this.dimensionIndex < 0 || this.dimensionIndex >= this.dimensions.size()) {
            return;
        }
        ChunkEntry entry = this.chunks.get(index);
        this.getMinecraft().func_147108_a((Screen)new ChunkEntityScreen(2, "Biome Types", this, ChunkPos.func_77272_a((int)entry.xPos, (int)entry.zPos), this.dimensions.get(this.dimensionIndex), TypeEntry.toList(entry.biomeCount)));
    }

    private void move(int shift) {
        this.offset = MathHelper.func_76125_a((int)(this.offset + shift), (int)0, (int)Math.max(0, this.chunks.size() - 9));
    }

    private void sort(Button button) {
        this.sorterIndex = (this.sorterIndex + 1) % this.sorterName.size();
        button.func_238482_a_((ITextComponent)new StringTextComponent("SortBy: " + this.sorterName.get(this.sorterIndex)));
        this.sortList();
    }

    public void sortList() {
        this.chunks.sort(this::sort);
    }

    private int sort(ChunkEntry key, ChunkEntry value) {
        switch (this.sorterIndex) {
            case 0: {
                return Integer.compare(key.distance((PlayerEntity)this.getMinecraft().field_71439_g, true), value.distance((PlayerEntity)this.getMinecraft().field_71439_g, true));
            }
            case 1: {
                return Integer.compare(value.entities, key.entities);
            }
            case 2: {
                return Integer.compare(value.tileEntities, key.tileEntities);
            }
            case 3: {
                return Integer.compare(value.tickableTileEntities, key.tickableTileEntities);
            }
            case 4: {
                return Integer.compare(value.randomBlockTicks, key.randomBlockTicks);
            }
        }
        return 0;
    }

    private void back() {
        this.getMinecraft().func_147108_a((Screen)new WorldScreen());
    }

    private void toggleDimension() {
        if (this.dimensions.isEmpty()) {
            return;
        }
        this.setDimension((this.dimensionIndex + 1) % this.dimensions.size());
    }

    public String getDimensionName() {
        return this.dimensionIndex < 0 || this.dimensionIndex > this.dimensions.size() ? "Loading" : ChunkLogger.toPascalCase(this.dimensions.get(this.dimensionIndex).func_110623_a());
    }

    @Override
    public void onDimensionSync(List<ResourceLocation> location) {
        ResourceLocation oldDim = this.dimensionIndex < 0 || this.dimensionIndex >= this.dimensions.size() ? null : this.dimensions.get(this.dimensionIndex);
        this.dimensions.clear();
        this.dimensions.addAll(location);
        int newIndex = this.dimensions.indexOf(oldDim);
        if (newIndex != this.dimensionIndex) {
            this.dimensionIndex = newIndex;
            this.requestData();
        } else if (this.dimensionIndex == -1) {
            this.setDimension(Math.max(0, this.dimensions.indexOf(World.field_234918_g_.func_240901_a_())));
        }
    }

    public void onChunkSynced(PacketBuffer buffer) {
        this.chunks.clear();
        if (buffer.readableBytes() <= 0) {
            return;
        }
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            this.chunks.add(ChunkEntry.fromBuffer(buffer));
        }
        this.sortList();
    }

    public void setDimension(int index) {
        if (this.dimensionIndex == index) {
            this.requestData();
            return;
        }
        if (index < 0 || index >= this.dimensions.size()) {
            return;
        }
        this.dimensionIndex = index;
        this.buttonArray[16].func_238482_a_((ITextComponent)new StringTextComponent("Dim: " + this.getDimensionName()));
        this.chunks.clear();
        this.requestData();
    }

    public void requestData() {
        if (this.dimensionIndex < 0 || this.dimensionIndex >= this.dimensions.size()) {
            this.chunks.clear();
            return;
        }
        this.sendToServer(new ChunkInfoRequest(this.dimensions.get(this.dimensionIndex)));
    }
}

