/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pregenerator.PregenConfig;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.client.ClientHandler;
import pregenerator.client.ProcessorRenderer;
import pregenerator.client.TrackerRenderer;
import pregenerator.client.gui.CommandScreen;
import pregenerator.client.gui.PatreonImage;
import pregenerator.client.gui.WorldScreen;
import pregenerator.client.helpers.IDimensionAcceptor;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.networking.dimrequests.DimensionInfoRequest;
import pregenerator.common.networking.permission.PermissionRequest;

public class PregenScreen
extends BasePregenScreen
implements IDimensionAcceptor {
    List<ResourceLocation> dimensions = new ObjectArrayList();
    Button[] button = new Button[3];

    public PregenScreen() {
        super((ITextComponent)new StringTextComponent("Chunk Pregenerator"));
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.sendToServer(new DimensionInfoRequest());
        this.sendToServer(new PermissionRequest());
        ProcessorRenderer processor = ClientHandler.INSTANCE.processor;
        TrackerRenderer tracker = ClientHandler.INSTANCE.tracker;
        ResourceLocation name = ResourceLocation.func_208304_a((String)((String)PregenConfig.INSTANCE.detailDimension.get()));
        this.registerButton(10, -30, 150, 20, processor.shouldRender() ? "Disable PregenUI" : "Enable PregenUI", this::toggleProcessing);
        this.registerButton(-160, -30, 150, 20, tracker.shouldTrack() ? "Disable TrackerUI" : "Enable TrackerUI", this::toggleTracking);
        this.registerButton(-40, 50, 80, 20, "Back", T -> Minecraft.func_71410_x().func_147108_a(null));
        this.button[0] = this.registerButton(10, -4, 150, 20, "World View", this::openExpansions);
        this.button[1] = this.registerButton(10, 20, 150, 20, "Commands", this::openCommands);
        this.button[2] = this.registerButton(-160, -4, 150, 20, "Detail Dim: " + ChunkLogger.toPascalCase((name == null ? World.field_234918_g_.func_240901_a_() : name).func_110623_a()), this::toggleDim);
        this.registerButton(45, 50, 20, 20, "", this::togglePatreon);
        this.button[0].field_230693_o_ = false;
        this.button[1].field_230693_o_ = false;
        this.button[2].field_230694_p_ = tracker.shouldTrack();
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.tick % 1000 == 0) {
            this.sendToServer(new DimensionInfoRequest());
        }
        this.button[2].field_230694_p_ = ClientHandler.INSTANCE.tracker.shouldTrack();
    }

    public void updatePermission(boolean world, boolean commands) {
        this.button[0].field_230693_o_ = world;
        this.button[1].field_230693_o_ = commands;
    }

    @Override
    public void onDimensionSync(List<ResourceLocation> location) {
        this.dimensions.clear();
        this.dimensions.addAll(location);
    }

    private void openExpansions(Button button) {
        this.getMinecraft().func_147108_a((Screen)new WorldScreen());
    }

    private void openCommands(Button button) {
        this.getMinecraft().func_147108_a((Screen)new CommandScreen());
    }

    private void toggleDim(Button button) {
        ResourceLocation name = ResourceLocation.func_208304_a((String)((String)PregenConfig.INSTANCE.detailDimension.get()));
        int index = this.dimensions.indexOf(name == null ? World.field_234918_g_.func_240901_a_() : name);
        if (index == -1) {
            index = this.dimensions.indexOf(World.field_234918_g_.func_240901_a_());
        }
        if (index != -1) {
            ResourceLocation location = this.dimensions.get((index + 1) % this.dimensions.size());
            PregenConfig.INSTANCE.detailDimension.set((Object)location.toString());
            button.func_238482_a_((ITextComponent)new StringTextComponent("Detail Dim: " + ChunkLogger.toPascalCase(location.func_110623_a())));
        }
    }

    private void togglePatreon(Button button) {
        String s = "https://www.patreon.com/Speiger";
        this.field_230706_i_.func_147108_a((Screen)new ConfirmOpenLinkScreen(p_213069_2_ -> {
            if (p_213069_2_) {
                Util.func_110647_a().func_195640_a(s);
            }
            this.field_230706_i_.func_147108_a((Screen)this);
        }, s, true));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void toggleTracking(Button button) {
        TrackerRenderer tracker = ClientHandler.INSTANCE.tracker;
        boolean result = !tracker.shouldTrack();
        tracker.setVisible(result);
        button.func_238482_a_((ITextComponent)new StringTextComponent(result ? "Disable TrackerUI" : "Enable TrackerUI"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void toggleProcessing(Button button) {
        ProcessorRenderer handler = ClientHandler.INSTANCE.processor;
        boolean result = !handler.shouldRender();
        handler.setVisible(result);
        button.func_238482_a_((ITextComponent)new StringTextComponent(result ? "Disable PregenUI" : "Enable PregenUI"));
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partial) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partial);
        GlStateManager.func_227760_t_((int)PatreonImage.PATREON_PIC.func_110552_b());
        this.renderTextureWithOffset(stack, 48.0f, 52.0f, 15.0f, 15.0f);
        TrackerRenderer info = ClientHandler.INSTANCE.tracker;
        if (info.shouldWarn()) {
            List list = this.field_230712_o_.func_238420_b_().func_238365_g_("Pregen Tracker is not enabled. use \"/pregen utils profiler enable\" to enable it", 115, Style.field_240709_b_);
            for (int i = 0; i < list.size(); ++i) {
                this.drawText(stack, (ITextProperties)list.get(i), -159, 20 + i * 10, -1);
            }
        }
        if (this.isInsideBox(mouseX, mouseY, 45, 50, 65, 70)) {
            this.func_238652_a_(stack, (ITextComponent)new StringTextComponent("Support Speiger on Patreon"), mouseX, mouseY);
        }
    }
}

