/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.client.gui.WorldScreen;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.generator.RetrogenManager;
import pregenerator.common.networking.retrogen.RetrogenChangeRequest;
import pregenerator.common.networking.retrogen.RetrogenSyncRequest;

public class RetrogenScreen
extends BasePregenScreen {
    List<ResourceLocation> features = new ObjectArrayList((Collection)ForgeRegistries.FEATURES.getKeys());
    int offset = 0;
    Button[] buttonArray = new Button[18];

    public RetrogenScreen() {
        super((ITextComponent)new StringTextComponent("Retogen Settings"));
        this.sendToServer(new RetrogenSyncRequest());
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.registerButton(-30, 82, 60, 14, "Back", T -> this.back());
        this.registerButton(116, -91, 14, 14, "-", T -> this.move(-1));
        this.registerButton(131, -91, 14, 14, "+", T -> this.move(1));
        int yOffset = -75;
        for (int i = 0; i < 9; ++i) {
            int index = i;
            this.buttonArray[i * 2] = this.registerButton(105, yOffset, 40, 16, "Enable", T -> this.trigger(index, true));
            this.buttonArray[i * 2 + 1] = this.registerButton(54, yOffset, 50, 16, "Disable", T -> this.trigger(index, false));
            yOffset += 17;
        }
    }

    private void move(int shift) {
        this.offset = MathHelper.func_76125_a((int)(this.offset + shift), (int)0, (int)Math.max(0, this.features.size() - 9));
    }

    private void back() {
        this.getMinecraft().func_147108_a((Screen)new WorldScreen());
    }

    private void trigger(int index, boolean enable) {
        if (this.offset + index < this.features.size()) {
            if (enable) {
                RetrogenManager.INSTANCE.enableFeature(this.features.get(this.offset + index));
            } else {
                RetrogenManager.INSTANCE.disableFeature(this.features.get(this.offset + index));
            }
            this.sendToServer(new RetrogenChangeRequest(this.features.get(this.offset + index), enable));
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int i;
        for (i = 0; i < 9; ++i) {
            boolean visible;
            int index = this.offset + i;
            this.buttonArray[i * 2].field_230694_p_ = visible = index < this.features.size();
            this.buttonArray[i * 2 + 1].field_230694_p_ = visible;
            if (!visible) continue;
            boolean enabled = RetrogenManager.INSTANCE.isActive(this.features.get(index));
            this.buttonArray[i * 2].field_230693_o_ = !enabled;
            this.buttonArray[i * 2 + 1].field_230693_o_ = enabled;
        }
        this.func_230446_a_(matrix);
        this.drawRectangle(matrix, 150, 100, 0, 0, -3750202, false);
        this.drawRectangle(matrix, 145, 76, 0, 1, -7631989, true);
        for (i = 0; i < 8; ++i) {
            this.func_238465_a_(matrix, this.centerX - 145, this.centerX + 144, -59 + 17 * i + this.centerY, -13158601);
        }
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.drawCenterText(matrix, "Retrogen Generators", 4, -95, 0x404040);
        this.drawLeftText(matrix, this.offset + "/" + Math.max(0, this.features.size() - 9), 114, -85, 0x404040);
        int startY = -71;
        for (int i2 = 0; i2 + this.offset < this.features.size() && i2 < 9; ++i2) {
            ResourceLocation location = this.features.get(i2 + this.offset);
            TextFormatting format = RetrogenManager.INSTANCE.isActive(location) ? TextFormatting.GREEN : TextFormatting.DARK_RED;
            this.drawText(matrix, format + ChunkLogger.toPascalCase(location.func_110623_a()) + TextFormatting.RESET + " (" + TextFormatting.BLUE + ChunkLogger.toPascalCase(location.func_110624_b()) + TextFormatting.RESET + ")", -144, startY, 0x404040);
            startY += 17;
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        int scrolling = (int)scroll;
        if (scrolling != 0) {
            this.offset = MathHelper.func_76125_a((int)(this.offset - scrolling), (int)0, (int)Math.max(0, this.features.size() - 9));
            return true;
        }
        return false;
    }
}

