/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.client.gui.WorldScreen;
import pregenerator.client.helpers.IDimensionAcceptor;
import pregenerator.client.helpers.ITypeAcceptor;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.networking.dimrequests.DimensionInfoRequest;
import pregenerator.common.networking.typeRequest.TypeInfoRequest;
import pregenerator.common.networking.typeRequest.TypeRemovalRequest;
import pregenerator.common.tracker.TypeEntry;

public class WorldEntityScreen
extends BasePregenScreen
implements IDimensionAcceptor,
ITypeAcceptor {
    List<ResourceLocation> dimensions = new ObjectArrayList();
    int dimensionIndex = -1;
    List<TypeEntry> entities = new ObjectArrayList();
    int offset = 0;
    int index;
    boolean byName = true;
    Button[] buttonArray = new Button[10];
    String name;

    public WorldEntityScreen(int index, String name) {
        super((ITextComponent)new StringTextComponent("Entity Screen"));
        this.index = index;
        this.name = name;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.sendToServer(new DimensionInfoRequest());
        this.registerButton(-30, 82, 60, 14, "Back", T -> this.back());
        this.registerButton(116, -91, 14, 14, "-", T -> this.move(-1));
        this.registerButton(131, -91, 14, 14, "+", T -> this.move(1));
        this.registerButton(-146, 82, 70, 14, "Sort: Name", this::sort);
        this.buttonArray[9] = this.registerButton(-146, -91, 120, 14, "Dim: " + this.getDimensionName(), T -> this.toggleDimension());
        int yOffset = -75;
        for (int i = 0; i < 9; ++i) {
            int index = i;
            this.buttonArray[i] = this.registerButton(95, yOffset, 50, 16, "Remove", T -> this.trigger(index));
            yOffset += 17;
        }
    }

    private void sort(Button button) {
        this.byName = !this.byName;
        button.func_238482_a_((ITextComponent)new StringTextComponent(this.byName ? "Sort: Name" : "Sort: Count"));
        this.sortList();
    }

    private void trigger(int index) {
        if ((index += this.offset) >= 0 && index < this.entities.size()) {
            this.sendToServer(new TypeRemovalRequest(this.index, this.dimensions.get(this.dimensionIndex), this.entities.get(index).getLocation()));
        }
    }

    public void sortList() {
        this.entities.sort((K, V) -> this.byName ? String.CASE_INSENSITIVE_ORDER.compare(K.getLocation().func_110623_a(), V.getLocation().func_110623_a()) : Integer.compareUnsigned(V.getCount(), K.getCount()));
    }

    private void toggleDimension() {
        if (this.dimensions.isEmpty()) {
            return;
        }
        this.setDimension((this.dimensionIndex + 1) % this.dimensions.size());
    }

    private void move(int shift) {
        this.offset = MathHelper.func_76125_a((int)(this.offset + shift), (int)0, (int)Math.max(0, this.entities.size() - 9));
    }

    private void back() {
        this.getMinecraft().func_147108_a((Screen)new WorldScreen());
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.tick % 1000 == 0) {
            this.sendToServer(new DimensionInfoRequest());
        }
        if (this.tick % 40 == 0) {
            this.requestData();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int i;
        for (i = 0; i < 9; ++i) {
            this.buttonArray[i].field_230694_p_ = this.offset + i < this.entities.size();
        }
        this.buttonArray[9].field_230693_o_ = this.dimensions.size() > 0;
        this.func_230446_a_(matrix);
        this.drawRectangle(matrix, 150, 100, 0, 0, -3750202, false);
        this.drawRectangle(matrix, 145, 76, 0, 1, -7631989, true);
        for (i = 0; i < 8; ++i) {
            this.func_238465_a_(matrix, this.centerX - 145, this.centerX + 144, -59 + 17 * i + this.centerY, -13158601);
        }
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.drawCenterText(matrix, this.name, 4, -99, 0x404040);
        this.drawLeftText(matrix, this.offset + "/" + Math.max(0, this.entities.size() - 9), 114, -85, 0x404040);
        int startY = -71;
        for (int i2 = 0; i2 + this.offset < this.entities.size() && i2 < 9; ++i2) {
            TypeEntry entry = this.entities.get(this.offset + i2);
            this.drawText(matrix, TextFormatting.GOLD + ChunkLogger.toPascalCase(entry.getLocation().func_110623_a()) + TextFormatting.RESET + " (" + TextFormatting.BLUE + ChunkLogger.toPascalCase(entry.getLocation().func_110624_b()) + TextFormatting.RESET + "): " + entry.getCount(), -144, startY, 0x404040);
            startY += 17;
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        int scrolling = (int)scroll;
        if (scrolling != 0) {
            this.offset = MathHelper.func_76125_a((int)(this.offset - scrolling), (int)0, (int)Math.max(0, this.entities.size() - 9));
            return true;
        }
        return false;
    }

    public String getDimensionName() {
        return this.dimensionIndex < 0 || this.dimensionIndex > this.dimensions.size() ? "Loading" : ChunkLogger.toPascalCase(this.dimensions.get(this.dimensionIndex).func_110623_a());
    }

    @Override
    public void onDimensionSync(List<ResourceLocation> location) {
        ResourceLocation oldDim = this.dimensionIndex < 0 || this.dimensionIndex >= this.dimensions.size() ? null : this.dimensions.get(this.dimensionIndex);
        this.dimensions.clear();
        this.dimensions.addAll(location);
        int newIndex = this.dimensions.indexOf(oldDim);
        if (newIndex != this.dimensionIndex) {
            this.dimensionIndex = newIndex;
            this.requestData();
        } else if (this.dimensionIndex == -1) {
            this.setDimension(Math.max(0, this.dimensions.indexOf(World.field_234918_g_.func_240901_a_())));
        }
    }

    @Override
    public void onTypesSynced(int index, List<TypeEntry> types) {
        if (index != this.index) {
            return;
        }
        this.entities.clear();
        this.entities.addAll(types);
        this.sortList();
    }

    public void setDimension(int index) {
        if (this.dimensionIndex == index) {
            this.requestData();
            return;
        }
        if (index < 0 || index >= this.dimensions.size()) {
            return;
        }
        this.dimensionIndex = index;
        this.buttonArray[9].func_238482_a_((ITextComponent)new StringTextComponent("Dim: " + this.getDimensionName()));
        this.entities.clear();
        this.requestData();
    }

    public void requestData() {
        if (this.dimensionIndex < 0 || this.dimensionIndex >= this.dimensions.size()) {
            this.entities.clear();
            return;
        }
        this.sendToServer(new TypeInfoRequest(this.index, this.dimensions.get(this.dimensionIndex)));
    }
}

