/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.data;

import java.awt.Color;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import pregenerator.client.preview.data.tasks.ITask;
import pregenerator.client.preview.texture.DisplayTexture;
import pregenerator.client.preview.world.IFileProvider;
import pregenerator.client.preview.world.IHeightProvider;

public class ChunkData
implements ITask {
    public static final int[][] DATA = ChunkData.createArray();
    public static final int A = -16777216;
    boolean slimeChunk;
    boolean chunkFinished;
    int x;
    int z;
    int[] height = new int[256];
    int[] blockColors = new int[256];
    int[] biomeIds = new int[256];
    int[] originalColor = null;
    int[] grassColor = new int[256];
    int[] foliageColor = new int[256];

    private ChunkData() {
    }

    public ChunkData(IChunk chunk, long seed, boolean roof) {
        this.slimeChunk = SharedSeedRandom.func_205190_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b, (long)seed, (long)987234911L).nextInt(10) == 0;
        this.chunkFinished = chunk.func_201589_g() == ChunkStatus.field_222617_m;
        this.x = chunk.func_76632_l().field_77276_a;
        this.z = chunk.func_76632_l().field_77275_b;
        this.originalColor = new int[256];
        ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.BIOMES;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int index = z * 16 + x;
                int y = roof ? this.findLowestBlock(chunk, this.x * 16 + x, this.z * 16 + z) : chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE).func_202273_a(x, z);
                BlockPos pos = new BlockPos(this.x * 16 + x, 64, this.z * 16 + z);
                Biome biome = chunk.func_225549_i_().func_225526_b_(this.x * 16 + x, y, this.z * 16 + z);
                this.biomeIds[index] = registry.getID(biome.getRegistryName());
                this.grassColor[index] = biome.func_225528_a_((double)pos.func_177958_n(), (double)pos.func_177952_p());
                this.foliageColor[index] = biome.func_225527_a_();
                BlockState state = chunk.func_180495_p(new BlockPos(this.x * 16 + x, y - 1, this.z * 16 + z));
                this.blockColors[index] = state.func_196958_f() ? DisplayTexture.BACKGROUND_COLOR : state.func_185904_a().func_151565_r().func_151643_b(0);
                this.originalColor[index] = this.blockColors[index];
                this.height[index] = roof ? this.findLowestFluid(chunk, this.x * 16 + x, this.z * 16 + z) : chunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR).func_202273_a(x, z);
            }
        }
    }

    private int findLowestBlock(IChunk chunk, int x, int z) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(x, 64, z);
        while (chunk.func_180495_p((BlockPos)mutable).func_196958_f() && mutable.func_177956_o() > 0) {
            mutable.func_189536_c(Direction.DOWN);
        }
        return mutable.func_177956_o() + 1;
    }

    private int findLowestFluid(IChunk chunk, int x, int z) {
        BlockState state;
        BlockPos.Mutable mutable = new BlockPos.Mutable(x, 64, z);
        while (mutable.func_177956_o() > 0 && ((state = chunk.func_180495_p((BlockPos)mutable)).func_196958_f() || !state.func_185904_a().func_76230_c())) {
            mutable.func_189536_c(Direction.DOWN);
        }
        return mutable.func_177956_o();
    }

    public long getPosition() {
        return ChunkPos.func_77272_a((int)this.x, (int)this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isSlimeChunk() {
        return this.slimeChunk;
    }

    public boolean isDone() {
        return this.chunkFinished;
    }

    public int[] getHeights() {
        return this.height;
    }

    public Biome getBiome(int index) {
        return (Biome)((ForgeRegistry)ForgeRegistries.BIOMES).getValue(this.biomeIds[index]);
    }

    public int[] getData(int view) {
        if ((view & 4) != 0) {
            return DATA[this.chunkFinished ? 1 : 0];
        }
        switch (view) {
            case 1: {
                return this.foliageColor;
            }
            case 2: {
                return this.grassColor;
            }
        }
        return this.blockColors;
    }

    public void finalizeHeightData(IHeightProvider provider) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int xPos = this.x * 16 + x;
                int zPos = this.z * 16 + z;
                int index = z * 16 + x;
                if (this.originalColor[index] == DisplayTexture.BACKGROUND_COLOR) continue;
                if (this.isDarker(xPos, zPos, provider)) {
                    this.blockColors[index] = ChunkData.darker(this.originalColor[index], 0.8f);
                    continue;
                }
                if (!this.isBrigther(xPos, zPos, provider)) continue;
                this.blockColors[index] = ChunkData.brighter(this.originalColor[index], 0.8f);
            }
        }
    }

    @Override
    public void handleTask(FileChannel chunkData, FileChannel heightData, IFileProvider provider) throws IOException {
        int i;
        provider.setChunkProgress(this.x, this.z, this.chunkFinished);
        ByteBuffer buffer = ByteBuffer.allocate((int)IFileProvider.FileType.CHUNK_DATA.getOffset());
        buffer.put((byte)1);
        buffer.putInt(this.x).putInt(this.z).put((byte)((this.slimeChunk ? 1 : 0) | (this.chunkFinished ? 2 : 0)));
        for (i = 0; i < 256; ++i) {
            buffer.put((byte)(this.blockColors[i] & 0xFF));
            buffer.put((byte)(this.blockColors[i] >> 8 & 0xFF));
            buffer.put((byte)(this.blockColors[i] >> 16 & 0xFF));
        }
        for (i = 0; i < 256; ++i) {
            buffer.putInt(this.biomeIds[i]);
        }
        buffer.flip();
        chunkData.position(provider.getOrCreate(this.x, this.z, IFileProvider.FileType.CHUNK_DATA));
        chunkData.write(buffer);
        buffer = ByteBuffer.allocate((int)IFileProvider.FileType.HEIGHT_DATA.getOffset());
        buffer.put((byte)1);
        for (i = 0; i < 256; ++i) {
            buffer.put((byte)(this.height[i] - 128));
        }
        buffer.flip();
        heightData.position(provider.getOrCreate(this.x, this.z, IFileProvider.FileType.HEIGHT_DATA));
        heightData.write(buffer);
    }

    public static ChunkData createChunkDataFromBuffer(ByteBuffer chunkData, ByteBuffer heightData) {
        int i;
        ChunkData data = new ChunkData();
        data.x = chunkData.getInt();
        data.z = chunkData.getInt();
        byte flags = chunkData.get();
        data.slimeChunk = (flags & 1) != 0;
        data.chunkFinished = (flags & 2) != 0;
        for (i = 0; i < 256; ++i) {
            byte r = chunkData.get();
            byte g = chunkData.get();
            byte b = chunkData.get();
            data.blockColors[i] = 0xFF000000 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
        }
        for (i = 0; i < 256; ++i) {
            data.biomeIds[i] = chunkData.getInt();
        }
        BlockPos.Mutable pos = new BlockPos.Mutable();
        ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.BIOMES;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                pos.func_181079_c(data.x * 16 + x, 64, data.z * 16 + z);
                Biome subBiome = (Biome)registry.getValue(data.biomeIds[z << 4 | x]);
                data.foliageColor[z << 4 | x] = subBiome.func_225527_a_();
                data.grassColor[z << 4 | x] = subBiome.func_225528_a_((double)pos.func_177958_n(), (double)pos.func_177952_p());
            }
        }
        if (heightData.get() <= 0) {
            data.height = new int[0];
        } else {
            for (int i2 = 0; i2 < data.height.length; ++i2) {
                data.height[i2] = heightData.get() + 128;
            }
        }
        return data;
    }

    protected boolean isDarker(int x, int z, IHeightProvider map) {
        int base = map.get(x, z, 0);
        return this.isEnoughSmaller(base, map.get(x, z + 1, base)) || this.isEnoughSmaller(base, map.get(x + 1, z, base));
    }

    protected boolean isBrigther(int x, int z, IHeightProvider map) {
        int base = map.get(x, z, 0);
        return this.isEnoughBigger(base, map.get(x + 1, z, base)) || this.isEnoughBigger(base, map.get(x, z + 1, base));
    }

    protected boolean isEnoughBigger(int base, int other) {
        return base >= other ? false : other - base <= 3;
    }

    protected boolean isEnoughSmaller(int base, int other) {
        return base <= other ? false : base - other <= 3;
    }

    public static int darker(int color, float factor) {
        int r = Math.max(0, (int)((float)(color >> 16 & 0xFF) * factor));
        int g = Math.max(0, (int)((float)(color >> 8 & 0xFF) * factor));
        int b = Math.max(0, (int)((float)(color & 0xFF) * factor));
        return color & 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int brighter(int color, float factor) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int i = (int)(1.0 / (1.0 - (double)factor));
        if (r == 0 && g == 0 && b == 0) {
            return color & 0xFF000000 | (i & 0xFF) << 16 | (i & 0xFF) << 8 | i & 0xFF;
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return color & 0xFF000000 | Math.min(255, (int)((float)r / factor)) << 16 | Math.min(255, (int)((float)g / factor)) << 8 | Math.min(255, (int)((float)b / factor));
    }

    static int[][] createArray() {
        int[][] data = new int[2][256];
        Arrays.fill(data[0], DisplayTexture.sortColors(Color.RED.darker().getRGB()));
        Arrays.fill(data[1], DisplayTexture.sortColors(Color.GREEN.getRGB()));
        return data;
    }
}

