/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.data;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.File;
import net.minecraft.util.ResourceLocation;
import pregenerator.client.preview.world.ChunkCache;
import pregenerator.client.preview.world.WorldSeed;

public class MapDataManager
implements Runnable {
    Thread thread;
    boolean alive = true;
    Object2ObjectMap<ResourceLocation, ChunkCache> dimensions = new Object2ObjectLinkedOpenHashMap();

    public MapDataManager() {
        this.thread = new Thread((Runnable)this, "Preview-Map-Manager");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void run() {
        while (this.alive) {
            try {
                for (ChunkCache dim : this.dimensions.values()) {
                    dim.update();
                }
                Thread.sleep(1L);
            }
            catch (Exception e) {
                if (!this.alive) {
                    return;
                }
                e.printStackTrace();
            }
        }
    }

    public void kill() {
        if (this.alive) {
            this.alive = false;
            try {
                this.thread.interrupt();
                this.thread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.thread = null;
            this.clearDimensions();
            System.gc();
        }
    }

    public void clearDimensions() {
        for (ChunkCache dim : this.dimensions.values()) {
            dim.close();
        }
        this.dimensions.clear();
    }

    public void removeDimension(ResourceLocation location) {
        ChunkCache cache = (ChunkCache)this.dimensions.remove((Object)location);
        if (cache != null) {
            cache.close();
        }
    }

    public ChunkCache generateForDimension(ResourceLocation id) {
        ChunkCache cache = (ChunkCache)this.dimensions.get((Object)id);
        if (cache == null) {
            try {
                File path = WorldSeed.getMapFolder();
                path.mkdirs();
                File chunk = new File(path, "Chunk_DIM_" + id.func_110623_a() + "_" + id.func_110624_b());
                File height = new File(path, "Height_DIM_" + id.func_110623_a() + "_" + id.func_110624_b());
                cache = new ChunkCache(chunk, height);
                this.dimensions.put((Object)id, (Object)cache);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cache;
    }
}

