/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.data.tasks;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import pregenerator.client.preview.PreviewScreen;
import pregenerator.client.preview.data.ChunkData;
import pregenerator.client.preview.data.tasks.ITask;
import pregenerator.client.preview.texture.DisplayTexture;
import pregenerator.client.preview.world.ChunkCache;
import pregenerator.client.preview.world.IFileProvider;
import pregenerator.client.preview.world.WorldData;
import pregenerator.common.structures.StructureRef;

public class CreateScreenshotTask
implements Runnable {
    WorldData data;
    File folder;
    IntList tasks;
    int overlays;

    public CreateScreenshotTask(WorldData data, File folder, IntList tasks, int overlays) {
        this.data = data;
        this.folder = folder;
        this.tasks = tasks;
        this.overlays = overlays;
    }

    @Override
    public void run() {
        Graphics2D g;
        int offset;
        int i;
        int size = this.data.getRadius() * 32;
        BufferedImage[] images = new BufferedImage[this.tasks.size()];
        for (int i2 = 0; i2 < images.length; ++i2) {
            images[i2] = new BufferedImage(size, size, 2);
        }
        ChunkCache cache = this.data.getCache();
        FileChannel chunkData = cache.getChunkData();
        int total = cache.getStored();
        for (i = 0; i < total; i += 1024) {
            try {
                this.readChunks(images, i, MathHelper.func_76125_a((int)(total - i), (int)0, (int)1024), chunkData);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((this.overlays & 1) != 0) {
            offset = this.data.getRadius() * 16;
            for (int i3 = 0; i3 < images.length; ++i3) {
                g = images[i3].createGraphics();
                g.setColor(new Color(PreviewScreen.SLIME_COLOR, true));
                LongIterator longIterator = this.data.getSlimeChunks().iterator();
                while (longIterator.hasNext()) {
                    long pos = (Long)longIterator.next();
                    int minX = ChunkPos.func_212578_a((long)pos) * 16 + offset;
                    int minY = ChunkPos.func_212579_b((long)pos) * 16 + offset;
                    g.fillRect(minX, minY, 16, 16);
                }
                g.dispose();
            }
        }
        if ((this.overlays & 2) != 0) {
            offset = this.data.getRadius() * 16;
            for (int i4 = 0; i4 < images.length; ++i4) {
                g = images[i4].createGraphics();
                int radius = this.data.getRadius() * 16;
                List<StructureRef> references = this.data.getStructures();
                int m = references.size();
                for (int x = 0; x < m; ++x) {
                    StructureRef ref = references.get(x);
                    String name = ref.getName();
                    boolean mineshaft = name.equalsIgnoreCase("minecraft:mineshaft");
                    if (mineshaft && (this.overlays & 4) == 0) continue;
                    int growth = ref.getSize() <= 50 ? 20 : 0;
                    int color = Integer.MIN_VALUE | (mineshaft ? 0xFF0000 : (name.hashCode() & 0xAAAAAA) + 0x444444 & 0xFFFFFF);
                    int[] bounds = ref.getBounds();
                    if (bounds[3] <= -radius || bounds[0] >= radius || bounds[5] <= -radius || bounds[2] >= radius) continue;
                    g.setColor(new Color(color, true));
                    g.fillRect(bounds[0] + offset - growth, bounds[2] + offset - growth, bounds[3] - bounds[0] + growth * 2, bounds[5] - bounds[2] + growth * 2);
                    g.setColor(Color.RED);
                    g.drawString(ref.getDisplayName(), bounds[0] + offset, bounds[2] + offset);
                }
                g.dispose();
            }
        }
        try {
            for (i = 0; i < images.length; ++i) {
                ImageIO.write((RenderedImage)images[i], "png", new File(this.folder, this.data.getScreenName(this.tasks.getInt(i), this.overlays > 0)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readChunks(BufferedImage[] images, long startValue, long size, FileChannel chunkData) throws IOException {
        if (size <= 0L) {
            return;
        }
        int voidColor = this.data.hasSkyLight() ? 0 : -16777216;
        int offset = this.data.getRadius() * 16;
        ByteBuffer chunkBuffer = ITask.readBytes(chunkData, startValue * IFileProvider.FileType.CHUNK_DATA.getOffset(), size * IFileProvider.FileType.CHUNK_DATA.getOffset());
        int k = 0;
        while ((long)k < size) {
            chunkBuffer.position((int)((long)k * IFileProvider.FileType.CHUNK_DATA.getOffset()));
            if (chunkBuffer.get() > 0) {
                ChunkData data = ChunkData.createChunkDataFromBuffer(chunkBuffer, ByteBuffer.wrap(new byte[1]));
                int posX = data.getX() * 16 + offset;
                int posZ = data.getZ() * 16 + offset;
                int m = this.tasks.size();
                for (int i = 0; i < m; ++i) {
                    BufferedImage image = images[i];
                    int[] pixels = data.getData(this.tasks.getInt(i));
                    for (int yPos = 0; yPos < 16; ++yPos) {
                        for (int xPos = 0; xPos < 16; ++xPos) {
                            int color = pixels[yPos * 16 + xPos];
                            image.setRGB(posX + xPos, posZ + yPos, DisplayTexture.unsortColors((0xFF000000 | color) == DisplayTexture.BACKGROUND_COLOR ? voidColor : color));
                        }
                    }
                }
            }
            ++k;
        }
    }
}

