/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.data.tasks;

import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Deque;
import net.minecraft.util.math.MathHelper;
import pregenerator.client.preview.data.ChunkData;
import pregenerator.client.preview.data.tasks.ITask;
import pregenerator.client.preview.world.IFileProvider;

public class ReloadDataTask
implements ITask {
    Deque<Object2IntMap.Entry<ChunkData>> toRender;
    int view;
    boolean done = false;

    public ReloadDataTask(Deque<Object2IntMap.Entry<ChunkData>> toRender, int view) {
        this.toRender = toRender;
        this.view = view;
    }

    @Override
    public void handleTask(FileChannel chunkData, FileChannel heightData, IFileProvider provider) throws IOException {
        int total = provider.getStored();
        for (int i = 0; i < total; i += 1024) {
            this.gatherChunks(i, MathHelper.func_76125_a((int)(total - i), (int)0, (int)1024), chunkData, heightData);
        }
        this.done = true;
    }

    public void gatherChunks(long startValue, long size, FileChannel chunkData, FileChannel heightData) throws IOException {
        if (size <= 0L) {
            return;
        }
        ByteBuffer chunkBuffer = ITask.readBytes(chunkData, startValue * IFileProvider.FileType.CHUNK_DATA.getOffset(), size * IFileProvider.FileType.CHUNK_DATA.getOffset());
        ByteBuffer heigthBuffer = ITask.readBytes(heightData, startValue * IFileProvider.FileType.HEIGHT_DATA.getOffset(), size * IFileProvider.FileType.HEIGHT_DATA.getOffset());
        int k = 0;
        while ((long)k < size) {
            chunkBuffer.position((int)((long)k * IFileProvider.FileType.CHUNK_DATA.getOffset()));
            heigthBuffer.position((int)((long)k * IFileProvider.FileType.HEIGHT_DATA.getOffset()));
            if (chunkBuffer.get() > 0) {
                this.toRender.add((Object2IntMap.Entry<ChunkData>)new AbstractObject2IntMap.BasicEntry((Object)ChunkData.createChunkDataFromBuffer(chunkBuffer, heigthBuffer), this.view));
            }
            ++k;
        }
    }

    public void join() {
        try {
            while (!this.done) {
                Thread.sleep(10L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

