/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.texture;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import pregenerator.client.preview.data.ChunkData;

@OnlyIn(value=Dist.CLIENT)
public class DisplayTexture {
    static final boolean WHITE_COLOR = false;
    public static final int BACKGROUND_COLOR = new Color(139, 139, 139).getRGB();
    static final float[] DEFAULT_COLOR = new Color(139, 139, 139).getColorComponents(new float[3]);
    int width;
    int height;
    int xSize;
    int ySize;
    int[] textures;
    NativeImage helper = new NativeImage(16, 16, true);

    public DisplayTexture(int width, int height) {
        this.width = width;
        this.height = height;
        this.generateTexture(width, height);
        this.clearTexture();
    }

    public void clearTexture() {
        int frame = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36009, (int)frame);
        GL11.glViewport((int)0, (int)0, (int)4096, (int)4096);
        GL11.glDrawBuffer((int)36064);
        for (int i = 0; i < this.textures.length; ++i) {
            GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.textures[i], (int)0);
            GL11.glClearColor((float)DEFAULT_COLOR[0], (float)DEFAULT_COLOR[1], (float)DEFAULT_COLOR[2], (float)1.0f);
            GL11.glClear((int)16384);
        }
        GL30.glDeleteFramebuffers((int)frame);
        GL30.glBindFramebuffer((int)36009, (int)Minecraft.func_71410_x().func_147110_a().field_147616_f);
        MainWindow monitor = Minecraft.func_71410_x().func_228018_at_();
        GL11.glViewport((int)0, (int)0, (int)monitor.func_198109_k(), (int)monitor.func_198091_l());
    }

    public void render(MatrixStack matrix, float xPos, float yPos, ITextureRenderer function) {
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                GlStateManager.func_227760_t_((int)this.textures[this.ySize * x + y]);
                function.render(matrix, xPos + (float)x * 4096.0f, yPos + (float)y * 4096.0f, 4096.0f, 4096.0f);
            }
        }
    }

    public void addData(ChunkData data, int size, int view) {
        int x = data.getX() * 16 + size;
        int z = data.getZ() * 16 + size;
        this.addPixels(x, z, data.getData(view), 16, 16);
    }

    public void addPixels(int x, int y, int[] data, int width, int height) {
        GlStateManager.func_227760_t_((int)this.getTexture(x, y));
        for (int yPos = 0; yPos < height; ++yPos) {
            for (int xPos = 0; xPos < width; ++xPos) {
                int pixel = data[yPos * width + xPos];
                this.helper.func_195700_a(xPos, yPos, pixel);
            }
        }
        this.helper.func_195697_a(0, x % 4096, y % 4096, false);
    }

    public int getTexture(int x, int y) {
        return this.textures[MathHelper.func_76125_a((int)x, (int)0, (int)this.width) / 4096 * this.ySize + MathHelper.func_76125_a((int)y, (int)0, (int)this.height) / 4096];
    }

    private void generateTexture(int width, int height) {
        this.xSize = MathHelper.func_76143_f((double)((double)width / 4096.0));
        this.ySize = MathHelper.func_76143_f((double)((double)height / 4096.0));
        this.textures = new int[this.xSize * this.ySize];
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                int index = this.ySize * x + y;
                this.textures[index] = TextureUtil.func_225678_a_();
                TextureUtil.func_225681_a_((int)this.textures[index], (int)0, (int)4096, (int)4096);
            }
        }
    }

    public void removeTexture() {
        for (int i = 0; i < this.textures.length; ++i) {
            if (this.textures[i] == -1) continue;
            TextureUtil.func_225679_a_((int)this.textures[i]);
            this.textures[i] = -1;
        }
    }

    public static int unsortColors(int color) {
        int r = color & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 16 & 0xFF;
        int a = color >> 24 & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int sortColors(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        int a = color >> 24 & 0xFF;
        return a << 24 | b << 16 | g << 8 | r;
    }

    public static interface ITextureRenderer {
        public void render(MatrixStack var1, float var2, float var3, float var4, float var5);
    }
}

