/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.texture;

import com.mojang.blaze3d.matrix.MatrixStack;
import pregenerator.client.preview.data.ChunkData;
import pregenerator.client.preview.texture.DisplayTexture;

public class MoveableTexture {
    float x;
    float y;
    int width;
    int height;
    DisplayTexture texture;

    public MoveableTexture(int size) {
        this.width = size;
        this.height = size;
        this.centerTexture();
        this.createTexture();
    }

    public void removeTexture() {
        if (this.texture != null) {
            this.texture.removeTexture();
            this.texture = null;
        }
    }

    public void resizeTexture(int newSize) {
        this.removeTexture();
        this.width = newSize;
        this.height = newSize;
        this.createTexture();
    }

    public void createTexture() {
        this.texture = new DisplayTexture(this.width, this.height);
    }

    public void addData(ChunkData data, int size, int view) {
        if (this.texture != null) {
            this.texture.addData(data, size, view);
        }
    }

    public void render(DisplayTexture.ITextureRenderer renderer, MatrixStack matrix) {
        if (this.texture != null) {
            this.texture.render(matrix, this.x, this.y, renderer);
        }
    }

    public void clearTexture() {
        if (this.texture == null) {
            return;
        }
        this.texture.clearTexture();
    }

    public void centerTexture() {
        this.x = -((float)this.width / 2.0f);
        this.y = -((float)this.height / 2.0f);
    }

    public void moveTexture(float xMove, float yMove) {
        this.x += xMove;
        this.y += yMove;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }
}

