/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.Consumer;
import pregenerator.client.preview.data.ChunkData;
import pregenerator.client.preview.world.IHeightProvider;

public class HeightProcessor {
    Long2ObjectMap<ChunkData> todoList = new Long2ObjectLinkedOpenHashMap();

    public synchronized void addChunk(ChunkData data) {
        this.todoList.put(data.getPosition(), (Object)data);
    }

    public synchronized void process(boolean force, IHeightProvider provider, Consumer<ChunkData> result) {
        ObjectIterator iter = this.todoList.long2ObjectEntrySet().iterator();
        while (iter.hasNext()) {
            Long2ObjectMap.Entry data = (Long2ObjectMap.Entry)iter.next();
            if (!this.canProcess((ChunkData)data.getValue(), provider, force)) continue;
            result.accept((ChunkData)data.getValue());
            iter.remove();
        }
    }

    public boolean canProcess(ChunkData data, IHeightProvider provider, boolean force) {
        if (force || this.canGenerate(data.getX(), data.getZ(), provider)) {
            data.finalizeHeightData(provider);
            return true;
        }
        return false;
    }

    public boolean canGenerate(int x, int z, IHeightProvider map) {
        return map.has(x + 1, z) && map.has(x, z + 1);
    }
}

