/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.world;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.LongPredicate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import pregenerator.client.preview.data.ChunkData;
import pregenerator.client.preview.data.tasks.GetChunkTask;
import pregenerator.client.preview.data.tasks.ITask;
import pregenerator.client.preview.data.tasks.ReloadDataTask;
import pregenerator.client.preview.texture.MoveableTexture;
import pregenerator.client.preview.world.ChunkCache;
import pregenerator.client.preview.world.HeightProcessor;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.structures.StructureManager;
import pregenerator.common.structures.StructureRef;

public class WorldData {
    static final String[] VIEWS = new String[]{"Blocks", "Biome(Grass)", "Biome(Foliage)"};
    static final ChunkPos CENTER = new ChunkPos(0, 0);
    final ResourceLocation dimension;
    final ChunkCache cache;
    final HeightProcessor processor = new HeightProcessor();
    final Cache<Long, ChunkData> cachedChunks = CacheBuilder.newBuilder().maximumSize(64L).expireAfterAccess(30L, TimeUnit.SECONDS).build();
    final boolean roof;
    final boolean skyLight;
    long seed;
    boolean isFocus;
    boolean square = true;
    int radius;
    LongSet slimeChunks = new LongLinkedOpenHashSet();
    Deque<IChunk> newChunks = new ConcurrentLinkedDeque<IChunk>();
    Deque<Object2IntMap.Entry<ChunkData>> toRender = new ConcurrentLinkedDeque<Object2IntMap.Entry<ChunkData>>();

    public WorldData(ResourceLocation dimension, ChunkCache cache, long seed, boolean roof, boolean skyLight, boolean square) {
        this.dimension = dimension;
        this.cache = cache;
        this.square = square;
        this.roof = roof;
        this.skyLight = skyLight;
        this.isFocus = true;
        this.setSeed(seed);
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public boolean toggleSquare() {
        this.square = !this.square;
        return this.square;
    }

    public boolean isSquare() {
        return this.square;
    }

    public int getRadius() {
        return this.radius;
    }

    public ChunkCache getCache() {
        return this.cache;
    }

    public boolean isFocused() {
        return this.isFocus;
    }

    public LongPredicate createPredicate() {
        return this::contains;
    }

    private boolean contains(long value) {
        int chunkZ;
        int chunkX = ChunkPos.func_212578_a((long)value);
        if (this.isInRange(chunkX, chunkZ = ChunkPos.func_212579_b((long)value))) {
            return this.cache.has(chunkX, chunkZ) && this.cache.isChunkLit(chunkX, chunkZ);
        }
        return true;
    }

    public String getScreenName(int view, boolean overlay) {
        return "Screenshot_" + this.dimension.func_110623_a() + "_" + this.dimension.func_110624_b() + "_" + VIEWS[view] + (overlay ? "_overlay" : "") + ".png";
    }

    public void setFocus(ResourceLocation active, int view) {
        this.isFocus = this.dimension.equals((Object)active);
        if (this.isFocus) {
            this.reload(view);
        } else {
            this.toRender.clear();
        }
    }

    public void reload(int view) {
        this.cache.addTask(new ReloadDataTask(this.toRender, view));
    }

    public void addChunk(IChunk chunk) {
        if (this.isInRange(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b)) {
            this.newChunks.add(chunk);
        }
    }

    private boolean isInRange(int chunkX, int chunkZ) {
        return this.square && (chunkX >= -this.radius || chunkX < this.radius || chunkZ >= -this.radius || chunkZ < this.radius) || !this.square && !this.outsideDistance(chunkX, chunkZ);
    }

    public boolean outsideDistance(int x, int z) {
        long d1 = -x;
        long d3 = -z;
        return d1 * d1 + d3 * d3 >= (long)(this.radius * this.radius);
    }

    public void render(MoveableTexture texture) {
        int m = Math.max(1000, this.toRender.size() / 10);
        for (int i = 0; i < m && !this.toRender.isEmpty(); ++i) {
            Object2IntMap.Entry<ChunkData> entry = this.toRender.removeFirst();
            ChunkData data = (ChunkData)entry.getKey();
            if (data.getX() < -this.radius || data.getX() >= this.radius || data.getZ() < -this.radius || data.getZ() >= this.radius) continue;
            texture.addData(data, this.radius * 16, entry.getIntValue());
        }
    }

    public void update(int view, Executor executor) {
        for (int i = 0; i < 100 && !this.newChunks.isEmpty(); ++i) {
            ChunkData data = new ChunkData(this.newChunks.removeFirst(), this.seed, this.roof);
            this.cache.store(data.getX(), data.getZ(), data.getHeights());
            if (data.isSlimeChunk()) {
                this.slimeChunks.add(data.getPosition());
            }
            this.cache.addTask(data);
            this.processor.addChunk(data);
            if (!this.isFocus) continue;
            this.toRender.add((Object2IntMap.Entry<ChunkData>)new AbstractObject2IntMap.BasicEntry((Object)data, view));
        }
        executor.execute(() -> this.process(view));
    }

    private void process(int view) {
        this.processor.process(!ServerManager.INSTANCE.isRunning((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)this.dimension)), this.cache, T -> {
            this.cache.addTask((ITask)T);
            if (this.isFocus) {
                this.toRender.add((Object2IntMap.Entry<ChunkData>)new AbstractObject2IntMap.BasicEntry(T, view));
            }
        });
    }

    public ChunkData getData(int x, int z) {
        if (!this.cache.has(x, z)) {
            return null;
        }
        long pos = ChunkPos.func_77272_a((int)x, (int)z);
        ChunkData data = (ChunkData)this.cachedChunks.getIfPresent((Object)pos);
        if (data == null) {
            GetChunkTask task = new GetChunkTask(x, z, this.cachedChunks);
            this.cache.addTask(task);
            task.join(2L);
            data = task.getData();
        }
        return data;
    }

    public LongSet getSlimeChunks() {
        return this.slimeChunks;
    }

    public List<StructureRef> getStructures() {
        return StructureManager.INSTANCE.getTrackers((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)this.dimension));
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public boolean hasSkyLight() {
        return this.skyLight;
    }
}

