/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.world;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldOptionsScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.WorldGenSettingsExport;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.listener.ChainedChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.TrackingChunkStatusListener;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pregenerator.client.preview.world.CustomServer;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.ReflectionHelper;

public class WorldSeed {
    private static final Logger LOGGER = LogManager.getLogger((String)"Preview Loader");
    CreateWorldScreen prev;
    Screen mainMenu;
    TextFieldWidget seedField;
    TextFieldWidget nameField;
    String folder;
    String name;
    long seed;
    WorldSettings settings;

    public WorldSeed(CreateWorldScreen original) {
        this.prev = original;
        this.mainMenu = (Screen)ReflectionHelper.getValueSave(CreateWorldScreen.class, original, new String[]{"parentScreen", "field_146332_f"});
        this.nameField = (TextFieldWidget)ReflectionHelper.getValueSave(CreateWorldScreen.class, original, new String[]{"worldNameField", "field_146333_g"});
        this.seedField = (TextFieldWidget)ReflectionHelper.getValueSave(WorldOptionsScreen.class, original.field_238934_c_, new String[]{"field_239033_g_", "field_239033_g_"});
        this.folder = (String)ReflectionHelper.getValueSave(CreateWorldScreen.class, original, new String[]{"saveDirName", "field_146336_i"});
        this.loadSeed();
    }

    public void setSeed(String seedName) {
        this.seedField.func_146180_a(seedName);
        ReflectionHelper.setValueSave(CreateWorldScreen.class, this.prev, seedName, "worldSeed", "field_219022_p");
        this.loadSeed();
    }

    public CustomServer createServer() {
        return WorldSeed.createCustomServer("Preview", this.settings, this.prev.field_238934_c_.func_239054_a_(this.settings.func_234954_c_()), this.prev.field_238934_c_.func_239055_b_(), this.settings.func_234958_g_());
    }

    public static CustomServer createCustomServer(String saveName, WorldSettings world, DimensionGeneratorSettings dimGenerator, DynamicRegistries.Impl registries, DatapackCodec dataCodec) {
        Minecraft.PackManager minecraft$packmanager;
        SaveFormat.LevelSave saveformat$levelsave;
        Minecraft mc = Minecraft.func_71410_x();
        try {
            saveformat$levelsave = mc.func_71359_d().func_237274_c_(saveName);
        }
        catch (IOException ioexception2) {
            LOGGER.warn("Failed to read level {} data", (Object)saveName, (Object)ioexception2);
            return null;
        }
        try {
            minecraft$packmanager = mc.func_238189_a_(registries, T -> dataCodec, (save, registry, manager, codec) -> {
                WorldGenSettingsExport worldgensettingsexport = WorldGenSettingsExport.func_240896_a_((DynamicOps)JsonOps.INSTANCE, (DynamicRegistries)registry);
                WorldSettingsImport worldsettingsimport = WorldSettingsImport.func_244335_a((DynamicOps)JsonOps.INSTANCE, (IResourceManager)manager, (DynamicRegistries.Impl)registry);
                DataResult dataresult = DimensionGeneratorSettings.field_236201_a_.encodeStart((DynamicOps)worldgensettingsexport, (Object)dimGenerator).setLifecycle(Lifecycle.stable()).flatMap(json -> DimensionGeneratorSettings.field_236201_a_.parse((DynamicOps)worldsettingsimport, json));
                DimensionGeneratorSettings dimSettings = dataresult.resultOrPartial(Util.func_240982_a_((String)"Error reading worldgen settings after loading data packs: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).orElse(dimGenerator);
                return new ServerWorldInfo(world, dimSettings, dataresult.lifecycle());
            }, false, saveformat$levelsave);
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to load datapacks, can't proceed with server load", (Throwable)exception);
            try {
                saveformat$levelsave.close();
            }
            catch (IOException ioexception) {
                LOGGER.warn("Failed to unlock access to level {}", (Object)"Preview", (Object)ioexception);
            }
            return null;
        }
        IServerConfiguration iserverconfiguration = minecraft$packmanager.func_238226_c_();
        try {
            saveformat$levelsave.func_237287_a_((DynamicRegistries)registries, iserverconfiguration);
            minecraft$packmanager.func_238225_b_().func_240971_i_();
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(mc.func_110437_J());
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(mc.field_71412_D, MinecraftServer.field_152367_a.getName()));
            SkullTileEntity.func_184293_a((PlayerProfileCache)playerprofilecache);
            SkullTileEntity.func_184294_a((MinecraftSessionService)minecraftsessionservice);
            PlayerProfileCache.func_187320_a((boolean)false);
            CustomServer server = (CustomServer)MinecraftServer.func_240784_a_(thread -> new CustomServer((Thread)thread, mc, registries, saveformat$levelsave, minecraft$packmanager.func_238224_a_(), minecraft$packmanager.func_238225_b_(), iserverconfiguration, minecraftsessionservice, gameprofilerepository, playerprofilecache, radius -> {
                TrackingChunkStatusListener trackingchunkstatuslistener = new TrackingChunkStatusListener(radius + 0);
                trackingchunkstatuslistener.func_219521_a();
                return new ChainedChunkStatusListener((IChunkStatusListener)trackingchunkstatuslistener, T -> {});
            }));
            ReflectionHelper.setValueSave(Minecraft.class, mc, (Object)server, "integratedServer", "field_71437_Z");
            while (!server.func_71200_ad()) {
                Thread.sleep(5L);
            }
            return server;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Starting integrated server");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Starting integrated server");
            crashreportcategory.func_71507_a("Level ID", (Object)"Preview");
            crashreportcategory.func_71507_a("Level Name", (Object)iserverconfiguration.func_76065_j());
            throw new ReportedException(crashreport);
        }
    }

    public void destroyServer(CustomServer server) {
        if (server != null && !server.func_71241_aa()) {
            if (ServerManager.INSTANCE.isRunning()) {
                ServerManager.INSTANCE.removeTask(null, T -> {});
            }
            server.func_71263_m(true);
            ReflectionHelper.setValueSave(Minecraft.class, Minecraft.func_71410_x(), null, "integratedServer", "field_71437_Z");
        }
    }

    private void loadSeed() {
        this.name = this.nameField.func_146179_b();
        long textSeed = WorldSeed.makeSeed(this.seedField.func_146179_b());
        this.seed = textSeed == 0L ? new Random().nextLong() : textSeed;
        this.seedField.func_146180_a(Long.toString(this.seed));
        if (this.settings == null) {
            this.createSettings();
        }
    }

    private void createSettings() {
        Object obj = ReflectionHelper.getValueSave(CreateWorldScreen.class, this.prev, new String[]{"field_228197_f_", "field_228197_f_"});
        GameType type = (GameType)ReflectionHelper.getValueSave(obj.getClass(), obj, "field_228218_f_", "field_228218_f_");
        boolean hardcore = (Boolean)ReflectionHelper.getValueSave(CreateWorldScreen.class, this.prev, new String[]{"hardCoreMode", "field_146337_w"});
        Difficulty diff = (Difficulty)ReflectionHelper.getValueSave(CreateWorldScreen.class, this.prev, new String[]{"field_238937_w_", "field_238937_w_"});
        GameRules rules = (GameRules)ReflectionHelper.getValueSave(CreateWorldScreen.class, this.prev, new String[]{"field_238932_M_", "field_238932_M_"});
        boolean cheats = (Boolean)ReflectionHelper.getValueSave(CreateWorldScreen.class, this.prev, new String[]{"allowCheats", "field_146340_t"});
        DatapackCodec codec = (DatapackCodec)ReflectionHelper.getValueSave(CreateWorldScreen.class, this.prev, new String[]{"field_238933_b_", "field_238933_b_"});
        this.settings = new WorldSettings(this.name, type, hardcore, diff, cheats && !hardcore, rules, codec);
    }

    public static long makeSeed(String input) {
        try {
            return !StringUtils.func_151246_b((String)input) ? Long.parseLong(input) : 0L;
        }
        catch (NumberFormatException var7) {
            return input.hashCode();
        }
    }

    public static File getPreviewFolder() {
        return new File(Minecraft.func_71410_x().field_71412_D, "saves/Preview");
    }

    public static File getMapFolder() {
        return new File(WorldSeed.getPreviewFolder(), "previewData");
    }

    public static void removePreview() {
        WorldSeed.remove(WorldSeed.getPreviewFolder(), false);
    }

    public static void remove(File file, boolean itself) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File subFile : file.listFiles()) {
                    WorldSeed.remove(subFile, true);
                }
            }
            if (itself) {
                file.delete();
            }
        }
    }

    public Screen getPrevScreen() {
        return this.prev;
    }

    public Screen getMainMenu() {
        return this.mainMenu;
    }

    public String getSeedString() {
        return this.seedField.func_146179_b();
    }

    public long getSeed() {
        return this.seed;
    }

    public String getMapName() {
        return this.folder;
    }
}

