/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.base;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import pregenerator.common.base.GenTaskStorage;
import pregenerator.common.base.ListenerStorage;
import pregenerator.common.base.SimpleTaskStorage;
import pregenerator.common.deleter.tasks.IDeletionTask;

public class TaskStorage
extends WorldSavedData {
    GenTaskStorage storage = new GenTaskStorage(() -> ((TaskStorage)this).func_76185_a());
    SimpleTaskStorage<IDeletionTask> deletion = new SimpleTaskStorage<IDeletionTask>(() -> ((TaskStorage)this).func_76185_a(), IDeletionTask::loadTask, IDeletionTask::saveTask);
    ListenerStorage listeners = new ListenerStorage();

    public TaskStorage() {
        super("pregen_storage");
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.storage.read(nbt.func_74775_l("generation"));
        this.deletion.read(nbt.func_74775_l("deletion"));
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_218657_a("generation", (INBT)this.storage.write(new CompoundNBT()));
        compound.func_218657_a("deletion", (INBT)this.deletion.write(new CompoundNBT()));
        return compound;
    }

    public static GenTaskStorage getGenStorage() {
        return TaskStorage.getStorage().storage;
    }

    public static SimpleTaskStorage<IDeletionTask> getDeletionStorage() {
        return TaskStorage.getStorage().deletion;
    }

    public static ListenerStorage getListeners() {
        return TaskStorage.getStorage().listeners;
    }

    public static TaskStorage getStorage() {
        return (TaskStorage)ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(TaskStorage::new, "pregen_storage");
    }

    public static Set<String> getActiveTasks() {
        ObjectLinkedOpenHashSet s = new ObjectLinkedOpenHashSet();
        s.addAll(TaskStorage.getGenStorage().getActiveTasks());
        s.addAll(TaskStorage.getDeletionStorage().getActiveTasks());
        return s;
    }

    public static Set<String> getTasks() {
        ObjectLinkedOpenHashSet s = new ObjectLinkedOpenHashSet();
        s.addAll(TaskStorage.getGenStorage().getTasks());
        s.addAll(TaskStorage.getDeletionStorage().getTasks());
        return s;
    }
}

