/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import pregenerator.common.commands.arguments.SuggestableEnumArgument;
import pregenerator.common.generator.tasks.BenchmarkTask;
import pregenerator.common.manager.BenchmarkManager;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;

public class BenchmarkCommand {
    public static CommandBuilder createBenchmark() {
        CommandBuilder builder = new CommandBuilder("benchmark");
        builder.addLiteral("info", (Command<CommandSource>)((Command)BenchmarkCommand::info)).pop();
        builder.addLiteral("start", (Command<CommandSource>)((Command)BenchmarkCommand::runBenchmark));
        builder.addArgument("Task-Size", SuggestableEnumArgument.enumArgument(BenchmarkManager.BenchmarkSize.class), (Command<CommandSource>)((Command)BenchmarkCommand::runBenchmark));
        builder.addArgument("Analytics", (ArgumentType<?>)BoolArgumentType.bool(), (Command<CommandSource>)((Command)BenchmarkCommand::runBenchmark)).popTop();
        builder.addLiteral("submit-cache", (Command<CommandSource>)((Command)BenchmarkCommand::submit)).popTop();
        return builder;
    }

    private static int info(CommandContext<CommandSource> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        wrapper.sendFeedBackMessage("The Benchmark command will start a small (40k Chunks) or Big (250k Chunks) task for every Dimension");
        wrapper.sendFeedBackMessage("Once everything is generated a score will be calculated for each dimension and overall.");
        wrapper.sendFeedBackMessage("The score is based on How many Milliseconds it took to generate 1 chunk on average. Lower => Better");
        wrapper.sendFeedBackMessage("On top of that Analytics can be enabled Optionally, or can be send later with submit-cache");
        wrapper.sendFeedBackMessage("If thats the case the result of the Benchmark + Extra data is being send to a Server");
        wrapper.sendFeedBackMessage("Collected Data includes: User Unique Identifier, Session Instance, CPU Info, Provided Ram, World-Seed, Java Version, MC Version, Loaded Mods and Benchmark Results");
        return 0;
    }

    private static int submit(CommandContext<CommandSource> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        if (BenchmarkManager.INSTANCE.reportMass()) {
            wrapper.sendFeedBackMessage("Submitted Cached Results");
            return 0;
        }
        wrapper.sendErrorMessage("Couldn't submit benchmark results. Either nothing Cached or failed to load it");
        return 0;
    }

    private static int runBenchmark(CommandContext<CommandSource> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            wrapper.sendErrorMessage("Benchmark already Running");
            return 0;
        }
        if (wrapper.getSenderId() == null) {
            wrapper.sendErrorMessage("Requires a \"Player\" to start a Benchmark Test");
            return 0;
        }
        boolean small = wrapper.getOrDefault("Task-Size", BenchmarkManager.BenchmarkSize.class, BenchmarkManager.BenchmarkSize.SMALL_TASK).isSmall();
        int index = 0;
        for (RegistryKey type : ServerLifecycleHooks.getCurrentServer().func_240770_D_()) {
            ServerManager.INSTANCE.startTask(new BenchmarkTask("BenchmarkTest_" + index, (RegistryKey<World>)type, small), wrapper.getSenderId(), wrapper);
            ++index;
        }
        BenchmarkManager.INSTANCE.startBenchmark(wrapper.getSenderId(), wrapper.getOrDefault("Analytics", Boolean.class, false));
        return 0;
    }
}

